/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.xml;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.ui.IStorageEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.common.rcp.util.IStorageUtils;
import uk.ac.gda.richbeans.xml.XMLBeanContentDescriber;

public class XMLBeanContentDescriberFactory {
    private static final Logger logger = LoggerFactory.getLogger(XMLBeanContentDescriberFactory.class);
    private static XMLBeanContentDescriberFactory factory = new XMLBeanContentDescriberFactory();
    private Collection<XMLBeanContentDescriber> contentList = Collections.newSetFromMap(new ConcurrentHashMap());
    private Map<String, String> extensionMap;

    private XMLBeanContentDescriberFactory() {
    }

    public static XMLBeanContentDescriberFactory getInstance() {
        return factory;
    }

    public void addDescriber(XMLBeanContentDescriber xMLBeanContentDescriber) {
        try {
            this.contentList.add(xMLBeanContentDescriber);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addFileExtension(String string, String string2) {
        if (this.extensionMap == null) {
            this.extensionMap = new ConcurrentHashMap<String, String>(3);
        }
        this.extensionMap.put(string, string2);
    }

    public String getId(IFile iFile) {
        if (this.extensionMap != null && iFile != null) {
            for (String object : this.extensionMap.keySet()) {
                if (!iFile.getName().endsWith(object)) continue;
                return this.extensionMap.get(object);
            }
        }
        for (XMLBeanContentDescriber xMLBeanContentDescriber : this.contentList) {
            try {
                InputStream inputStream = IStorageUtils.getContents((IStorage)iFile);
                if (xMLBeanContentDescriber.describe(inputStream, null) != 2) continue;
                return xMLBeanContentDescriber.getEditorId();
            }
            catch (Exception exception) {
                logger.error("Unexpected exception attempting to obtain Id", (Throwable)exception);
            }
        }
        return "";
    }

    public String getId(IStorageEditorInput iStorageEditorInput) {
        for (XMLBeanContentDescriber xMLBeanContentDescriber : this.contentList) {
            try {
                InputStream inputStream = IStorageUtils.getContents(iStorageEditorInput.getStorage(), null);
                if (xMLBeanContentDescriber.describe(inputStream, null) != 2) continue;
                return xMLBeanContentDescriber.getEditorId();
            }
            catch (Exception exception) {
                logger.error("Unexpected exception attempting to obtain Id", (Throwable)exception);
            }
        }
        return "";
    }

    public boolean isId(String string) {
        if (string == null) {
            return false;
        }
        for (XMLBeanContentDescriber xMLBeanContentDescriber : this.contentList) {
            if (!string.equals(xMLBeanContentDescriber.getEditorId())) continue;
            return true;
        }
        return false;
    }
}

