/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors.xml.bean;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.richbeans.editors.xml.bean.XMLPartitionScanner;
import uk.ac.gda.util.io.FileUtils;

public class XMLDocumentProvider
extends FileDocumentProvider {
    private Document document;

    protected IDocument createDocument(Object object) throws CoreException {
        this.document = (Document)this.createEmptyDocument();
        this.setupDocument(object, (IDocument)this.document);
        if (this.document != null) {
            XMLPartitioner xMLPartitioner = new XMLPartitioner();
            xMLPartitioner.connect((IDocument)this.document);
            this.document.setDocumentPartitioner((IDocumentPartitioner)xMLPartitioner);
        }
        return this.document;
    }

    public IDocument getDocument(Object object) {
        if (object == null) {
            return this.document;
        }
        return super.getDocument(object);
    }

    public boolean isModifiable(Object object) {
        return true;
    }

    public boolean isReadOnly(Object object) {
        return false;
    }

    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        if (object instanceof FileStoreEditorInput) {
            IEditorInput iEditorInput = (IEditorInput)object;
            String string = EclipseUtils.getFilePath(iEditorInput);
            try {
                FileUtils.write((File)new File(string), (String)this.getDocument(null).get(), (String)"UTF-8");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            super.doSaveDocument(iProgressMonitor, object, iDocument, bl);
        }
    }

    class XMLPartitioner
    extends FastPartitioner {
        XMLPartitioner() {
            super((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
        }
    }
}

