/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.editors.xml;

import com.swtdesigner.SWTResourceManager;
import java.io.File;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.beans.BeansFactory;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.richbeans.editors.DirtyContainer;
import uk.ac.gda.richbeans.editors.xml.bean.ColorManager;
import uk.ac.gda.richbeans.editors.xml.bean.XMLConfiguration;
import uk.ac.gda.richbeans.editors.xml.bean.XMLDocumentProvider;
import uk.ac.gda.util.beans.xml.XMLHelpers;

public class XMLBeanEditor
extends TextEditor {
    private static final Logger logger = LoggerFactory.getLogger(XMLBeanEditor.class);
    private ColorManager colorManager;
    private DirtyContainer container;
    private final URL mappingUrl;
    private final URL schemaUrl;
    private Object editingBean;
    private IDocumentListener documentListener;
    private boolean dirtyOveride = false;

    public XMLBeanEditor(DirtyContainer dirtyContainer, URL uRL, URL uRL2, Object object) throws Exception {
        this.container = dirtyContainer;
        this.mappingUrl = uRL;
        this.schemaUrl = uRL2;
        this.editingBean = object;
        this.colorManager = new ColorManager();
        this.setSourceViewerConfiguration(new XMLConfiguration(this.colorManager, uRL2));
        XMLDocumentProvider xMLDocumentProvider = new XMLDocumentProvider();
        this.setDocumentProvider((IDocumentProvider)xMLDocumentProvider);
    }

    public Object getEditingBean() {
        return this.editingBean;
    }

    public void setEditingBean(Object object) {
        this.editingBean = object;
    }

    public void createPartControl(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        super.createPartControl(composite);
        Control control = composite.getChildren()[0];
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        final Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(16384, 0x1000000, true, false);
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        composite2.setLayout((Layout)gridLayout2);
        Label label = new Label(composite2, 0);
        label.setImage(SWTResourceManager.getImage(XMLBeanEditor.class, "/icons/page_error.png"));
        Label label2 = new Label(composite2, 0);
        label2.setText("Comment tags cannot be saved.");
        composite2.setVisible(false);
        this.documentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            }

            public void documentChanged(DocumentEvent documentEvent) {
                IDocument iDocument = documentEvent.getDocument();
                try {
                    IRegion iRegion = iDocument.getLineInformationOfOffset(documentEvent.getOffset());
                    String string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                    boolean bl = string.indexOf("<!--") > -1;
                    composite2.setVisible(bl);
                }
                catch (BadLocationException badLocationException) {
                    logger.error(badLocationException.getMessage(), (Throwable)badLocationException);
                }
            }
        };
        this.getDocumentProvider().getDocument(null).addDocumentListener(this.documentListener);
    }

    public void dispose() {
        this.getDocumentProvider().getDocument(null).removeDocumentListener(this.documentListener);
        this.colorManager.dispose();
        super.dispose();
    }

    public boolean isDirty() {
        if (this.dirtyOveride) {
            return false;
        }
        this.container.setDirty(super.isDirty());
        return super.isDirty();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        block8: {
            final IFile iFile = this.getIFile();
            iProgressMonitor.beginTask(iFile.getName(), 100);
            try {
                try {
                    this.xmlToBean();
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)new WorkspaceModifyOperation(){

                        protected void execute(IProgressMonitor iProgressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
                            try {
                                XMLHelpers.writeToXML((URL)XMLBeanEditor.this.mappingUrl, (Object)XMLBeanEditor.this.editingBean, (File)iFile.getLocation().toFile());
                                IFile iFile2 = XMLBeanEditor.this.getIFile();
                                if (iFile2 != null) {
                                    iFile2.refreshLocal(0, null);
                                }
                            }
                            catch (Exception exception) {
                                throw new InvocationTargetException(exception);
                            }
                        }
                    });
                    this.container.setDirty(false);
                }
                catch (Exception exception) {
                    try {
                        logger.debug(exception.getMessage(), (Throwable)exception);
                        MessageDialog.openError((Shell)this.getSite().getShell(), (String)"XML Validation Error", (String)("The XML is not valid and cannot be saved.\n\nError message:\n" + XMLBeanEditor.getSantitizedExceptionMessage(exception.getMessage())));
                    }
                    catch (Throwable throwable) {
                        logger.error(throwable.getMessage(), throwable);
                        break block8;
                    }
                    iProgressMonitor.done();
                    return;
                }
            }
            finally {
                iProgressMonitor.done();
            }
        }
    }

    public IFile getIFile() {
        return EclipseUtils.getIFile(this.getEditorInput());
    }

    public static String getSantitizedExceptionMessage(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n > -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public void beanToXML(List<String> list) throws Exception {
        try {
            this.dirtyOveride = true;
            IDocument iDocument = this.getDocumentProvider().getDocument(null);
            StringWriter stringWriter = new StringWriter();
            Object object = BeansFactory.deepClone((Object)this.editingBean);
            if (list != null) {
                for (String string : list) {
                    BeansFactory.setBeanValue((Object)object, (String)string, null);
                }
            }
            try {
                XMLHelpers.writeToXML((URL)this.mappingUrl, (Object)object, (StringWriter)stringWriter);
            }
            catch (Exception exception) {
                logger.error(exception.getMessage(), (Throwable)exception);
            }
            iDocument.set(stringWriter.toString());
        }
        catch (Throwable throwable) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    XMLBeanEditor.this.dirtyOveride = false;
                }
            });
            throw throwable;
        }
        this.getSite().getShell().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
    }

    public void xmlToBean() throws Exception {
        IDocument iDocument = this.getDocumentProvider().getDocument(null);
        XMLHelpers.setFromXML((Object)this.editingBean, (URL)this.mappingUrl, (URL)this.schemaUrl, (String)iDocument.get());
    }
}

