/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.wrappers;

import com.swtdesigner.SWTResourceManager;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.nfunk.jep.JEP;
import swing2swt.layout.BorderLayout;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.ButtonComposite;
import uk.ac.gda.richbeans.event.ValueEvent;

public class TextWrapper
extends ButtonComposite
implements IFieldWidget {
    protected static final Color BLUE = SWTResourceManager.getColor(9);
    protected static final Color RED = SWTResourceManager.getColor(3);
    protected static final Color BLACK = SWTResourceManager.getColor(2);
    protected static final Color DARK_RED = SWTResourceManager.getColor(4);
    private JEP jepParser;
    private TEXT_TYPE textType = TEXT_TYPE.FREE_TXT;
    protected Text text;
    private ModifyListener modifyListener;
    private boolean multiLineMode = false;

    public TEXT_TYPE getTextType() {
        return this.textType;
    }

    public void setTextType(TEXT_TYPE tEXT_TYPE) {
        this.textType = tEXT_TYPE;
    }

    public TextWrapper(Composite composite, int n) {
        super(composite, 0);
        this.setLayout(new BorderLayout());
        this.text = new Text((Composite)this, n);
        this.text.setLayoutData((Object)"Center");
        this.mainControl = this.text;
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                Object object;
                Object object2 = TextWrapper.this.getValue();
                if (TextWrapper.this.textType == TEXT_TYPE.EXPRESSION) {
                    if (TextWrapper.this.jepParser == null) {
                        TextWrapper.this.jepParser = new JEP();
                        TextWrapper.this.jepParser.addStandardFunctions();
                        TextWrapper.this.jepParser.addStandardConstants();
                        TextWrapper.this.jepParser.setAllowUndeclared(true);
                        TextWrapper.this.jepParser.setImplicitMul(true);
                    }
                    try {
                        TextWrapper.this.jepParser.parse("" + object2);
                        TextWrapper.this.text.setToolTipText("Expression has valid syntax. Variables have not been checked for existence.");
                        if (!BLUE.isDisposed()) {
                            TextWrapper.this.text.setForeground(BLUE);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!RED.isDisposed()) {
                            TextWrapper.this.text.setForeground(RED);
                        }
                        TextWrapper.this.text.setToolTipText("Expression has invalid syntax");
                    }
                } else if (TextWrapper.this.textType == TEXT_TYPE.FILENAME) {
                    TextWrapper.this.jepParser = null;
                    object = object2.toString().trim();
                    if (((String)object).contains(" ") || ((String)object).startsWith("-") || ((String)object).contains(";") || ((String)object).contains("<") || ((String)object).contains("\t") || ((String)object).contains("'") || ((String)object).contains("\"") || ((String)object).contains("\\") || ((String)object).contains("\n") || ((String)object).contains("..")) {
                        if (!RED.isDisposed()) {
                            TextWrapper.this.text.setForeground(RED);
                        }
                        TextWrapper.this.text.setToolTipText("Expression has invalid syntax");
                    } else {
                        TextWrapper.this.text.setToolTipText("Enter a valid filename. Do NOT use spaces, commas, backslash etc.");
                        if (!BLACK.isDisposed()) {
                            TextWrapper.this.text.setForeground(BLACK);
                        }
                    }
                }
                object = new ValueEvent(TextWrapper.this.text, TextWrapper.this.getFieldName());
                ((ValueEvent)object).setValue(object2);
                TextWrapper.this.eventDelegate.notifyValueListeners((ValueEvent)object);
            }
        };
        this.text.addModifyListener(this.modifyListener);
    }

    @Override
    public void dispose() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.removeModifyListener(this.modifyListener);
        }
        super.dispose();
    }

    @Override
    public Object getValue() {
        if (this.multiLineMode) {
            String[] stringArray = this.getText().split(this.text.getLineDelimiter());
            return Arrays.asList(stringArray);
        }
        return this.getText();
    }

    public String getText() {
        if (this.text.isDisposed()) {
            return null;
        }
        return this.text.getText();
    }

    @Override
    public void setValue(Object object) {
        if (this.isDisposed()) {
            return;
        }
        if (object instanceof List) {
            this.multiLineMode = true;
            List list = (List)object;
            StringBuilder stringBuilder = new StringBuilder();
            for (Object e : list) {
                stringBuilder.append(e.toString());
                stringBuilder.append(this.text.getLineDelimiter());
            }
            this.text.setText(stringBuilder.toString());
        } else {
            this.multiLineMode = false;
            this.text.setText(object != null ? object.toString() : "");
        }
    }

    protected void checkSubclass() {
    }

    @Override
    public void setActive(boolean bl) {
        super.setActive(bl);
        this.setVisible(bl);
    }

    public void setTextLimit(int n) {
        this.text.setTextLimit(n);
    }

    public static enum TEXT_TYPE {
        FREE_TXT,
        EXPRESSION,
        FILENAME;

    }
}

