/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.wrappers;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import swing2swt.layout.BorderLayout;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.ButtonComposite;
import uk.ac.gda.richbeans.event.ValueEvent;

public class ComboWrapper
extends ButtonComposite
implements IFieldWidget {
    protected final Combo combo;
    protected AutoCompleteField autoComplete;
    protected Map<String, ?> itemMap;
    private SelectionAdapter selectionListener;
    private ModifyListener modifyListener;

    public ComboWrapper(Composite composite, int n) {
        super(composite, 0);
        this.setLayout(new BorderLayout());
        this.combo = new Combo((Composite)this, n);
        this.combo.setLayoutData((Object)"Center");
        this.mainControl = this.combo;
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ComboWrapper.this.fireValueListeners();
            }
        };
        this.combo.addSelectionListener((SelectionListener)this.selectionListener);
        this.modifyListener = new ModifyListener(){
            private List<String> items;

            public void modifyText(ModifyEvent modifyEvent) {
                String string = ComboWrapper.this.combo.getText();
                if (this.items == null) {
                    this.items = Arrays.asList(ComboWrapper.this.combo.getItems());
                }
                if (this.items.contains(string)) {
                    ComboWrapper.this.fireValueListeners();
                }
            }
        };
        this.combo.addModifyListener(this.modifyListener);
    }

    @Override
    public void setFieldName(String string) {
        super.setFieldName(string);
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.setToolTipText(string);
        }
    }

    @Override
    public void dispose() {
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.removeSelectionListener((SelectionListener)this.selectionListener);
            this.combo.removeModifyListener(this.modifyListener);
        }
        super.dispose();
    }

    @Override
    public void fireValueListeners() {
        ValueEvent valueEvent = new ValueEvent(this.combo, this.getFieldName());
        valueEvent.setDoubleValue(this.combo.getSelectionIndex());
        valueEvent.setValue(this.getValue());
        this.eventDelegate.notifyValueListeners(valueEvent);
    }

    public void setItems(Map<String, ?> map) {
        this.setItems(map.keySet().toArray(new String[map.size()]));
        this.itemMap = map;
    }

    public void setItems(String[] stringArray) {
        this.combo.setItems(stringArray);
        if (this.autoComplete == null) {
            this.autoComplete = new AutoCompleteField((Control)this.combo, (IControlContentAdapter)new ComboContentAdapter(), stringArray);
        }
        this.autoComplete.setProposals(stringArray);
    }

    @Override
    public Object getValue() {
        if (this.combo.isDisposed()) {
            return true;
        }
        String string = this.combo.getText();
        int n = this.combo.getSelectionIndex();
        if (n < 0 && string != null) {
            return this.itemMap != null ? this.itemMap.get(string) : string;
        }
        if (n > -1) {
            return this.itemMap != null ? this.itemMap.get(this.combo.getItem(n)) : this.combo.getItem(n);
        }
        return null;
    }

    @Override
    public void setValue(Object object) {
        String string;
        if (object == null) {
            this.combo.clearSelection();
            if (this.combo.getSelectionIndex() != -1) {
                throw new IllegalArgumentException("Attempted to clearSelection of Read Only ComboWrapper " + this.getFieldName());
            }
            return;
        }
        String string2 = string = this.itemMap != null ? this.getKeyForValue(object) : object.toString();
        if (string == null && this.itemMap != null && !this.itemMap.isEmpty()) {
            string = this.itemMap.keySet().iterator().next();
        }
        if (string != null) {
            int n = this.combo.indexOf(string);
            if (n < 0) {
                this.combo.clearSelection();
                if (this.combo.getSelectionIndex() != -1) {
                    throw new IllegalArgumentException("Attempted to clearSelection of Read Only ComboWrapper " + this.getFieldName());
                }
            } else {
                this.combo.select(n);
            }
        }
    }

    private String getKeyForValue(Object object) {
        if (this.itemMap == null) {
            return null;
        }
        if (object == null) {
            return null;
        }
        for (Map.Entry<String, ?> entry : this.itemMap.entrySet()) {
            if (!object.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void setActive(boolean bl) {
        super.setActive(bl);
        this.combo.setVisible(bl);
    }

    public void setTextLimit(int n) {
        this.combo.setTextLimit(n);
    }

    public void select(int n) {
        this.combo.select(n);
    }

    public void setForeground(Color color) {
        if (color.isDisposed()) {
            return;
        }
        this.combo.setForeground(color);
    }

    public int getSelectionIndex() {
        return this.combo.getSelectionIndex();
    }

    public String getItem(int n) {
        if (this.itemMap != null) {
            throw new RuntimeException("Cannot use getItem() when values are mapped!");
        }
        return this.combo.getItem(n);
    }

    public String[] getItems() {
        if (this.itemMap != null) {
            throw new RuntimeException("Cannot use getItems() when values are mapped!");
        }
        return this.combo.getItems();
    }

    public static Map<String, Integer> getItemMap(String[] stringArray) {
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            linkedHashMap.put(stringArray[n], n);
            ++n;
        }
        return linkedHashMap;
    }
}

