/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox.internal;

import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import uk.ac.gda.doe.DOEUtils;
import uk.ac.gda.richbeans.beans.BeanUI;
import uk.ac.gda.richbeans.components.scalebox.NumberBox;
import uk.ac.gda.richbeans.components.scalebox.ScaleBox;
import uk.ac.gda.richbeans.components.wrappers.LabelWrapper;
import uk.ac.gda.richbeans.event.ValueAdapter;
import uk.ac.gda.richbeans.event.ValueEvent;

public class RangeComposite
extends Composite {
    private ScaleBox initialValue;
    private ScaleBox finalValue;
    private ScaleBox increment;
    private LabelWrapper size;

    public RangeComposite(Composite composite, int n) {
        super(composite, n);
        this.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)this, 0);
        label.setText("Initial Value");
        this.initialValue = new ScaleBox(this, 0);
        this.initialValue.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.initialValue.setValue(0.0);
        Label label2 = new Label((Composite)this, 0);
        label2.setText("Final Value");
        this.finalValue = new ScaleBox(this, 0);
        this.finalValue.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.finalValue.setValue(10.0);
        Label label3 = new Label((Composite)this, 0);
        label3.setText("Increment");
        this.increment = new ScaleBox(this, 0);
        this.increment.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.increment.setMinimum(0.0);
        this.increment.setMaximum(1000.0);
        this.increment.setToolTipText("If the initial value is larger than the final value the loop will be constructed using increment to go backwards from the start.");
        this.increment.setValue(1.0);
        Label label4 = new Label((Composite)this, 0);
        label4.setText("Size");
        this.size = new LabelWrapper(this, 0);
        this.size.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        ValueAdapter valueAdapter = new ValueAdapter(){

            @Override
            public void valueChangePerformed(ValueEvent valueEvent) {
                try {
                    List list = DOEUtils.expand((String)RangeComposite.this.getValue());
                    RangeComposite.this.size.setValue(list.size());
                }
                catch (Exception exception) {
                    RangeComposite.this.size.setValue(0);
                }
            }
        };
        this.initialValue.addValueListener(valueAdapter);
        this.finalValue.addValueListener(valueAdapter);
        this.increment.addValueListener(valueAdapter);
        try {
            BeanUI.switchState((Object)this, true);
        }
        catch (Exception exception) {}
    }

    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.initialValue.getValue());
        stringBuilder.append("; ");
        stringBuilder.append(this.finalValue.getValue());
        stringBuilder.append("; ");
        stringBuilder.append(this.increment.getValue());
        return stringBuilder.toString();
    }

    public void setUnit(String string) {
        this.initialValue.setUnit(string);
        this.finalValue.setUnit(string);
        this.increment.setUnit(string);
    }

    public void setValue(String string) {
        String[] stringArray = string.split(";");
        this.setValue(Double.parseDouble(stringArray[0].trim()), Double.parseDouble(stringArray[1].trim()), Double.parseDouble(stringArray[2].trim()));
    }

    public void setValue(Number number, Number number2, Number number3) {
        this.initialValue.setValue(number);
        this.finalValue.setValue(number2);
        this.increment.setValue(number3);
    }

    public void setBounds(NumberBox numberBox) {
        this.initialValue.copySettings(numberBox);
        this.finalValue.copySettings(numberBox);
        this.increment.setIntegerBox(numberBox.isIntegerBox());
        this.increment.setDecimalPlaces(numberBox.getDecimalPlaces());
    }

    public ScaleBox getInitialValue() {
        return this.initialValue;
    }

    public ScaleBox getFinalValue() {
        return this.finalValue;
    }

    public ScaleBox getIncrement() {
        return this.increment;
    }

    public boolean isForwards() {
        Double d = (Double)this.getInitialValue().getValue();
        Double d2 = (Double)this.getFinalValue().getValue();
        return d2 > d;
    }
}

