/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ColumnLayoutData;
import swing2swt.layout.BorderLayout;
import uk.ac.gda.richbeans.components.scalebox.DecimalScale;
import uk.ac.gda.richbeans.components.scalebox.NumberBox;
import uk.ac.gda.richbeans.event.BoundsEvent;
import uk.ac.gda.richbeans.event.BoundsListener;
import uk.ac.gda.ui.utils.SWTUtils;

public class ScaleBox
extends NumberBox {
    protected Shell scaleShell;
    protected DecimalScale scale;
    protected double increment = 1.0;
    protected double pageIncrement = 100.0;
    protected int scaleDecimalPlaces = 0;
    protected boolean shellCreated = false;
    protected boolean showingScale = false;

    public ScaleBox(Composite composite, int n) {
        super(composite, n);
        this.buttonSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ScaleBox.this.scaleShell != null && ScaleBox.this.scaleShell.isVisible()) {
                    return;
                }
                ScaleBox.this.setShowingScale(true);
            }
        };
    }

    @Override
    public void dispose() {
        if (this.scaleShell != null && !this.scaleShell.isDisposed()) {
            this.scaleShell.dispose();
        }
        super.dispose();
    }

    protected void createScaleShell() {
        if (this.shellCreated) {
            return;
        }
        this.scaleShell = new Shell(this.getShell(), 540676);
        this.scaleShell.setLayout((Layout)new BorderLayout());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ScaleBox.this.setShowingScale(false);
            }
        };
        this.scaleShell.addListener(27, listener);
        this.scaleShell.addListener(21, listener);
        this.text.addListener(8, listener);
        this.text.addListener(3, listener);
        this.text.addListener(12, listener);
        this.text.addListener(16, listener);
        Shell shell = this.getShell();
        shell.addListener(10, listener);
        shell.addListener(11, listener);
        Composite composite = new Composite((Composite)this.scaleShell, 0);
        composite.setLayoutData((Object)"Center");
        composite.setLayout((Layout)new BorderLayout());
        this.scale = new DecimalScale(composite, 524288);
        this.scale.setLayoutData("Center");
        this.scale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ScaleBox.this.text.setText(String.valueOf(ScaleBox.this.scale.getSelection()));
            }
        });
        this.scale.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                ScaleBox.this.setShowingScale(false);
            }
        });
        this.scaleShell.pack();
        this.shellCreated = true;
    }

    protected void toggleShowingScale() {
        this.setShowingScale(!this.showingScale);
    }

    protected void setShowingScale(boolean bl) {
        try {
            if (bl) {
                this.createScaleShell();
                if (this.button != null) {
                    this.button.removeSelectionListener(this.buttonSelection);
                }
                Rectangle rectangle = this.text.getBounds();
                Point point = this.text.toDisplay(-2, rectangle.height - 4);
                Rectangle rectangle2 = new Rectangle(point.x, point.y, rectangle.width - 2, this.scaleShell.getBounds().height);
                this.scale.setDecimalPlaces(this.getScaleDecimalPlaces());
                this.scale.setMaximum(this.getMaximum());
                this.scale.setMinimum(this.getMinimum());
                this.scale.setIncrement(this.getIncrement());
                this.scale.setPageIncrement(this.getPageIncrement());
                this.scale.setSelection(this.getIntegerValue());
                this.scaleShell.setBounds(rectangle2);
                this.scaleShell.setVisible(true);
                this.text.setFocus();
            } else if (this.scaleShell != null && !this.scaleShell.isDisposed()) {
                this.scaleShell.setVisible(false);
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ScaleBox.this.button != null) {
                            ScaleBox.this.button.addSelectionListener(ScaleBox.this.buttonSelection);
                        }
                    }
                });
            }
        }
        finally {
            this.showingScale = bl;
        }
    }

    public static void main(String ... stringArray) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new BorderLayout());
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)"North");
        composite.setLayout((Layout)new ColumnLayout());
        ScaleBox scaleBox = new ScaleBox(composite, 0);
        scaleBox.setLayoutData(new ColumnLayoutData(200));
        scaleBox.setUnit("eV");
        scaleBox.setLabel("Fred");
        scaleBox.setLabelWidth(200);
        scaleBox.setScaleDecimalPlaces(2);
        scaleBox.addBoundsListener(new BoundsListener(){

            @Override
            public void valueGreater(BoundsEvent boundsEvent) {
                System.out.println(boundsEvent);
            }

            @Override
            public void valueLegal(BoundsEvent boundsEvent) {
                System.out.println(boundsEvent);
            }

            @Override
            public void valueLess(BoundsEvent boundsEvent) {
                System.out.println(boundsEvent);
            }
        });
        ScaleBox scaleBox2 = new ScaleBox(composite, 0);
        scaleBox2.setLayoutData(new ColumnLayoutData(200));
        scaleBox2.setMaximum(1000.0);
        scaleBox2.setMinimum(0.0);
        scaleBox2.setIncrement(10.0);
        scaleBox2.setPageIncrement(100.0);
        scaleBox2.setUnit("eV");
        scaleBox2.setLabelWidth(200);
        scaleBox2.setDecimalPlaces(4);
        ScaleBox scaleBox3 = new ScaleBox(composite, 0);
        scaleBox3.setLayoutData(new ColumnLayoutData(200));
        scaleBox3.setDecimalPlaces(2);
        scaleBox3.setMaximum(20.51);
        scaleBox3.setMinimum(-20.51);
        scaleBox3.setIncrement(0.02);
        scaleBox3.setUnit("eV");
        ScaleBox scaleBox4 = new ScaleBox(composite, 0);
        scaleBox4.setLayoutData(new ColumnLayoutData(200));
        scaleBox4.setDecimalPlaces(0);
        scaleBox4.setUnit("s");
        scaleBox4.setIntegerValue(-25);
        scaleBox4.setMaximum(-20.0);
        scaleBox4.setMinimum(-50.0);
        shell.pack();
        shell.setSize(400, 400);
        SWTUtils.showCenteredShell(shell);
    }

    public double getIncrement() {
        return this.increment;
    }

    public void setIncrement(double d) {
        this.increment = d;
    }

    public double getPageIncrement() {
        return this.pageIncrement;
    }

    public void setPageIncrement(double d) {
        this.pageIncrement = d;
    }

    public int getScaleDecimalPlaces() {
        return this.scaleDecimalPlaces;
    }

    public void setScaleDecimalPlaces(int n) {
        this.scaleDecimalPlaces = n;
    }
}

