/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox;

import com.swtdesigner.SWTResourceManager;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import uk.ac.gda.doe.DOEUtils;
import uk.ac.gda.richbeans.beans.IExpressionManager;
import uk.ac.gda.richbeans.beans.IRangeWidget;
import uk.ac.gda.richbeans.components.scalebox.NumberBox;
import uk.ac.gda.richbeans.components.scalebox.internal.RangeDialog;
import uk.ac.gda.richbeans.event.ValueEvent;

public class RangeBox
extends NumberBox
implements IRangeWidget {
    public RangeBox(Composite composite, int n) {
        super(composite, n);
        this.buttonSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RangeDialog rangeDialog = new RangeDialog(RangeBox.this.getShell(), RangeBox.this.isIntegerBox());
                rangeDialog.create();
                rangeDialog.setUnit(RangeBox.this.getUnit());
                rangeDialog.setValue(RangeBox.this.getValue());
                rangeDialog.setBounds(RangeBox.this);
                if (rangeDialog.open() == 0) {
                    RangeBox.this.checkValue(rangeDialog.getValue());
                }
            }
        };
        this.setButtonVisible(true);
        this.button.setToolTipText("Open range form which allows this value to be defined as a range.");
        this.button.setImage(SWTResourceManager.getImage(RangeBox.class, "/icons/arrow_divide.png"));
        this.button.setText("");
        GridData gridData = (GridData)this.button.getLayoutData();
        gridData.widthHint = 29;
    }

    @Override
    protected void createTextListeners(final StyledText styledText) {
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (!RangeBox.this.isOn()) {
                    return;
                }
                try {
                    RangeBox.this.on = false;
                    RangeBox.this.checkValue(styledText.getText());
                }
                finally {
                    RangeBox.this.on = true;
                }
            }
        };
        styledText.addFocusListener((FocusListener)this.focusListener);
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RangeBox.this.checkValue(styledText.getText());
                ValueEvent valueEvent = new ValueEvent(RangeBox.this, RangeBox.this.getFieldName());
                valueEvent.setValue(RangeBox.this.getValue());
                RangeBox.this.eventDelegate.notifyValueListeners(valueEvent);
            }
        };
        styledText.addModifyListener(this.modifyListener);
    }

    @Override
    protected void checkValue(String string) {
        int n;
        Object object;
        if (string == null) {
            return;
        }
        if ("".equals(string.trim())) {
            return;
        }
        if ("-".equals(string.trim())) {
            return;
        }
        try {
            object = this.getRegExpression();
            if (((Pattern)object).matcher(string).matches() || ((Pattern)object).matcher(String.valueOf(string) + " " + this.unit).matches()) {
                super.checkValue(string);
                return;
            }
        }
        catch (Throwable throwable) {}
        object = DOEUtils.removeUnit((String)string, (String)this.unit);
        if (this.unit != null) {
            string = String.valueOf(((String)object).trim()) + " " + this.unit;
        }
        if (!string.equals(this.text.getText())) {
            n = this.text.getCaretOffset();
            this.text.setText(string);
            this.text.setCaretOffset(n);
        }
        n = DOEUtils.isList((String)object, (int)this.getDecimalPlaces(), null) ? 1 : 0;
        boolean bl = DOEUtils.isRange((String)object, (int)this.getDecimalPlaces(), null);
        if (n == 0 && !bl) {
            if (this.red == null) {
                this.red = this.getDisplay().getSystemColor(3);
            }
            if (!this.red.isDisposed()) {
                this.text.setForeground(this.red);
            }
            this.setTooltipOveride("A range should be entered in the form: <start>; <stop>; <increment>.\n\nA list should be a comma separerated list of numbers (two or more).");
        } else {
            if (!this.checkBounds((String)object)) {
                return;
            }
            this.setTooltipOveride(null);
            if (this.isEditable()) {
                if (this.black == null) {
                    this.black = this.getDisplay().getSystemColor(2);
                }
                if (!this.black.isDisposed()) {
                    this.text.setForeground(this.black);
                }
            } else {
                if (this.grey == null) {
                    this.grey = this.getDisplay().getSystemColor(16);
                }
                if (!this.grey.isDisposed()) {
                    this.text.setForeground(this.grey);
                }
            }
        }
    }

    private boolean checkBounds(String string) {
        List list = DOEUtils.expand((String)string);
        for (Number number : list) {
            if (this.isValidBounds(number.doubleValue())) continue;
            if (this.red == null) {
                this.red = this.getDisplay().getSystemColor(3);
            }
            if (!this.red.isDisposed()) {
                this.text.setForeground(this.red);
            }
            this.setTooltipOveride("The range '" + string + "' would give the value '" + number + "' which is out of bounds.");
            return false;
        }
        return true;
    }

    @Override
    public void setValue(Object object) {
        this.checkValue(object.toString());
    }

    @Override
    public String getValue() {
        String string = this.text.getText();
        if (string == null) {
            return null;
        }
        if ("".equals(string.trim())) {
            return null;
        }
        return DOEUtils.removeUnit((String)string, (String)this.unit);
    }

    @Override
    public void setExpressionManager(IExpressionManager iExpressionManager) {
        this.expressionManager = null;
    }

    @Override
    public boolean isExpressionAllowed() {
        return false;
    }
}

