/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components.scalebox;

import java.text.NumberFormat;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import uk.ac.gda.common.rcp.util.GridUtils;
import uk.ac.gda.richbeans.ACTIVE_MODE;
import uk.ac.gda.richbeans.beans.BeanUI;
import uk.ac.gda.richbeans.beans.IExpressionManager;
import uk.ac.gda.richbeans.beans.IExpressionWidget;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.BoundsProvider;
import uk.ac.gda.richbeans.components.BoundsUpdater;
import uk.ac.gda.richbeans.components.ButtonComposite;
import uk.ac.gda.richbeans.components.scalebox.ScaleBox;
import uk.ac.gda.richbeans.event.BoundsEvent;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.ui.utils.StringUtils;

public abstract class NumberBox
extends ButtonComposite
implements BoundsProvider,
IFieldWidget,
IExpressionWidget {
    protected StyledText expressionLabel;
    protected Label label;
    protected StyledText text;
    protected double maximum = 1000.0;
    protected double minimum = 0.0;
    protected int decimalPlaces = 2;
    protected String name;
    protected String unit;
    protected BoundsProvider minProvider;
    protected BoundsProvider maxProvider;
    protected boolean isIntegerBox = false;
    protected boolean validBounds = true;
    protected String tooltipOveride;
    protected NumberFormat numberFormat;
    protected MouseTrackAdapter mouseTrackListener;
    protected FocusAdapter focusListener;
    protected ModifyListener modifyListener;
    protected VerifyKeyListener verifyListener;
    protected SelectionListener selectionListener;
    protected IExpressionManager expressionManager;
    private Object value;
    protected BoundsEvent.Mode currentBoundsMode = BoundsEvent.Mode.LEGAL;
    protected Color red;
    protected Color black;
    protected Color grey;
    protected Color blue;
    protected double numericValue;
    protected double integerValue;
    protected boolean isEditable = true;
    protected String maxFieldName;
    protected Class<?> maxClass;
    protected String minFieldName;
    protected Class<?> minClass;
    private ACTIVE_MODE activeMode = ACTIVE_MODE.SET_VISIBLE_AND_ACTIVE;
    private String boundsKey;

    public NumberBox(Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.label = new Label((Composite)this, 16384);
        this.label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        GridUtils.setVisibleAndLayout((Control)this.label, false);
        this.text = new StyledText((Composite)this, 2052);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createTextListeners(this.text);
        this.text.setToolTipText(null);
        this.text.setStyleRange(null);
        this.mouseTrackListener = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent mouseEvent) {
                NumberBox.this.setupToolTip();
            }

            public void mouseExit(MouseEvent mouseEvent) {
                NumberBox.this.text.setToolTipText(null);
            }
        };
        this.text.addMouseTrackListener((MouseTrackListener)this.mouseTrackListener);
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setMaximumFractionDigits(this.decimalPlaces);
        this.numberFormat.setGroupingUsed(false);
    }

    @Override
    public Control getControl() {
        return this.text;
    }

    protected void createExpressionLabel(int n) {
        if (this.expressionLabel != null) {
            return;
        }
        this.expressionLabel = new StyledText((Composite)this, 2060);
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.widthHint = n >= 0 ? n : 100;
        this.expressionLabel.setLayoutData((Object)gridData);
        GridUtils.setVisibleAndLayout((Control)this.expressionLabel, false);
    }

    protected void checkSubclass() {
    }

    @Override
    public void dispose() {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.removeSelectionListener(this.buttonSelection);
            this.button.dispose();
        }
        if (this.text != null && !this.text.isDisposed()) {
            this.text.removeMouseTrackListener((MouseTrackListener)this.mouseTrackListener);
            if (this.focusListener != null) {
                this.text.removeFocusListener((FocusListener)this.focusListener);
            }
            if (this.modifyListener != null) {
                this.text.removeModifyListener(this.modifyListener);
            }
            if (this.selectionListener != null) {
                this.text.removeSelectionListener(this.selectionListener);
            }
            if (this.verifyListener != null) {
                this.text.removeVerifyKeyListener(this.verifyListener);
            }
            this.text.dispose();
        }
        if (this.label != null && !this.label.isDisposed()) {
            this.label.dispose();
        }
        super.dispose();
    }

    protected void createTextListeners(StyledText styledText) {
        this.createFocusListener(styledText);
        this.createModifyListener(styledText);
    }

    protected void createModifyListener(StyledText styledText) {
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NumberBox.this.textUpdateAndFireListeners();
            }
        };
        styledText.addModifyListener(this.modifyListener);
    }

    protected void createSelectionListener(StyledText styledText) {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NumberBox.this.textUpdateAndFireListeners();
            }
        };
        styledText.addSelectionListener(this.selectionListener);
    }

    protected void createVerifyKeyListener(StyledText styledText) {
        this.verifyListener = new VerifyKeyListener(){

            public void verifyKey(VerifyEvent verifyEvent) {
            }
        };
        styledText.addVerifyKeyListener(this.verifyListener);
    }

    protected void createFocusListener(StyledText styledText) {
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                NumberBox.this.textUpdate();
            }
        };
        styledText.addFocusListener((FocusListener)this.focusListener);
    }

    protected void textUpdate() {
        if (this.text.isDisposed()) {
            return;
        }
        if (!this.isOn()) {
            return;
        }
        try {
            this.on = false;
            this.checkValue(this.text.getText());
        }
        finally {
            this.on = true;
        }
    }

    protected void textUpdateAndFireListeners() {
        this.textUpdate();
        double d = this.getNumericValue();
        ValueEvent valueEvent = new ValueEvent(this, this.getFieldName());
        valueEvent.setDoubleValue(d);
        this.eventDelegate.notifyValueListeners(valueEvent);
    }

    @Override
    public Object getValue() {
        Double d = this.getNumericValue();
        if (Double.isNaN(d)) {
            return null;
        }
        if (this.isIntegerBox || this.getDecimalPlaces() == 0) {
            return new Integer(Math.round(Math.round(d)));
        }
        return new Double(d);
    }

    @Override
    public void setValue(Object object) {
        if (object != null) {
            if (object instanceof String) {
                this.checkValue(object.toString());
            } else {
                this.checkValue(this.numberFormat.format(object));
            }
        } else {
            this.text.setText("");
        }
    }

    protected Pattern getRegExpression() {
        String string = this.getRegExpressionString();
        return Pattern.compile(string);
    }

    protected String getRegExpressionString() {
        String string = this.decimalPlaces > 0 ? "\\.?\\d{0," + this.decimalPlaces + "})" : ")";
        String string2 = "(\\-?\\d+" + string;
        if (this.unit == null) {
            return string2;
        }
        return String.valueOf(string2) + "\\ {1}\\Q" + this.unit + "\\E";
    }

    protected void updateValue() {
        this.setupToolTip();
        this.checkValue(this.text.getText());
    }

    protected void checkValue(String string) {
        if (string == null || "".equals(string.trim()) || "-".equals(string.trim())) {
            GridUtils.setVisibleAndLayout((Control)this.expressionLabel, false);
            return;
        }
        if (!string.equals(this.text.getText())) {
            this.text.setText(string);
        }
        if (this.expressionManager != null) {
            this.processAsExpression(string);
        } else {
            this.processAsNumber(string);
        }
    }

    private void processAsExpression(String string) {
        Pattern pattern = this.getRegExpression();
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            this.processAsNumber(string);
            return;
        }
        string = string.trim();
        if (this.unit != null && string.endsWith(this.unit)) {
            string = string.substring(0, string.length() - this.unit.length());
        } else {
            pattern = Pattern.compile("(.*)\\(" + this.getRegExpressionString() + "\\)");
            matcher = pattern.matcher(string);
            if (matcher.matches()) {
                string = matcher.group(1).trim();
            }
        }
        if ("".equals(string) || string == null || string.equals(this.unit)) {
            this.processAsNumber(string);
            return;
        }
        try {
            Double.parseDouble(string);
            this.processAsNumber(string);
            return;
        }
        catch (Throwable throwable) {
            this.expressionManager.setExpression(string);
            int n = this.text.getCaretOffset();
            if (this.expressionManager.isExpressionValid()) {
                this.text.setForeground(this.blue);
                this.text.setText(string);
                this.setExpressionValue(this.expressionManager.getExpressionValue());
                this.checkBounds(this.expressionManager.getExpressionValue());
            } else {
                if (this.red == null) {
                    this.red = this.getDisplay().getSystemColor(3);
                }
                this.text.setForeground(this.red);
                this.text.setText(string);
                GridUtils.setVisibleAndLayout((Control)this.expressionLabel, false);
            }
            this.text.setCaretOffset(n);
            this.layout();
            return;
        }
    }

    @Override
    public void setExpressionValue(double d) {
        String string = this.numberFormat.format(d);
        if (Double.isNaN(d)) {
            GridUtils.setVisibleAndLayout((Control)this.expressionLabel, false);
            return;
        }
        if (Double.isInfinite(d)) {
            string = "\u221e";
        }
        if (!this.isExpressionAllowed()) {
            return;
        }
        String string2 = this.unit != null ? this.unit : "";
        String string3 = String.valueOf(string) + " " + string2;
        GridUtils.setVisibleAndLayout((Control)this.expressionLabel, true);
        this.expressionLabel.setText(string3);
        this.layout();
        this.checkBounds(d);
    }

    private void processAsNumber(String string) {
        Pattern pattern;
        Matcher matcher;
        StringBuilder stringBuilder;
        if (this.expressionManager != null) {
            this.expressionManager.setExpression(null);
        }
        if (this.expressionLabel != null) {
            GridUtils.setVisibleAndLayout((Control)this.expressionLabel, false);
        }
        StringBuilder stringBuilder2 = stringBuilder = (matcher = (pattern = this.getRegExpression()).matcher(string)).matches() ? null : StringUtils.keepDigits(string, this.decimalPlaces);
        if (stringBuilder != null && "-".equals(stringBuilder.toString())) {
            return;
        }
        double d = Double.NaN;
        try {
            d = stringBuilder != null && stringBuilder.length() > 0 ? Double.parseDouble(stringBuilder.toString()) : Double.parseDouble(matcher.group(1));
        }
        catch (Exception exception) {
            d = Double.NaN;
        }
        if (this.unit != null && stringBuilder != null && stringBuilder.length() > 0) {
            String string2 = " " + this.unit;
            stringBuilder.append(string2);
        }
        if (stringBuilder != null) {
            int n = this.text.getCaretOffset();
            this.text.setText(stringBuilder.toString());
            this.text.setCaretOffset(n);
        }
        this.checkBounds(d);
        GridUtils.layout(this);
    }

    public void checkBounds() {
        this.checkBounds(this.getNumericValue());
    }

    protected void checkBounds(double d) {
        if (this.isDisposed() || this.text.isDisposed()) {
            return;
        }
        BoundsEvent boundsEvent = new BoundsEvent((Widget)this);
        boundsEvent.setValue(d);
        boundsEvent.setUpper(this.getMaximum());
        boundsEvent.setLower(this.getMinimum());
        this.validBounds = true;
        if (!this.isValidBounds(d)) {
            if (this.red == null) {
                this.red = this.getDisplay().getSystemColor(3);
            }
            if (!this.red.isDisposed()) {
                this.text.setStyleRange(null);
                this.text.setForeground(this.red);
            }
            this.validBounds = false;
            if (d > this.maximum) {
                boundsEvent.setMode(BoundsEvent.Mode.GREATER);
                this.setTooltipOveride("The value '" + d + "' is greater than the upper limit.");
            } else if (d < this.minimum) {
                boundsEvent.setMode(BoundsEvent.Mode.LESS);
                this.setTooltipOveride("The value '" + d + "' is less than the lower limit.");
            }
        } else {
            this.setTooltipOveride(null);
            if (this.isEditable()) {
                if (this.blue == null) {
                    this.blue = this.getDisplay().getSystemColor(9);
                }
                if (this.black == null) {
                    this.black = this.getDisplay().getSystemColor(2);
                }
                if (this.expressionManager != null && this.expressionManager.isExpressionValid()) {
                    if (!this.blue.isDisposed()) {
                        this.text.setForeground(this.blue);
                    }
                } else if (!this.black.isDisposed()) {
                    this.text.setForeground(this.black);
                }
            } else {
                if (this.grey == null) {
                    this.grey = this.getDisplay().getSystemColor(16);
                }
                if (!this.grey.isDisposed()) {
                    this.text.setForeground(this.grey);
                }
            }
            boundsEvent.setMode(BoundsEvent.Mode.LEGAL);
        }
        try {
            if (this.currentBoundsMode != boundsEvent.getMode()) {
                this.eventDelegate.notifyBoundsListeners(boundsEvent);
            }
        }
        finally {
            this.currentBoundsMode = boundsEvent.getMode();
        }
    }

    protected boolean isValidBounds(double d) {
        double d2 = this.getMaximum();
        double d3 = this.getMinimum();
        if (Double.isNaN(d)) {
            return true;
        }
        return d >= d3 && d <= d2;
    }

    protected void setupToolTip() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getTooltipOveride() != null) {
            stringBuilder.append(this.getTooltipOveride());
            stringBuilder.append("\n\n");
        }
        stringBuilder.append(this.numberFormat.format(this.getMinimum()));
        if (this.unit != null) {
            stringBuilder.append(" " + this.unit);
        }
        stringBuilder.append(" < ");
        String string = this.getFieldName() != null ? this.getFieldName() : "value";
        stringBuilder.append(string);
        stringBuilder.append(" < ");
        stringBuilder.append(this.numberFormat.format(this.getMaximum()));
        if (this.unit != null) {
            stringBuilder.append(" " + this.unit);
        }
        this.text.setToolTipText(stringBuilder.toString());
    }

    public void setIntegerBox(boolean bl) {
        this.isIntegerBox = bl;
        this.setDecimalPlaces(bl ? 0 : 2);
    }

    public boolean isIntegerBox() {
        return this.isIntegerBox;
    }

    public double getNumericValue() {
        if (this.text.isDisposed()) {
            return Double.NaN;
        }
        String string = this.text.getText();
        if (string == null) {
            return Double.NaN;
        }
        if ("".equals(string.trim())) {
            return Double.NaN;
        }
        if ("-".equals(string.trim())) {
            return -0.0;
        }
        if (this.expressionManager != null && this.expressionManager.isExpressionValid()) {
            return this.expressionManager.getExpressionValue();
        }
        Pattern pattern = this.getRegExpression();
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return Double.parseDouble(matcher.group(1));
        }
        return Double.NaN;
    }

    public void setNumericValue(double d) {
        this.numericValue = d;
        this.checkValue("" + d);
    }

    public int getIntegerValue() {
        return (int)this.getNumericValue();
    }

    public void setIntegerValue(int n) {
        this.checkValue("" + n);
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
        if (this.isDisposed()) {
            return;
        }
        this.text.setEditable(bl);
        if (this.isValidBounds()) {
            if (this.black == null) {
                this.black = this.getDisplay().getSystemColor(2);
            }
            if (this.grey == null) {
                this.grey = this.getDisplay().getSystemColor(16);
            }
            if (!this.black.isDisposed() && !this.grey.isDisposed()) {
                this.text.setForeground(bl ? this.black : this.grey);
            }
        } else {
            if (this.red == null) {
                this.red = this.getDisplay().getSystemColor(3);
            }
            if (!this.red.isDisposed()) {
                this.text.setForeground(this.red);
            }
        }
        if (this.button != null) {
            this.button.setEnabled(bl);
        }
    }

    public Color _testGetForeGroundColor() {
        return this.text.getForeground();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.setEditable(bl);
        this.text.setEnabled(bl);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public void setDecimalPlaces(int n) {
        this.decimalPlaces = n;
        this.numberFormat.setMaximumFractionDigits(n);
    }

    public double getMaximum() {
        ScaleBox scaleBox;
        if (this.maxProvider != null) {
            return this.maxProvider.getBoundValue();
        }
        if (this.maxFieldName != null && this.maxClass != null && (scaleBox = (ScaleBox)BeanUI.getBeanField(this.maxFieldName, this.maxClass)) != null) {
            return scaleBox.getNumericValue();
        }
        return this.maximum;
    }

    public void setMaximum(double d) {
        this.maximum = d;
        this.checkBounds();
    }

    public void setMaximum(double d, String string, Class<?> clazz) {
        this.maximum = d;
        this.maxFieldName = string;
        this.maxClass = clazz;
    }

    public void setMaximum(BoundsProvider boundsProvider) {
        this.maxProvider = boundsProvider;
        this.checkBounds();
        boundsProvider.addValueListener(new BoundsUpdater("maxProviderListener", this.getBoundsKey()){

            @Override
            public void valueChangePerformed(ValueEvent valueEvent) {
                NumberBox.this.checkBounds();
            }
        });
    }

    public double getMinimum() {
        ScaleBox scaleBox;
        if (this.minProvider != null) {
            return this.minProvider.getBoundValue();
        }
        if (this.minFieldName != null && this.minClass != null && (scaleBox = (ScaleBox)BeanUI.getBeanField(this.minFieldName, this.minClass)) != null) {
            return scaleBox.getNumericValue();
        }
        return this.minimum;
    }

    public void setMinimum(double d) {
        this.minimum = d;
        this.checkBounds();
    }

    public void setMinimum(BoundsProvider boundsProvider) {
        this.minProvider = boundsProvider;
        this.checkBounds();
        boundsProvider.addValueListener(new BoundsUpdater("minProviderListener", this.getBoundsKey()){

            @Override
            public void valueChangePerformed(ValueEvent valueEvent) {
                NumberBox.this.checkBounds();
            }
        });
    }

    public void setMinimum(double d, String string, Class<?> clazz) {
        this.minimum = d;
        this.minFieldName = string;
        this.minClass = clazz;
    }

    public void setLabel(String string) {
        GridUtils.setVisibleAndLayout((Control)this.label, true);
        this.label.setText(string);
    }

    public void setLabelWidth(int n) {
        GridData gridData = (GridData)this.label.getLayoutData();
        gridData.widthHint = n;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        Pattern pattern = this.getRegExpression();
        Matcher matcher = pattern.matcher(this.text.getText());
        if (matcher.matches()) {
            this.text.setText(String.valueOf(matcher.group(1)) + " " + string);
        }
        this.unit = string;
        this.updateValue();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public double getBoundValue() {
        return this.getNumericValue();
    }

    @Override
    public void setActive(boolean bl) {
        super.setActive(bl);
        if (this.activeMode == ACTIVE_MODE.SET_VISIBLE_AND_ACTIVE) {
            this.setVisible(bl);
        } else if (this.activeMode == ACTIVE_MODE.SET_ENABLED_AND_ACTIVE) {
            this.setEditable(bl);
        }
    }

    public ACTIVE_MODE getActiveMode() {
        return this.activeMode;
    }

    public void setActiveMode(ACTIVE_MODE aCTIVE_MODE) {
        this.activeMode = aCTIVE_MODE;
    }

    public boolean isValidBounds() {
        return this.validBounds;
    }

    public boolean setFocus() {
        return this.text.setFocus();
    }

    public void copySettings(NumberBox numberBox) {
        this.maxProvider = numberBox.maxProvider;
        this.minProvider = numberBox.minProvider;
        this.maximum = numberBox.maximum;
        this.minimum = numberBox.minimum;
        this.isIntegerBox = numberBox.isIntegerBox;
        this.decimalPlaces = numberBox.decimalPlaces;
    }

    public String getTooltipOveride() {
        return this.tooltipOveride;
    }

    public void setTooltipOveride(String string) {
        this.tooltipOveride = string;
    }

    @Override
    public void setExpressionManager(IExpressionManager iExpressionManager) {
        this.expressionManager = iExpressionManager;
        this.createExpressionLabel(-1);
    }

    @Override
    public boolean isExpressionAllowed() {
        return this.expressionManager != null;
    }

    @Override
    public boolean isExpressionParseRequired(String string) {
        Pattern pattern = this.getRegExpression();
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return false;
        }
        if ("".equals(string) || string == null || string.equals(this.unit)) {
            return false;
        }
        try {
            Double.parseDouble(string);
            return false;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    private String getBoundsKey() {
        if (this.boundsKey == null) {
            this.boundsKey = this.fieldName != null ? this.fieldName : "Widget " + Calendar.getInstance().getTimeInMillis();
        }
        return this.boundsKey;
    }

    @Override
    protected void createButton() {
        super.createButton();
        if (this.button != null && this.button.getLayoutData() instanceof GridData) {
            GridData gridData = (GridData)this.button.getLayoutData();
            gridData.heightHint = 25;
        }
    }
}

