/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.richbeans.components;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import uk.ac.gda.richbeans.beans.IFieldWidget;
import uk.ac.gda.richbeans.components.EventManagerDelegate;
import uk.ac.gda.richbeans.event.BoundsListener;
import uk.ac.gda.richbeans.event.ValueEvent;
import uk.ac.gda.richbeans.event.ValueListener;

public abstract class FieldComposite
extends Composite
implements IFieldWidget {
    protected Control mainControl;
    protected EventManagerDelegate eventDelegate = new EventManagerDelegate(this);
    protected NOTIFY_TYPE notifyType;
    protected String fieldName;
    protected boolean on = false;
    protected boolean active = true;

    public void setNotifyType(NOTIFY_TYPE nOTIFY_TYPE) {
        this.notifyType = nOTIFY_TYPE;
    }

    public FieldComposite(Composite composite, int n) {
        super(composite, n);
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void setFieldName(String string) {
        this.fieldName = string;
    }

    @Override
    public boolean isOn() {
        return this.on;
    }

    @Override
    public void off() {
        this.on = false;
    }

    @Override
    public void on() {
        this.on = true;
    }

    public NOTIFY_TYPE getNotifyType() {
        return this.notifyType;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.mainControl != null) {
            this.mainControl.setEnabled(bl);
        }
    }

    @Override
    public void addValueListener(ValueListener valueListener) {
        this.eventDelegate.addValueListener(valueListener);
    }

    @Override
    public void fireValueListeners() {
        ValueEvent valueEvent = new ValueEvent(this, this.getFieldName());
        valueEvent.setValue(this.getValue());
        this.eventDelegate.notifyValueListeners(valueEvent);
    }

    @Override
    public void fireBoundsUpdaters() {
        ValueEvent valueEvent = new ValueEvent(this, this.getFieldName());
        valueEvent.setValue(this.getValue());
        this.eventDelegate.notifyBoundsProviderListeners(valueEvent);
    }

    @Override
    public void dispose() {
        if (this.eventDelegate != null) {
            this.eventDelegate.dispose();
        }
        if (this.mainControl != null) {
            this.mainControl.dispose();
        }
        super.dispose();
    }

    @Override
    public void removeValueListener(ValueListener valueListener) {
        this.eventDelegate.removeValueListener(valueListener);
    }

    public void addBoundsListener(BoundsListener boundsListener) {
        this.eventDelegate.addBoundsListener(boundsListener);
    }

    public void removeBoundsListener(BoundsListener boundsListener) {
        this.eventDelegate.removeBoundsListener(boundsListener);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public String toString() {
        return String.valueOf(this.fieldName) + " [" + this.getClass().getName() + "]";
    }

    public static enum NOTIFY_TYPE {
        DEFAULT,
        VALUE_CHANGED,
        ALWAYS;

    }
}

