/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gda.common.rcp.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.util.io.IPathConstructor;

public class PathUtils {
    private static Logger logger = LoggerFactory.getLogger(PathUtils.class);
    private static IPathConstructor pathConstructor;

    public static String createFromDefaultProperty() {
        try {
            IPathConstructor iPathConstructor = PathUtils.getPathConstructor();
            return iPathConstructor.getDefaultDataDir();
        }
        catch (Exception exception) {
            logger.error("Cannot get IPathConstructor", (Throwable)exception);
            return null;
        }
    }

    public static String createFromTemplate(String string) {
        try {
            IPathConstructor iPathConstructor = PathUtils.getPathConstructor();
            return iPathConstructor.getFromTemplate(string);
        }
        catch (Exception exception) {
            logger.error("Cannot get IPathConstructor", (Throwable)exception);
            return null;
        }
    }

    private static IPathConstructor getPathConstructor() throws InstantiationException, IllegalAccessException, CoreException {
        if (pathConstructor != null) {
            return pathConstructor;
        }
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("uk.ac.gda.common.path.constructor");
        pathConstructor = (IPathConstructor)iConfigurationElementArray[0].createExecutableExtension("class");
        return pathConstructor;
    }
}

