/*
 * Decompiled with CFR 0.152.
 */
package com.swtdesigner;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;

public class SWTResourceManager {
    private static HashMap<RGB, Color> m_ColorMap = new HashMap();
    private static HashMap<String, Image> m_ClassImageMap = new HashMap();
    private static HashMap<Image, HashMap<Image, Image>> m_ImageToDecoratorMap = new HashMap();
    private static final int MISSING_IMAGE_SIZE = 10;
    public static final int TOP_LEFT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int BOTTOM_LEFT = 3;
    public static final int BOTTOM_RIGHT = 4;
    private static HashMap<String, Font> m_FontMap = new HashMap();
    private static HashMap<Font, Font> m_FontToBoldFontMap = new HashMap();
    private static HashMap<Integer, Cursor> m_IdToCursorMap = new HashMap();

    public static void dispose() {
        SWTResourceManager.disposeColors();
        SWTResourceManager.disposeFonts();
        SWTResourceManager.disposeImages();
        SWTResourceManager.disposeCursors();
    }

    public static Color getColor(int n) {
        Display display = Display.getCurrent();
        return display.getSystemColor(n);
    }

    public static Color getColor(int n, int n2, int n3) {
        return SWTResourceManager.getColor(new RGB(n, n2, n3));
    }

    public static Color getColor(RGB rGB) {
        Color color = m_ColorMap.get(rGB);
        if (color == null) {
            Display display = Display.getCurrent();
            color = new Color((Device)display, rGB);
            m_ColorMap.put(rGB, color);
        }
        return color;
    }

    public static void disposeColors() {
        Iterator<Color> iterator = m_ColorMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        m_ColorMap.clear();
    }

    protected static Image getImage(InputStream inputStream) {
        Display display = Display.getCurrent();
        ImageData imageData = new ImageData(inputStream);
        if (imageData.transparentPixel > 0) {
            return new Image((Device)display, imageData, imageData.getTransparencyMask());
        }
        return new Image((Device)display, imageData);
    }

    public static Image getImage(String string) {
        return SWTResourceManager.getImage("default", string);
    }

    public static Image getImage(String string, String string2) {
        String string3 = String.valueOf(string) + '|' + SWTResourceManager.class.getName() + '|' + string2;
        Image image = m_ClassImageMap.get(string3);
        if (image == null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string2);
                image = SWTResourceManager.getImage(fileInputStream);
                m_ClassImageMap.put(string3, image);
                fileInputStream.close();
            }
            catch (Exception exception) {
                image = SWTResourceManager.getMissingImage();
                m_ClassImageMap.put(string3, image);
            }
        }
        return image;
    }

    public static Image getImage(Class<?> clazz, String string) {
        String string2 = String.valueOf(clazz.getName()) + '|' + string;
        Image image = m_ClassImageMap.get(string2);
        if (image == null) {
            try {
                if (string.length() > 0 && string.charAt(0) == '/') {
                    String string3 = string.substring(1, string.length());
                    image = SWTResourceManager.getImage(new BufferedInputStream(clazz.getClassLoader().getResourceAsStream(string3)));
                } else {
                    image = SWTResourceManager.getImage(clazz.getResourceAsStream(string));
                }
                m_ClassImageMap.put(string2, image);
            }
            catch (Exception exception) {
                image = SWTResourceManager.getMissingImage();
                m_ClassImageMap.put(string2, image);
            }
        }
        return image;
    }

    private static Image getMissingImage() {
        Image image = new Image((Device)Display.getCurrent(), 10, 10);
        GC gC = new GC((Drawable)image);
        gC.setBackground(SWTResourceManager.getColor(3));
        gC.fillRectangle(0, 0, 10, 10);
        gC.dispose();
        return image;
    }

    public static Image decorateImage(Image image, Image image2) {
        return SWTResourceManager.decorateImage(image, image2, 4);
    }

    public static Image decorateImage(Image image, Image image2, int n) {
        Image image3;
        HashMap<Object, Object> hashMap = m_ImageToDecoratorMap.get(image);
        if (hashMap == null) {
            hashMap = new HashMap();
            m_ImageToDecoratorMap.put(image, hashMap);
        }
        if ((image3 = hashMap.get(image2)) == null) {
            Rectangle rectangle = image.getBounds();
            Rectangle rectangle2 = image2.getBounds();
            image3 = new Image((Device)Display.getCurrent(), rectangle.width, rectangle.height);
            GC gC = new GC((Drawable)image3);
            gC.drawImage(image, 0, 0);
            if (n == 1) {
                gC.drawImage(image2, 0, 0);
            } else if (n == 2) {
                gC.drawImage(image2, rectangle.width - rectangle2.width - 1, 0);
            } else if (n == 3) {
                gC.drawImage(image2, 0, rectangle.height - rectangle2.height - 1);
            } else if (n == 4) {
                gC.drawImage(image2, rectangle.width - rectangle2.width - 1, rectangle.height - rectangle2.height - 1);
            }
            gC.dispose();
            hashMap.put(image2, image3);
        }
        return image3;
    }

    public static void disposeImages() {
        Iterator<Object> iterator = m_ClassImageMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        m_ClassImageMap.clear();
        for (HashMap hashMap : m_ImageToDecoratorMap.values()) {
            for (Image image : hashMap.values()) {
                image.dispose();
            }
        }
    }

    public static void disposeImages(String string) {
        Iterator<String> iterator = m_ClassImageMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string2.startsWith(String.valueOf(string) + '|')) continue;
            Image image = m_ClassImageMap.get(string2);
            image.dispose();
            iterator.remove();
        }
    }

    public static Font getFont(String string, int n, int n2) {
        return SWTResourceManager.getFont(string, n, n2, false, false);
    }

    public static Font getFont(String string, int n, int n2, boolean bl, boolean bl2) {
        String string2 = String.valueOf(string) + '|' + n + '|' + n2 + '|' + bl + '|' + bl2;
        Font font = m_FontMap.get(string2);
        if (font == null) {
            FontData fontData = new FontData(string, n, n2);
            if (bl || bl2) {
                try {
                    Class<?> clazz = Class.forName("org.eclipse.swt.internal.win32.LOGFONT");
                    Object object = FontData.class.getField("data").get(fontData);
                    if (object != null && clazz != null) {
                        if (bl) {
                            clazz.getField("lfStrikeOut").set(object, new Byte(1));
                        }
                        if (bl2) {
                            clazz.getField("lfUnderline").set(object, new Byte(1));
                        }
                    }
                }
                catch (Throwable throwable) {
                    System.err.println("Unable to set underline or strikeout (probably on a non-Windows platform). " + throwable);
                }
            }
            font = new Font((Device)Display.getCurrent(), fontData);
            m_FontMap.put(string2, font);
        }
        return font;
    }

    public static Font getBoldFont(Font font) {
        Font font2 = m_FontToBoldFontMap.get(font);
        if (font2 == null) {
            FontData[] fontDataArray = font.getFontData();
            FontData fontData = fontDataArray[0];
            font2 = new Font((Device)Display.getCurrent(), fontData.getName(), fontData.getHeight(), 1);
            m_FontToBoldFontMap.put(font, font2);
        }
        return font2;
    }

    public static void disposeFonts() {
        Iterator<Font> iterator = m_FontMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        m_FontMap.clear();
        iterator = m_FontToBoldFontMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        m_FontToBoldFontMap.clear();
    }

    public static void fixCoolBarSize(CoolBar coolBar) {
        CoolItem coolItem;
        CoolItem[] coolItemArray = coolBar.getItems();
        int n = 0;
        while (n < coolItemArray.length) {
            coolItem = coolItemArray[n];
            if (coolItem.getControl() == null) {
                coolItem.setControl((Control)new Canvas((Composite)coolBar, 0){

                    public Point computeSize(int n, int n2, boolean bl) {
                        return new Point(20, 20);
                    }
                });
            }
            ++n;
        }
        n = 0;
        while (n < coolItemArray.length) {
            coolItem = coolItemArray[n];
            Control control = coolItem.getControl();
            control.pack();
            Point point = control.getSize();
            coolItem.setSize(coolItem.computeSize(point.x, point.y));
            ++n;
        }
    }

    public static Cursor getCursor(int n) {
        Integer n2 = new Integer(n);
        Cursor cursor = m_IdToCursorMap.get(n2);
        if (cursor == null) {
            cursor = new Cursor((Device)Display.getDefault(), n);
            m_IdToCursorMap.put(n2, cursor);
        }
        return cursor;
    }

    public static void disposeCursors() {
        Iterator<Cursor> iterator = m_IdToCursorMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        m_IdToCursorMap.clear();
    }
}

