/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.interpreters;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.copiedfromeclipsesrc.JavaVmLocationFinder;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimpleJythonRunner;
import org.python.pydev.ui.interpreters.AbstractInterpreterManager;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JythonInterpreterManager
extends AbstractInterpreterManager {
    public JythonInterpreterManager(Preferences prefs) {
        super(prefs);
    }

    @Override
    protected String getPreferenceName() {
        return "JYTHON_INTERPRETER_PATH";
    }

    @Override
    protected String getNotConfiguredInterpreterMsg() {
        return "Interpreter is not properly configured!\r\nPlease go to window->preferences->PyDev->Jython Interpreters and configure it.\r\nIf this is not supposed to be a Jython project, change the project type on the\r\nproject properties to the project you want (e.g.: Python project).";
    }

    @Override
    public Tuple<InterpreterInfo, String> internalCreateInterpreterInfo(String executable, IProgressMonitor monitor) throws CoreException, JDTNotAvailableException {
        return JythonInterpreterManager.doCreateInterpreterInfo(executable, monitor);
    }

    public static Tuple<InterpreterInfo, String> doCreateInterpreterInfo(String executable, IProgressMonitor monitor) throws CoreException, JDTNotAvailableException {
        boolean isJythonExecutable = InterpreterInfo.isJythonExecutable(executable);
        if (!isJythonExecutable) {
            throw new RuntimeException("In order to get the info for the jython interpreter, a jar is needed (e.g.: jython.jar)");
        }
        File script = PydevPlugin.getScriptWithinPySrc("interpreterInfo.py");
        if (!script.exists()) {
            throw new RuntimeException(new StringBuffer("The file specified does not exist: ").append(script).toString());
        }
        Tuple<String, String> outTup = new SimpleJythonRunner().runAndGetOutputWithJar(REF.getFileAbsolutePath((File)script), executable, null, null, null, monitor);
        String output = (String)outTup.o1;
        InterpreterInfo info = JythonInterpreterManager.createInfoFromOutput(monitor, outTup);
        if (info == null) {
            return null;
        }
        info.executableOrJar = executable;
        List<File> jars = JavaVmLocationFinder.findDefaultJavaJars();
        for (File jar : jars) {
            info.libs.add(REF.getFileAbsolutePath((File)jar));
        }
        info.restoreCompiledLibs(monitor);
        return new Tuple((Object)info, (Object)output);
    }

    public int getInterpreterType() {
        return 1;
    }

    public String getManagerRelatedName() {
        return "jython";
    }
}

