/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.writer.u3d;

import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.io.JrScene;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Camera;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.Light;
import de.jreality.scene.PointLight;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.SpotLight;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.shader.CommonAttributes;
import de.jreality.shader.CubeMap;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ImageData;
import de.jreality.shader.Texture2D;
import de.jreality.shader.TextureUtility;
import de.jreality.util.SceneGraphUtility;
import de.jreality.writer.SceneWriter;
import de.jreality.writer.u3d.U3DAttribute;
import de.jreality.writer.u3d.U3DSceneUtility;
import de.jreality.writer.u3d.U3DTexture;
import de.jreality.writer.u3d.u3dencoding.BitStreamWrite;
import de.jreality.writer.u3d.u3dencoding.DataBlock;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriterU3D
implements SceneWriter {
    protected SceneGraphComponent rootNode = null;
    protected Collection<SceneGraphComponent> nodes = null;
    protected HashMap<SceneGraphComponent, Boolean> visibilityMap = null;
    protected Collection<Geometry> geometries = null;
    protected Collection<Geometry> preparedGeometries = null;
    protected Collection<SceneGraphComponent> viewNodes = null;
    protected Collection<Camera> cameras = null;
    protected HashMap<Camera, String> cameraNameMap = null;
    protected Collection<SceneGraphComponent> lightNodes = null;
    protected Collection<Light> lights = null;
    protected HashMap<Light, String> lightNameMap = new HashMap();
    protected HashMap<SceneGraphComponent, Collection<SceneGraphComponent>> parentMap = null;
    protected HashMap<SceneGraphComponent, String> nodeNameMap = null;
    protected HashMap<Geometry, String> geometryNameMap = null;
    protected HashMap<Geometry, Geometry> preparedGeometryMap = null;
    protected Collection<EffectiveAppearance> appearances = null;
    protected HashMap<SceneGraphComponent, EffectiveAppearance> appearanceMap = null;
    protected HashMap<EffectiveAppearance, String> appearanceNameMap = null;
    protected Collection<U3DTexture> textures = null;
    protected HashMap<EffectiveAppearance, U3DTexture> textureMap = null;
    protected HashMap<U3DTexture, String> textureNameMap = null;
    protected HashMap<U3DTexture, byte[]> texturePNGData = null;
    protected HashMap<EffectiveAppearance, U3DTexture> sphereMapsMap = null;
    private ByteBuffer buffer = ByteBuffer.allocate(0x100000).order(ByteOrder.LITTLE_ENDIAN);

    protected DataBlock getLightResource(Light l) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.lightNameMap.get(l));
        w.WriteU32(1L);
        if (l instanceof DirectionalLight) {
            w.WriteU8((short)1);
        } else if (l instanceof SpotLight) {
            w.WriteU8((short)3);
        } else {
            w.WriteU8((short)2);
        }
        w.WriteColor(l.getColor());
        w.WriteF32(1.0f);
        if (l instanceof PointLight) {
            PointLight attenLight = (PointLight)l;
            w.WriteF32((float)attenLight.getFalloffA0());
            w.WriteF32((float)attenLight.getFalloffA1());
            w.WriteF32((float)attenLight.getFalloffA2());
        } else {
            w.WriteF32(1.0f);
            w.WriteF32(1.0f);
            w.WriteF32(1.0f);
        }
        if (l instanceof SpotLight) {
            SpotLight spotLight = (SpotLight)l;
            w.WriteF32((float)spotLight.getConeAngle());
        } else {
            w.WriteF32(45.0f);
        }
        w.WriteF32((float)l.getIntensity());
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-175L);
        return b;
    }

    protected DataBlock getLightNodeDeclaration(SceneGraphComponent c) {
        Light light = c.getLight();
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.nodeNameMap.get(c) + ".light");
        w.WriteU32(1L);
        w.WriteString(this.nodeNameMap.get(c));
        this.WriteMatrix(MatrixBuilder.euclidean().getArray(), w);
        w.WriteString(this.lightNameMap.get(light));
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-221L);
        return b;
    }

    protected DataBlock getViewResource(Camera c) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.cameraNameMap.get(c));
        w.WriteU32(1L);
        w.WriteString(this.nodeNameMap.get(this.rootNode));
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.WriteColor(Color.GRAY);
        w.WriteF32(1.0f);
        w.WriteF32((float)c.getNear());
        w.WriteF32((float)c.getFar());
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-174L);
        return b;
    }

    protected DataBlock getViewNodeDeclaration(SceneGraphComponent c) {
        Camera cam = c.getCamera();
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.nodeNameMap.get(c) + ".camera");
        w.WriteU32(1L);
        w.WriteString(this.nodeNameMap.get(c));
        this.WriteMatrix(MatrixBuilder.euclidean().getArray(), w);
        w.WriteString(this.cameraNameMap.get(cam));
        w.WriteU32(0L);
        w.WriteF32((float)cam.getNear());
        w.WriteF32((float)cam.getFar());
        w.WriteF32((float)cam.getFieldOfView());
        Rectangle2D viewport = cam.getViewPort();
        if (viewport != null) {
            w.WriteF32((float)viewport.getWidth());
            w.WriteF32((float)viewport.getHeight());
            w.WriteF32((float)viewport.getX());
            w.WriteF32((float)viewport.getY());
        } else {
            w.WriteF32(100.0f);
            w.WriteF32(100.0f);
            w.WriteF32(0.0f);
            w.WriteF32(0.0f);
        }
        w.WriteU32(0L);
        w.WriteU32(0L);
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-220L);
        return b;
    }

    protected DataBlock getPointSetContinuation(PointSet g) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.geometryNameMap.get(g));
        w.WriteU32(0L);
        DoubleArrayArray vData = (DoubleArrayArray)g.getVertexAttributes(Attribute.COORDINATES);
        Object vertices = null;
        vertices = vData != null ? vData.toDoubleArrayArray(null) : (Object)new double[0][];
        DoubleArrayArray nData = (DoubleArrayArray)g.getVertexAttributes(Attribute.NORMALS);
        double[][] normals = null;
        if (nData != null) {
            normals = nData.toDoubleArrayArray(null);
        }
        w.WriteU32(0L);
        w.WriteU32(((double[][])vertices).length);
        float m_fQuantPosition = (float)Math.pow(2.0, 18.0);
        m_fQuantPosition = Math.max(m_fQuantPosition, 1.6711679E7f);
        float m_fQuantNormal = (float)Math.pow(2.0, 14.0);
        for (int currPosInd = 0; currPosInd < ((double[][])vertices).length; ++currPosInd) {
            double[] vPositionDifference;
            double[] v;
            int splitPosInd = currPosInd - 1;
            if (splitPosInd == -1) {
                w.WriteCompressedU32(1025L, 0L);
            } else {
                w.WriteCompressedU32(1024 + currPosInd, splitPosInd);
            }
            double[] vPosition = vertices[currPosInd];
            double[] vPredictedPosition = new double[3];
            if (splitPosInd >= 0) {
                vPredictedPosition = vertices[splitPosInd];
            }
            short u8Signs = (short)(((v = (vPositionDifference = Rn.subtract(null, vPosition, vPredictedPosition)))[0] < 0.0 ? 1 : 0) | (v[1] < 0.0 ? 1 : 0) << 1 | (v[2] < 0.0 ? 1 : 0) << 2);
            long udX = (long)(0.5 + (double)m_fQuantPosition * Math.abs(v[0]));
            long udY = (long)(0.5 + (double)m_fQuantPosition * Math.abs(v[1]));
            long udZ = (long)(0.5 + (double)m_fQuantPosition * Math.abs(v[2]));
            w.WriteCompressedU8(20L, u8Signs);
            w.WriteCompressedU32(21L, udX);
            w.WriteCompressedU32(22L, udY);
            w.WriteCompressedU32(23L, udZ);
            if (nData != null) {
                double[] nPositionDifference;
                double[] n;
                w.WriteCompressedU32(40L, 1L);
                double[] nPosition = normals[currPosInd];
                double[] nPredictedPosition = new double[3];
                if (splitPosInd >= 0) {
                    nPredictedPosition = normals[splitPosInd];
                }
                u8Signs = (short)(((n = (nPositionDifference = Rn.subtract(null, nPosition, nPredictedPosition)))[0] < 0.0 ? 1 : 0) | (n[1] < 0.0 ? 1 : 0) << 1 | (n[2] < 0.0 ? 1 : 0) << 2);
                udX = (long)(0.5 + (double)m_fQuantNormal * Math.abs(n[0]));
                udY = (long)(0.5 + (double)m_fQuantNormal * Math.abs(n[1]));
                udZ = (long)(0.5 + (double)m_fQuantNormal * Math.abs(n[2]));
                w.WriteCompressedU8(20L, u8Signs);
                w.WriteCompressedU32(21L, udX);
                w.WriteCompressedU32(22L, udY);
                w.WriteCompressedU32(23L, udZ);
            } else {
                w.WriteCompressedU32(40L, 0L);
            }
            w.WriteCompressedU32(1L, 0L);
        }
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-194L);
        return b;
    }

    protected DataBlock getLineSetContinuation(IndexedLineSet g) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.geometryNameMap.get(g));
        w.WriteU32(0L);
        DoubleArrayArray vData = (DoubleArrayArray)g.getVertexAttributes(Attribute.COORDINATES);
        Object vertices = null;
        vertices = vData != null ? vData.toDoubleArrayArray(null) : (Object)new double[0][];
        Object indices = null;
        IntArrayArray iData = (IntArrayArray)g.getEdgeAttributes(Attribute.INDICES);
        indices = iData != null ? iData.toIntArrayArray(null) : (Object)new int[0][];
        DoubleArrayArray nData = (DoubleArrayArray)g.getVertexAttributes(Attribute.NORMALS);
        double[][] normals = null;
        if (nData != null) {
            normals = nData.toDoubleArrayArray(null);
        }
        w.WriteU32(0L);
        w.WriteU32(((double[][])vertices).length);
        float m_fQuantPosition = (float)Math.pow(2.0, 18.0);
        m_fQuantPosition = Math.max(m_fQuantPosition, 1.6711679E7f);
        float m_fQuantNormal = (float)Math.pow(2.0, 14.0);
        for (int currPosInd = 0; currPosInd < ((double[][])vertices).length; ++currPosInd) {
            double[] vPositionDifference;
            double[] v;
            int splitPosInd = currPosInd - 1;
            if (splitPosInd == -1) {
                w.WriteCompressedU32(1025L, 0L);
            } else {
                w.WriteCompressedU32(1024 + currPosInd, splitPosInd);
            }
            double[] vPosition = vertices[currPosInd];
            double[] vPredictedPosition = new double[3];
            if (splitPosInd >= 0) {
                vPredictedPosition = vertices[splitPosInd];
            }
            short u8Signs = (short)(((v = (vPositionDifference = Rn.subtract(null, vPosition, vPredictedPosition)))[0] < 0.0 ? 1 : 0) | (v[1] < 0.0 ? 1 : 0) << 1 | (v[2] < 0.0 ? 1 : 0) << 2);
            long udX = (long)(0.5 + (double)m_fQuantPosition * Math.abs(v[0]));
            long udY = (long)(0.5 + (double)m_fQuantPosition * Math.abs(v[1]));
            long udZ = (long)(0.5 + (double)m_fQuantPosition * Math.abs(v[2]));
            w.WriteCompressedU8(20L, u8Signs);
            w.WriteCompressedU32(21L, udX);
            w.WriteCompressedU32(22L, udY);
            w.WriteCompressedU32(23L, udZ);
            if (nData != null) {
                double[] nPositionDifference;
                double[] n;
                w.WriteCompressedU32(40L, 1L);
                double[] nPosition = normals[currPosInd];
                double[] nPredictedPosition = new double[3];
                if (splitPosInd >= 0) {
                    nPredictedPosition = normals[splitPosInd];
                }
                u8Signs = (short)(((n = (nPositionDifference = Rn.subtract(null, nPosition, nPredictedPosition)))[0] < 0.0 ? 1 : 0) | (n[1] < 0.0 ? 1 : 0) << 1 | (n[2] < 0.0 ? 1 : 0) << 2);
                udX = (long)(0.5 + (double)m_fQuantNormal * Math.abs(n[0]));
                udY = (long)(0.5 + (double)m_fQuantNormal * Math.abs(n[1]));
                udZ = (long)(0.5 + (double)m_fQuantNormal * Math.abs(n[2]));
                w.WriteCompressedU8(20L, u8Signs);
                w.WriteCompressedU32(21L, udX);
                w.WriteCompressedU32(22L, udY);
                w.WriteCompressedU32(23L, udZ);
            } else {
                w.WriteCompressedU32(40L, 0L);
            }
            LinkedList<Integer> connectedPoints = new LinkedList<Integer>();
            for (int i = 0; i < ((int[][])indices).length; ++i) {
                if (indices[i][0] != currPosInd) continue;
                connectedPoints.add(indices[i][1]);
            }
            w.WriteCompressedU32(1L, connectedPoints.size());
            for (Integer i : connectedPoints) {
                w.WriteCompressedU32(1L, 0L);
                w.WriteCompressedU32(1024 + currPosInd + 1, i.intValue());
            }
        }
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-193L);
        return b;
    }

    protected DataBlock getCLODBaseMeshContinuation(IndexedFaceSet g) {
        double[] n;
        double[] v;
        int i;
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.geometryNameMap.get(g));
        int vertCount = g.getNumPoints();
        int faceCount = g.getNumFaces();
        DoubleArrayArray tvData = (DoubleArrayArray)g.getVertexAttributes(Attribute.TEXTURE_COORDINATES);
        double[][] tVerts = null;
        int tvertCount = 0;
        if (tvData != null) {
            tvertCount = tvData.size();
            tVerts = tvData.toDoubleArrayArray(null);
        }
        boolean noNormals = g.getVertexAttributes(U3DAttribute.U3D_NONORMALS) != null;
        DoubleArrayArray vnData = (DoubleArrayArray)g.getVertexAttributes(Attribute.NORMALS);
        if (noNormals) {
            vnData = null;
        }
        double[][] vNormals = null;
        int vnCount = 0;
        if (vnData != null) {
            try {
                vNormals = vnData.toDoubleArrayArray(null);
            }
            catch (Exception e) {
                vNormals = IndexedFaceSetUtility.calculateVertexNormals(g);
            }
            vnCount = vNormals.length;
        }
        DoubleArrayArray fnData = (DoubleArrayArray)g.getFaceAttributes(Attribute.NORMALS);
        if (noNormals) {
            fnData = null;
        }
        double[][] fNormals = null;
        int fnCount = 0;
        if (fnData != null && vnData == null) {
            try {
                fNormals = fnData.toDoubleArrayArray(null);
            }
            catch (Exception e) {
                fNormals = IndexedFaceSetUtility.calculateFaceNormals(g);
            }
            fnCount = fNormals.length;
        }
        w.WriteU32(0L);
        w.WriteU32(faceCount);
        w.WriteU32(vertCount);
        w.WriteU32(vnCount != 0 ? (long)vnCount : (long)fnCount);
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.WriteU32(tvertCount == 0 ? 1L : (long)tvertCount);
        DoubleArrayArray vData = (DoubleArrayArray)g.getVertexAttributes(Attribute.COORDINATES);
        double[][] vertices = null;
        vertices = vData == null ? new double[0][0] : vData.toDoubleArrayArray(null);
        IntArrayArray fData = (IntArrayArray)g.getFaceAttributes(Attribute.INDICES);
        int[][] faces = null;
        faces = fData == null ? new int[0][0] : fData.toIntArrayArray(null);
        for (i = 0; i < vertCount; ++i) {
            v = vertices[i];
            if (v.length > 3) {
                Pn.dehomogenize(v, v);
            }
            w.WriteF32((float)v[0]);
            w.WriteF32((float)v[1]);
            w.WriteF32((float)v[2]);
        }
        if (vnCount != 0) {
            for (i = 0; i < vNormals.length; ++i) {
                n = vNormals[i];
                w.WriteF32((float)n[0]);
                w.WriteF32((float)n[1]);
                w.WriteF32((float)n[2]);
            }
        } else if (fnCount != 0) {
            for (i = 0; i < fNormals.length; ++i) {
                n = fNormals[i];
                w.WriteF32((float)n[0]);
                w.WriteF32((float)n[1]);
                w.WriteF32((float)n[2]);
            }
        }
        if (tvertCount != 0) {
            for (i = 0; i < tVerts.length; ++i) {
                v = tVerts[i];
                w.WriteF32((float)v[0]);
                w.WriteF32((float)v[1]);
                w.WriteF32(0.0f);
                w.WriteF32(0.0f);
            }
        } else {
            w.WriteF32(0.0f);
            w.WriteF32(0.0f);
            w.WriteF32(0.0f);
            w.WriteF32(0.0f);
        }
        for (i = 0; i < faceCount; ++i) {
            int[] f = faces[i];
            w.WriteCompressedU32(1L, 0L);
            for (int j = 0; j < 3; ++j) {
                w.WriteCompressedU32(1024 + vertCount, f[j]);
                if (vnData != null) {
                    w.WriteCompressedU32(1024 + vnCount, f[j]);
                } else if (fnData != null) {
                    w.WriteCompressedU32(1024 + fnCount, i);
                }
                w.WriteCompressedU32(1024 + (tvertCount == 0 ? 1 : tvertCount), tvertCount == 0 ? 0L : (long)f[j]);
            }
        }
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-197L);
        return b;
    }

    protected List<DataBlock> getContinuations(Geometry g) {
        LinkedList<DataBlock> r = new LinkedList<DataBlock>();
        DataBlock geomCont = null;
        if (g instanceof IndexedFaceSet) {
            geomCont = this.getCLODBaseMeshContinuation((IndexedFaceSet)g);
        } else if (g instanceof IndexedLineSet) {
            geomCont = this.getLineSetContinuation((IndexedLineSet)g);
        } else if (g instanceof PointSet) {
            geomCont = this.getPointSetContinuation((PointSet)g);
        }
        if (geomCont != null) {
            r.add(geomCont);
        }
        return r;
    }

    protected DataBlock getTextureContinuation(U3DTexture tex) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.textureNameMap.get(tex));
        w.WriteU32(0L);
        byte[] pngData = this.texturePNGData.get(tex);
        for (int i = 0; i < pngData.length; ++i) {
            short unsignedByte = 255;
            unsignedByte = (short)(unsignedByte & pngData[i]);
            w.WriteU8(unsignedByte);
        }
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-164L);
        return b;
    }

    protected List<DataBlock> getContinuations(U3DTexture tex) {
        LinkedList<DataBlock> r = new LinkedList<DataBlock>();
        r.add(this.getTextureContinuation(tex));
        return r;
    }

    protected List<DataBlock> getContinuations(SceneGraphComponent c) {
        LinkedList<DataBlock> r = new LinkedList<DataBlock>();
        return r;
    }

    protected DataBlock getPointSetDeclaration(PointSet g) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.geometryNameMap.get(g));
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.WriteU32(g.getNumPoints());
        DoubleArrayArray nData = (DoubleArrayArray)g.getVertexAttributes(Attribute.NORMALS);
        if (nData != null) {
            w.WriteU32(nData.size());
        } else {
            w.WriteU32(0L);
        }
        DoubleArrayArray vColors = (DoubleArrayArray)g.getVertexAttributes(Attribute.COLORS);
        if (vColors != null) {
            w.WriteU32(vColors.size());
        } else {
            w.WriteU32(0L);
        }
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.WriteU32(1L);
        w.WriteU32(0L);
        w.WriteU32(1L);
        w.WriteU32(2L);
        w.WriteU32(0L);
        w.WriteU32(1000L);
        w.WriteU32(1000L);
        w.WriteU32(1000L);
        float m_fQuantPosition = (float)Math.pow(2.0, 18.0);
        m_fQuantPosition = Math.max(m_fQuantPosition, 1.6711679E7f);
        float m_fQuantNormal = (float)Math.pow(2.0, 14.0);
        float m_fQuantTexCoord = (float)Math.pow(2.0, 14.0);
        float m_fQuantDiffuseColor = (float)Math.pow(2.0, 14.0);
        float m_fQuantSpecularColor = (float)Math.pow(2.0, 14.0);
        w.WriteF32(1.0f / m_fQuantPosition);
        w.WriteF32(1.0f / m_fQuantNormal);
        w.WriteF32(1.0f / m_fQuantTexCoord);
        w.WriteF32(1.0f / m_fQuantDiffuseColor);
        w.WriteF32(1.0f / m_fQuantSpecularColor);
        for (int i = 0; i < 3; ++i) {
            w.WriteF32(1.0f);
        }
        w.WriteU32(0L);
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-202L);
        return b;
    }

    protected DataBlock getLineSetDeclaration(IndexedLineSet g) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.geometryNameMap.get(g));
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.WriteU32(g.getNumEdges());
        w.WriteU32(g.getNumPoints());
        DoubleArrayArray nData = (DoubleArrayArray)g.getVertexAttributes(Attribute.NORMALS);
        if (nData != null) {
            w.WriteU32(nData.size());
        } else {
            w.WriteU32(0L);
        }
        DoubleArrayArray vColors = (DoubleArrayArray)g.getVertexAttributes(Attribute.COLORS);
        if (vColors != null) {
            w.WriteU32(vColors.size());
        } else {
            w.WriteU32(0L);
        }
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.WriteU32(1L);
        w.WriteU32(0L);
        w.WriteU32(1L);
        w.WriteU32(2L);
        w.WriteU32(0L);
        w.WriteU32(1000L);
        w.WriteU32(1000L);
        w.WriteU32(1000L);
        float m_fQuantPosition = (float)Math.pow(2.0, 18.0);
        m_fQuantPosition = Math.max(m_fQuantPosition, 1.6711679E7f);
        float m_fQuantNormal = (float)Math.pow(2.0, 14.0);
        float m_fQuantTexCoord = (float)Math.pow(2.0, 14.0);
        float m_fQuantDiffuseColor = (float)Math.pow(2.0, 14.0);
        float m_fQuantSpecularColor = (float)Math.pow(2.0, 14.0);
        w.WriteF32(1.0f / m_fQuantPosition);
        w.WriteF32(1.0f / m_fQuantNormal);
        w.WriteF32(1.0f / m_fQuantTexCoord);
        w.WriteF32(1.0f / m_fQuantDiffuseColor);
        w.WriteF32(1.0f / m_fQuantSpecularColor);
        for (int i = 0; i < 3; ++i) {
            w.WriteF32(0.0f);
        }
        w.WriteU32(0L);
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-141L);
        return b;
    }

    protected void WriteResourceDescriptionDummy(BitStreamWrite w) {
        int i;
        w.WriteU32(1000L);
        w.WriteU32(1000L);
        w.WriteU32(1000L);
        for (i = 0; i < 5; ++i) {
            w.WriteF32(1.0f);
        }
        for (i = 0; i < 3; ++i) {
            w.WriteF32(1.0f);
        }
    }

    protected DataBlock getCLODMeshGeneratorDeclaration(IndexedFaceSet g) {
        boolean noNormals;
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.geometryNameMap.get(g));
        w.WriteU32(0L);
        DoubleArrayArray tvData = (DoubleArrayArray)g.getVertexAttributes(Attribute.TEXTURE_COORDINATES);
        DoubleArrayArray vnData = (DoubleArrayArray)g.getVertexAttributes(Attribute.NORMALS);
        DoubleArrayArray fnData = (DoubleArrayArray)g.getFaceAttributes(Attribute.NORMALS);
        boolean bl = noNormals = g.getVertexAttributes(U3DAttribute.U3D_NONORMALS) != null;
        if (noNormals || vnData == null && fnData == null) {
            w.WriteU32(1L);
        } else {
            w.WriteU32(0L);
        }
        w.WriteU32(g.getNumFaces());
        w.WriteU32(g.getNumPoints());
        if (noNormals) {
            w.WriteU32(0L);
        } else {
            w.WriteU32(vnData != null ? (long)vnData.size() : (long)(fnData != null ? fnData.size() : 0));
        }
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.WriteU32(tvData == null ? 1L : (long)tvData.size());
        w.WriteU32(1L);
        w.WriteU32(0L);
        if (tvData != null) {
            w.WriteU32(1L);
        } else {
            w.WriteU32(0L);
        }
        w.WriteU32(2L);
        w.WriteU32(0L);
        w.WriteU32(g.getNumPoints());
        w.WriteU32(g.getNumPoints());
        this.WriteResourceDescriptionDummy(w);
        w.WriteU32(0L);
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-207L);
        return b;
    }

    protected void WriteMatrix(double[] T, BitStreamWrite w) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                w.WriteF32((float)T[4 * j + i]);
            }
        }
    }

    protected void WriteTransform(SceneGraphComponent c, BitStreamWrite w) {
        double[] T = Rn.setIdentityMatrix(new double[16]);
        if (c.getTransformation() != null) {
            c.getTransformation().getMatrix(T);
        }
        this.WriteMatrix(T, w);
    }

    protected void WriteParentNodeData(SceneGraphComponent c, BitStreamWrite w) {
        Collection<SceneGraphComponent> parents = this.parentMap.get(c);
        if (parents.size() == 0) {
            w.WriteU32(1L);
            w.WriteString("");
            this.WriteMatrix(MatrixBuilder.euclidean(c).rotate(Math.PI, 0.0, 0.0, 1.0).rotate(1.5707963267948966, 1.0, 0.0, 0.0).getArray(), w);
        } else {
            w.WriteU32(parents.size());
            for (SceneGraphComponent p : parents) {
                w.WriteString(this.nodeNameMap.get(p));
                this.WriteTransform(c, w);
            }
        }
    }

    protected DataBlock getGroupNodeDeclaration(SceneGraphComponent c) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.nodeNameMap.get(c));
        this.WriteParentNodeData(c, w);
        DataBlock b = null;
        b = w.GetDataBlock();
        b.setBlockType(-223L);
        return b;
    }

    protected DataBlock getModelNodeDeclaration(SceneGraphComponent c) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.nodeNameMap.get(c));
        this.WriteParentNodeData(c, w);
        Geometry g = this.getPreparedGeometry(c);
        w.WriteString(this.geometryNameMap.get(g));
        if (!this.visibilityMap.get(c).booleanValue()) {
            w.WriteU32(0L);
        } else {
            w.WriteU32(3L);
        }
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-222L);
        return b;
    }

    protected DataBlock getShadingModifier(SceneGraphComponent c, long chainIndex) {
        BitStreamWrite w = new BitStreamWrite();
        EffectiveAppearance ea = this.appearanceMap.get(c);
        w.WriteString(this.nodeNameMap.get(c));
        w.WriteU32(chainIndex);
        Geometry p = this.getPreparedGeometry(c);
        if (p instanceof IndexedFaceSet) {
            w.WriteU32(1L);
        } else if (p instanceof IndexedLineSet) {
            w.WriteU32(2L);
        } else if (p instanceof PointSet) {
            w.WriteU32(4L);
        }
        w.WriteU32(1L);
        w.WriteU32(1L);
        w.WriteString(this.appearanceNameMap.get(ea));
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-187L);
        return b;
    }

    protected List<DataBlock> getNodeModifiers(SceneGraphComponent c) {
        LinkedList<DataBlock> r = new LinkedList<DataBlock>();
        if (this.getPreparedGeometry(c) != null) {
            r.add(this.getModelNodeDeclaration(c));
            r.add(this.getShadingModifier(c, 1L));
        } else {
            r.add(this.getGroupNodeDeclaration(c));
        }
        return r;
    }

    protected DataBlock getMaterialResource(EffectiveAppearance a) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.appearanceNameMap.get(a));
        long attribs = 39L;
        w.WriteU32(attribs);
        U3DTexture envMap = this.sphereMapsMap.get(a);
        float envIntensity = 0.0f;
        if (envMap != null) {
            CubeMap tex = TextureUtility.readReflectionMap(a, "polygonShader.reflectionMap");
            envIntensity = (float)tex.getBlendColor().getAlpha() / 255.0f;
        }
        Color ambient = (Color)a.getAttribute("polygonShader.ambientColor", CommonAttributes.AMBIENT_COLOR_DEFAULT);
        float ambiCoeff = (float)a.getAttribute("polygonShader.ambientCoefficient", 0.0);
        float[] amb = ambient.getColorComponents(null);
        if (envMap != null) {
            ambiCoeff *= 1.0f - envIntensity;
        }
        ambient = new Color(amb[0] * ambiCoeff, amb[1] * ambiCoeff, amb[2] * ambiCoeff);
        w.WriteColor(ambient);
        Color diffuse = (Color)a.getAttribute("polygonShader.diffuseColor", CommonAttributes.DIFFUSE_COLOR_DEFAULT);
        float diffCoeff = (float)a.getAttribute("polygonShader.diffuseCoefficient", 1.0);
        if (envMap != null) {
            diffCoeff *= 1.0f - envIntensity;
        }
        float[] dif = diffuse.getColorComponents(null);
        diffuse = new Color(dif[0] * diffCoeff, dif[1] * diffCoeff, dif[2] * diffCoeff);
        w.WriteColor(diffuse);
        Color specular = (Color)a.getAttribute("polygonShader.specularColor", CommonAttributes.SPECULAR_COLOR_DEFAULT);
        float specCoeff = (float)a.getAttribute("polygonShader.specularCoefficient", 0.7);
        if (envMap != null) {
            specCoeff *= 1.0f - envIntensity;
        }
        float[] s = specular.getColorComponents(null);
        specular = new Color(s[0] * specCoeff, s[1] * specCoeff, s[2] * specCoeff);
        w.WriteColor(specular);
        w.WriteColor(ambient);
        double reflectivity = a.getAttribute("polygonShader.specularExponent", 60.0) / 128.0;
        w.WriteF32((float)reflectivity);
        boolean alphaEnabled = a.getAttribute("polygonShader.transparencyEnabled", false);
        double opacity = 1.0 - a.getAttribute("polygonShader.transparency", 0.0);
        if (!alphaEnabled) {
            opacity = 1.0;
        }
        w.WriteF32((float)opacity);
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-172L);
        return b;
    }

    protected DataBlock getLitTextureShader(EffectiveAppearance a) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.appearanceNameMap.get(a));
        boolean lightingEnabled = a.getAttribute("polygonShader.lightingEnabled", true);
        boolean alphaEnabled = a.getAttribute("polygonShader.transparencyEnabled", false);
        boolean useVertexColors = a.getAttribute("polygonShader.vertexColors", false);
        long attributes = 0L;
        if (lightingEnabled) {
            attributes |= 1L;
        }
        if (alphaEnabled) {
            attributes |= 2L;
        }
        if (useVertexColors) {
            attributes |= 4L;
        }
        w.WriteU32(attributes);
        w.WriteF32(0.0f);
        w.WriteU32(1559L);
        w.WriteU32(1542L);
        w.WriteU32(1L);
        U3DTexture tex = this.textureMap.get(a);
        U3DTexture envMap = this.sphereMapsMap.get(a);
        long shaderChannels = 0L;
        long alphatexChannels = 0L;
        float texIntensity = 1.0f;
        float envIntensity = 1.0f;
        if (tex != null) {
            Texture2D tex2d = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, "polygonShader.texture2d", a);
            shaderChannels |= 1L;
            alphatexChannels |= 1L;
            texIntensity *= (float)tex2d.getBlendColor().getAlpha() / 255.0f;
        }
        if (envMap != null) {
            CubeMap envTex = TextureUtility.readReflectionMap(a, "polygonShader.reflectionMap");
            shaderChannels |= 2L;
            alphatexChannels |= 1L;
            texIntensity *= 1.0f - (envIntensity *= (float)envTex.getBlendColor().getAlpha() / 255.0f);
        }
        w.WriteU32(shaderChannels);
        w.WriteU32(alphatexChannels);
        w.WriteString(this.appearanceNameMap.get(a));
        if (tex != null) {
            Texture2D texInfo = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, "polygonShader.texture2d", a);
            w.WriteString(this.textureNameMap.get(tex));
            w.WriteF32(texIntensity);
            switch (texInfo.getApplyMode()) {
                case 8448: {
                    w.WriteU8((short)0);
                    break;
                }
                case 260: {
                    w.WriteU8((short)1);
                    break;
                }
                case 7681: {
                    w.WriteU8((short)2);
                    break;
                }
                case 3042: {
                    w.WriteU8((short)3);
                    break;
                }
                default: {
                    w.WriteU8((short)2);
                }
            }
            w.WriteU8((short)0);
            w.WriteF32(1.0f);
            w.WriteU8((short)0);
            Matrix T = texInfo.getTextureMatrix();
            this.WriteMatrix(T.getArray(), w);
            this.WriteMatrix(MatrixBuilder.euclidean().getArray(), w);
            short repeat = 0;
            if (texInfo.getRepeatS() == 10497) {
                repeat = (short)(repeat | 1);
            }
            if (texInfo.getRepeatT() == 10497) {
                repeat = (short)(repeat | 2);
            }
            w.WriteU8(repeat);
        }
        if (envMap != null) {
            w.WriteString(this.textureNameMap.get(envMap));
            w.WriteF32(envIntensity);
            w.WriteU8((short)2);
            w.WriteU8((short)0);
            w.WriteF32(1.0f);
            w.WriteU8((short)4);
            this.WriteMatrix(MatrixBuilder.euclidean().getArray(), w);
            this.WriteMatrix(MatrixBuilder.euclidean().getArray(), w);
            short repeat = 3;
            w.WriteU8(repeat);
        }
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-173L);
        return b;
    }

    protected DataBlock getTextureResourceDeclaration(U3DTexture tex) {
        ImageData img = tex.getImage();
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.textureNameMap.get(tex));
        w.WriteU32(img.getHeight());
        w.WriteU32(img.getWidth());
        w.WriteU8((short)15);
        w.WriteU32(1L);
        w.WriteU8((short)2);
        w.WriteU8((short)15);
        w.WriteU16(0);
        byte[] pngData = this.texturePNGData.get(tex);
        w.WriteU32(pngData.length);
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-171L);
        return b;
    }

    protected DataBlock getModifierChain(U3DTexture tex) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.textureNameMap.get(tex));
        w.WriteU32(2L);
        w.WriteU32(0L);
        w.AlignTo4Byte();
        w.WriteU32(1L);
        w.WriteDataBlock(this.getTextureResourceDeclaration(tex));
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-236L);
        return b;
    }

    protected DataBlock getModifierChain(Geometry g) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.geometryNameMap.get(g));
        w.WriteU32(1L);
        w.WriteU32(0L);
        w.AlignTo4Byte();
        w.WriteU32(1L);
        DataBlock geomDecl = null;
        if (g instanceof IndexedFaceSet) {
            geomDecl = this.getCLODMeshGeneratorDeclaration((IndexedFaceSet)g);
        } else if (g instanceof IndexedLineSet) {
            geomDecl = this.getLineSetDeclaration((IndexedLineSet)g);
        } else if (g instanceof PointSet) {
            geomDecl = this.getPointSetDeclaration((PointSet)g);
        }
        if (geomDecl != null) {
            w.WriteDataBlock(geomDecl);
        }
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-236L);
        return b;
    }

    protected DataBlock getLightNodeModifierChain(SceneGraphComponent c) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.nodeNameMap.get(c));
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.AlignTo4Byte();
        w.WriteU32(1L);
        w.WriteDataBlock(this.getLightNodeDeclaration(c));
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-236L);
        return b;
    }

    protected DataBlock getViewNodeModifierChain(SceneGraphComponent c) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.nodeNameMap.get(c));
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.AlignTo4Byte();
        w.WriteU32(1L);
        w.WriteDataBlock(this.getViewNodeDeclaration(c));
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-236L);
        return b;
    }

    protected DataBlock getModifierChain(SceneGraphComponent c) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteString(this.nodeNameMap.get(c));
        w.WriteU32(0L);
        w.WriteU32(0L);
        w.AlignTo4Byte();
        List<DataBlock> modifiers = this.getNodeModifiers(c);
        w.WriteU32(modifiers.size());
        for (DataBlock modBlock : modifiers) {
            w.WriteDataBlock(modBlock);
        }
        DataBlock b = w.GetDataBlock();
        b.setBlockType(-236L);
        return b;
    }

    protected List<DataBlock> getMaterialBlocks(EffectiveAppearance a) {
        LinkedList<DataBlock> r = new LinkedList<DataBlock>();
        U3DTexture tex = this.textureMap.get(a);
        if (tex != null) {
            r.add(this.getModifierChain(tex));
        }
        r.add(this.getLitTextureShader(a));
        r.add(this.getMaterialResource(a));
        return r;
    }

    protected DataBlock getHeaderBlock(int declSize, long contSize) {
        BitStreamWrite w = new BitStreamWrite();
        w.WriteI16((short)1);
        w.WriteI16((short)0);
        w.WriteU32(0L);
        w.WriteU32(declSize);
        w.WriteU64(36L + contSize + (long)declSize);
        w.WriteU32(106L);
        DataBlock b = w.GetDataBlock();
        b.setBlockType(0x443355L);
        return b;
    }

    protected void writeDataBlock(DataBlock b, WritableByteChannel o) throws IOException {
        int i;
        int dataSize = (int)Math.ceil((double)b.getDataSize() / 4.0);
        int metaDataSize = (int)Math.ceil((double)b.getMetaDataSize() / 4.0);
        int blockLength = 12 + 4 * (dataSize + metaDataSize);
        if (this.buffer.capacity() < blockLength) {
            this.buffer = ByteBuffer.allocate(blockLength);
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.buffer.position(0);
        this.buffer.limit(blockLength);
        this.buffer.putInt((int)b.getBlockType());
        this.buffer.putInt((int)b.getDataSize());
        this.buffer.putInt((int)b.getMetaDataSize());
        for (i = 0; i < dataSize; ++i) {
            this.buffer.putInt((int)b.getData()[i]);
        }
        for (i = 0; i < metaDataSize; ++i) {
            this.buffer.putInt((int)b.getMetaData()[i]);
        }
        this.buffer.rewind();
        o.write(this.buffer);
    }

    @Override
    public void writeScene(JrScene scene, OutputStream out) throws IOException {
        System.out.print("U3D Export: prepare data...");
        this.prepareSceneData(scene);
        System.out.print("writing...");
        WritableByteChannel o = Channels.newChannel(out);
        this.writeDataBlock(this.getHeaderBlock(0, 0L), o);
        for (SceneGraphComponent sceneGraphComponent : this.nodes) {
            this.writeDataBlock(this.getModifierChain(sceneGraphComponent), o);
            if (this.getPreparedGeometry(sceneGraphComponent) == null) continue;
            EffectiveAppearance a = this.appearanceMap.get(sceneGraphComponent);
            for (DataBlock b : this.getMaterialBlocks(a)) {
                this.writeDataBlock(b, o);
            }
        }
        for (SceneGraphComponent sceneGraphComponent : this.viewNodes) {
            this.writeDataBlock(this.getViewNodeModifierChain(sceneGraphComponent), o);
        }
        for (SceneGraphComponent sceneGraphComponent : this.lightNodes) {
            this.writeDataBlock(this.getLightNodeModifierChain(sceneGraphComponent), o);
        }
        for (Geometry geometry : this.preparedGeometries) {
            this.writeDataBlock(this.getModifierChain(geometry), o);
        }
        for (U3DTexture u3DTexture : this.textures) {
            this.writeDataBlock(this.getModifierChain(u3DTexture), o);
        }
        for (SceneGraphComponent sceneGraphComponent : this.nodes) {
            for (DataBlock b : this.getContinuations(sceneGraphComponent)) {
                this.writeDataBlock(b, o);
            }
        }
        for (Camera camera : this.cameras) {
            this.writeDataBlock(this.getViewResource(camera), o);
        }
        for (Light light : this.lights) {
            this.writeDataBlock(this.getLightResource(light), o);
        }
        for (Geometry geometry : this.preparedGeometries) {
            for (DataBlock b : this.getContinuations(geometry)) {
                this.writeDataBlock(b, o);
            }
        }
        for (U3DTexture u3DTexture : this.textures) {
            for (DataBlock b : this.getContinuations(u3DTexture)) {
                this.writeDataBlock(b, o);
            }
        }
        o.close();
        System.out.println("done.");
    }

    @Override
    @Deprecated
    public void writeScene(JrScene scene, Writer out) throws IOException {
        throw new UnsupportedOperationException("U3D is a binary file format");
    }

    @Override
    public void write(SceneGraphNode c, OutputStream out) throws IOException {
        SceneGraphComponent root = null;
        if (c instanceof SceneGraphComponent) {
            root = (SceneGraphComponent)c;
        } else {
            root = new SceneGraphComponent();
            SceneGraphUtility.addChildNode(root, c);
        }
        JrScene scene = new JrScene(root);
        this.writeScene(scene, out);
    }

    public static void write(JrScene scene, OutputStream out) throws IOException {
        WriterU3D writer = new WriterU3D();
        writer.writeScene(scene, out);
    }

    protected Geometry getPreparedGeometry(SceneGraphComponent c) {
        Geometry g = c.getGeometry();
        if (g == null) {
            return null;
        }
        Geometry p = this.preparedGeometryMap.get(g);
        return p;
    }

    protected void prepareSceneData(JrScene originalScene) {
        SceneGraphComponent copy = this.copy(originalScene.getSceneRoot());
        JrScene scene = new JrScene(copy);
        this.rootNode = scene.getSceneRoot();
        U3DSceneUtility.prepareTubesAndSpheres(this.rootNode);
        SceneGraphComponent skyBox = U3DSceneUtility.getSkyBox(scene);
        if (skyBox != null) {
            this.rootNode.addChild(skyBox);
        }
        this.nodes = U3DSceneUtility.getSceneGraphComponents(scene);
        this.parentMap = U3DSceneUtility.getParentsMap(this.nodes);
        this.nodeNameMap = U3DSceneUtility.getUniqueNames(this.nodes);
        this.viewNodes = U3DSceneUtility.getViewNodes(scene);
        this.cameras = U3DSceneUtility.getCameras(scene);
        this.cameraNameMap = U3DSceneUtility.getUniqueNames(this.cameras);
        this.lightNodes = U3DSceneUtility.getLightNodes(scene);
        this.lights = U3DSceneUtility.getLights(scene);
        this.lightNameMap = U3DSceneUtility.getUniqueNames(this.lights);
        this.geometries = U3DSceneUtility.getGeometries(scene);
        this.preparedGeometryMap = U3DSceneUtility.prepareGeometry(this.geometries);
        this.preparedGeometries = new HashSet<Geometry>(this.preparedGeometryMap.values());
        this.geometryNameMap = U3DSceneUtility.getUniqueNames(this.preparedGeometries);
        this.appearanceMap = U3DSceneUtility.getAppearanceMap(scene);
        this.appearances = new HashSet<EffectiveAppearance>(this.appearanceMap.values());
        this.appearanceNameMap = U3DSceneUtility.getAppearanceNames(this.appearances);
        this.visibilityMap = U3DSceneUtility.getVisibility(scene, this.appearanceMap);
        LinkedList<SceneGraphComponent> keys = new LinkedList<SceneGraphComponent>(this.appearanceMap.keySet());
        for (SceneGraphComponent c : keys) {
            if (c.getGeometry() != null) continue;
            this.appearanceMap.remove(c);
        }
        this.textureMap = U3DSceneUtility.getTextureMap(this.appearances);
        this.textures = new HashSet<U3DTexture>(this.textureMap.values());
        this.sphereMapsMap = U3DSceneUtility.getSphereMapsMap(this.appearances);
        this.textures.addAll(new HashSet<U3DTexture>(this.sphereMapsMap.values()));
        this.textureNameMap = U3DSceneUtility.getTextureNames("Texture", this.textures);
        this.texturePNGData = U3DSceneUtility.preparePNGTextures(this.textures);
    }

    private SceneGraphComponent copy(final SceneGraphComponent node) {
        final SceneGraphPath path = new SceneGraphPath();
        node.accept(new SceneGraphVisitor(){

            public void visit(SceneGraphComponent c) {
                SceneGraphComponent copy = SceneGraphUtility.copy(c);
                if (c != node) {
                    path.getLastComponent().addChild(copy);
                }
                path.push(copy);
                c.childrenAccept(this);
                if (c != node) {
                    path.pop();
                }
            }

            public void visit(SceneGraphNode m) {
                SceneGraphUtility.addChildNode(path.getLastComponent(), m);
            }
        });
        SceneGraphComponent copy = path.getLastComponent();
        return copy;
    }
}

