/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.writer.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import de.jreality.io.JrScene;
import de.jreality.reader.ReaderJRS;
import de.jreality.scene.Camera;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.util.Input;
import de.jreality.util.SceneGraphUtility;
import de.jreality.writer.SceneWriter;
import de.jreality.writer.u3d.U3DSceneUtility;
import de.jreality.writer.u3d.WriterU3D;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class WriterPDF
implements SceneWriter {
    public static final String PDF_NAME_3D = "3D";
    public static final String PDF_NAME_3DD = "3DD";
    public static final String PDF_NAME_3DV = "3DV";
    public static final String PDF_NAME_3DVIEW = "3DView";
    public static final String PDF_NAME_C2W = "C2W";
    public static final String PDF_NAME_IN = "IN";
    public static final String PDF_NAME_MS = "MS";
    public static final String PDF_NAME_U3D = "U3D";
    public static final String PDF_NAME_U3DPATH = "U3DPath";
    public static final String PDF_NAME_XN = "XN";
    private PDF3DPreferences prefs = PDF3DPreferences.Default;
    private Dimension size = new Dimension(800, 600);
    private static final String viewerVRScript = WriterPDF.getJSScript("viewerVRPrefs.js");
    private static final String defaultScript = WriterPDF.getJSScript("defaultPrefs.js");

    public void write(SceneGraphNode c, OutputStream out) throws IOException {
        SceneGraphComponent root = null;
        if (c instanceof SceneGraphComponent) {
            root = (SceneGraphComponent)c;
        } else {
            root = new SceneGraphComponent();
            SceneGraphUtility.addChildNode(root, c);
        }
        JrScene scene = new JrScene(root);
        this.writeScene(scene, out);
    }

    private static float[] toU3DMatrix(double[] M) {
        float[] R = new float[12];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                R[i * 3 + j] = (float)M[j * 4 + i];
            }
        }
        return R;
    }

    public void writeScene(JrScene scene, OutputStream out) throws IOException {
        File u3dTmp = File.createTempFile("jralityPDFExport", "u3d");
        FileOutputStream u3dout = new FileOutputStream(u3dTmp);
        WriterU3D.write(scene, u3dout);
        List<SceneGraphComponent> cameraNodes = U3DSceneUtility.getViewNodes(scene);
        ArrayList<SceneGraphPath> camPaths = new ArrayList<SceneGraphPath>();
        for (SceneGraphComponent c : cameraNodes) {
            camPaths.addAll(SceneGraphUtility.getPathsBetween(scene.getSceneRoot(), c));
        }
        String script = null;
        switch (this.prefs) {
            case Default: 
            case ViewerApp: {
                script = defaultScript;
                break;
            }
            case ViewerVR: {
                script = viewerVRScript;
            }
        }
        if (cameraNodes.size() > 0) {
            SceneGraphComponent cam0 = cameraNodes.get(0);
            script = script.replace("##cam##", cam0.getName() + ".camera");
        }
        Rectangle pageSize = new Rectangle((float)this.size.width, (float)this.size.height);
        Document doc = new Document(pageSize);
        try {
            PdfWriter wr = PdfWriter.getInstance((Document)doc, (OutputStream)out);
            doc.open();
            PdfStream oni = new PdfStream(PdfEncodings.convertToBytes((String)script, null));
            oni.flateCompress();
            PdfIndirectReference initScriptRef = wr.addToBody((PdfObject)oni).getIndirectReference();
            ArrayList<PdfIndirectReference> viewList = new ArrayList<PdfIndirectReference>(camPaths.size());
            for (SceneGraphPath path : camPaths) {
                SceneGraphComponent c = path.getLastComponent();
                Camera cam = c.getCamera();
                float[] T1 = WriterPDF.toU3DMatrix(path.getMatrix(null));
                T1 = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
                PdfDictionary viewDict = new PdfDictionary(new PdfName(PDF_NAME_3DVIEW));
                viewDict.put(new PdfName(PDF_NAME_MS), (PdfObject)new PdfString("M"));
                viewDict.put(new PdfName(PDF_NAME_MS), (PdfObject)new PdfString("M"));
                viewDict.put(new PdfName(PDF_NAME_C2W), (PdfObject)new PdfArray(T1));
                viewDict.put(new PdfName(PDF_NAME_XN), (PdfObject)new PdfString(cam.getName()));
                PdfIndirectReference ref = wr.addToBody((PdfObject)viewDict).getIndirectReference();
                viewList.add(ref);
            }
            PdfStream stream = new PdfStream((InputStream)new FileInputStream(u3dTmp), wr);
            stream.put(new PdfName("OnInstantiate"), (PdfObject)initScriptRef);
            stream.put(PdfName.TYPE, (PdfObject)new PdfName(PDF_NAME_3D));
            stream.put(PdfName.SUBTYPE, (PdfObject)new PdfName(PDF_NAME_U3D));
            stream.flateCompress();
            PdfIndirectReference u3dStreamRef = wr.addToBody((PdfObject)stream).getIndirectReference();
            stream.writeLength();
            PdfDictionary activationDict = new PdfDictionary();
            activationDict.put(PdfName.A, (PdfObject)new PdfName("PO"));
            activationDict.put(new PdfName("DIS"), (PdfObject)PdfName.I);
            PdfAppearance ap = PdfAppearance.createAppearance((PdfWriter)wr, (float)(pageSize.getRight() - pageSize.getLeft()), (float)(pageSize.getTop() - pageSize.getBottom()));
            ap.setBoundingBox(pageSize);
            PdfAnnotation annot = new PdfAnnotation(wr, pageSize);
            annot.put(PdfName.CONTENTS, (PdfObject)new PdfString("3D Model"));
            annot.put(PdfName.SUBTYPE, (PdfObject)new PdfName(PDF_NAME_3D));
            annot.put(PdfName.TYPE, (PdfObject)PdfName.ANNOT);
            annot.put(new PdfName(PDF_NAME_3DD), (PdfObject)u3dStreamRef);
            annot.put(new PdfName("3DI"), (PdfObject)PdfBoolean.PDFFALSE);
            annot.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, (PdfTemplate)ap);
            annot.put(new PdfName("3DA"), (PdfObject)activationDict);
            annot.setPage(1);
            wr.addAnnotation(annot);
            doc.close();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void writeScene(JrScene scene, Writer out) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("PDF is a binary file format");
    }

    public static void write(JrScene scene, OutputStream out) throws IOException {
        WriterU3D writer = new WriterU3D();
        writer.writeScene(scene, out);
    }

    private static String getJSScript(String name) {
        StringBuffer result = new StringBuffer();
        InputStreamReader inReader = new InputStreamReader(WriterPDF.class.getResourceAsStream(name));
        LineNumberReader in = new LineNumberReader(inReader);
        String line = null;
        try {
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public void setPreferences(PDF3DPreferences prefs) {
        this.prefs = prefs;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public static void main(String[] args) {
        ReaderJRS reader = new ReaderJRS();
        SceneGraphComponent root = null;
        try {
            root = reader.read(Input.getInput(WriterPDF.class.getResource("test.jrs")));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        WriterPDF writer = new WriterPDF();
        try {
            FileOutputStream out = new FileOutputStream("test.pdf");
            writer.write(root, out);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PDF3DPreferences {
        Default,
        ViewerVR,
        ViewerApp;

    }
}

