/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.writer;

import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.geometry.Primitives;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.IntArray;
import de.jreality.util.SceneGraphUtility;
import java.io.OutputStream;
import java.io.PrintWriter;

public class WriterSTL {
    static final String t1 = "   ";
    static final String t2 = "      ";

    public static void write(IndexedFaceSet ifs, OutputStream out) {
        WriterSTL.writeGeometry(ifs, new PrintWriter(out));
    }

    static void write(PrintWriter out, double[] array, String seperator) {
        if (array == null || array.length == 0) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (i > 0) {
                out.print(seperator);
            }
            String formatted = String.format("%6.4g", array[i]);
            out.print(formatted);
        }
    }

    public static void writeSolid(IndexedFaceSet ifs, OutputStream out) {
        PrintWriter pw = new PrintWriter(out);
        WriterSTL.beginFile(pw);
        WriterSTL.writeGeometry(ifs, pw);
        WriterSTL.endFile(pw);
    }

    static void writeGeometry(Geometry g, PrintWriter out) {
        if (g == null || !(g instanceof IndexedFaceSet)) {
            return;
        }
        IndexedFaceSet ifs = (IndexedFaceSet)g;
        double[][] points = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray().toDoubleArrayArray(null);
        double[][] normals = ifs.getFaceAttributes(Attribute.NORMALS) == null ? IndexedFaceSetUtility.calculateFaceNormals(ifs) : ifs.getFaceAttributes(Attribute.NORMALS).toDoubleArrayArray().toDoubleArrayArray(null);
        DataList indices = ifs.getFaceAttributes(Attribute.INDICES);
        for (int i = 0; i < ifs.getNumFaces(); ++i) {
            IntArray faceIndices = indices.item(i).toIntArray();
            for (int j = 0; j < faceIndices.size() - 2; ++j) {
                out.print("facet normal ");
                WriterSTL.write(out, normals[i], " ");
                out.println();
                out.println("   outer loop");
                int[] inds = new int[]{0, j + 1, j + 2};
                for (int k = 0; k < 3; ++k) {
                    out.print("      vertex ");
                    WriterSTL.write(out, points[faceIndices.getValueAt(inds[k])], " ");
                    out.println();
                }
                out.println("   endloop");
                out.println("   endfacet");
            }
        }
    }

    public static void write(SceneGraphComponent sgc, OutputStream out) {
        WriterSTL.write(sgc, new PrintWriter(out));
    }

    public static void write(SceneGraphComponent sgc, PrintWriter out) {
        SceneGraphComponent flat = SceneGraphUtility.flatten(sgc, true);
        WriterSTL.beginFile(out);
        WriterSTL.writeGeometry(flat.getGeometry(), out);
        int noc = flat.getChildComponentCount();
        for (int i = 0; i < noc; ++i) {
            SceneGraphComponent child = flat.getChildComponent(i);
            WriterSTL.writeGeometry(child.getGeometry(), out);
        }
        WriterSTL.endFile(out);
    }

    private static void endFile(PrintWriter out) {
        out.println("endsolid");
        out.flush();
    }

    private static void beginFile(PrintWriter out) {
        out.println("solid");
    }

    public static void main(String[] arg) {
        SceneGraphComponent sgc = new SceneGraphComponent();
        sgc.setGeometry(Primitives.coloredCube());
        WriterSTL.write(sgc, (OutputStream)System.out);
    }
}

