/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.writer;

import de.jreality.geometry.GeometryUtility;
import de.jreality.math.Pn;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.IntArray;
import de.jreality.util.LoggingSystem;
import de.jreality.util.SceneGraphUtility;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.logging.Level;

public class WriterOBJ {
    public static int write(IndexedFaceSet ifs, OutputStream out, int startVertex) {
        return WriterOBJ.write(ifs, null, new PrintWriter(out), startVertex);
    }

    public static int write(IndexedFaceSet ifs, OutputStream out) {
        return WriterOBJ.write(ifs, null, new PrintWriter(out), 0);
    }

    static void write(PrintWriter out, double[] array, String seperator) {
        if (array == null || array.length == 0) {
            return;
        }
        out.print(array[0]);
        for (int i = 1; i < array.length; ++i) {
            out.print(seperator);
            out.print(array[i]);
        }
    }

    static void write(PrintWriter out, double[][] array, String prefix) {
        if (array == null) {
            return;
        }
        String seperator = " ";
        for (int i = 0; i < array.length; ++i) {
            out.print(prefix);
            out.print(seperator);
            WriterOBJ.write(out, array[i], seperator);
            out.println();
        }
    }

    static int write(Geometry geom, String groupName, PrintWriter out, int startVertex) {
        if (geom == null) {
            return 0;
        }
        if (geom instanceof IndexedFaceSet) {
            return WriterOBJ.write((IndexedFaceSet)geom, groupName, out, startVertex);
        }
        LoggingSystem.getLogger(GeometryUtility.class).log(Level.WARNING, "ignoring scene graph component " + groupName);
        return 0;
    }

    public static void write(SceneGraphComponent sgc, OutputStream out) {
        WriterOBJ.write(sgc, new PrintWriter(out));
    }

    public static void write(SceneGraphComponent sgc, PrintWriter out) {
        SceneGraphComponent flat = SceneGraphUtility.flatten(sgc);
        int vertex = WriterOBJ.write(flat.getGeometry(), flat.getName(), out, 0);
        int noc = flat.getChildComponentCount();
        for (int i = 0; i < noc; ++i) {
            SceneGraphComponent child = flat.getChildComponent(i);
            vertex += WriterOBJ.write(child.getGeometry(), child.getName(), out, vertex);
        }
    }

    static void writeFaceIndex(PrintWriter out, int index, boolean hasTexture, boolean hasNormals) {
        out.print(index + 1);
        if (!hasTexture && !hasNormals) {
            return;
        }
        out.print("/");
        if (hasTexture) {
            out.print(index + 1);
        }
        if (!hasNormals) {
            return;
        }
        out.print("/");
        out.print(index + 1);
    }

    static int write(IndexedFaceSet ifs, String groupName, PrintWriter out, int startVertex) {
        double[][] points;
        if (groupName != null) {
            out.println();
            out.println("g " + groupName);
            out.println();
        }
        if ((points = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray().toDoubleArrayArray(null))[0].length == 4) {
            double[][] points3 = new double[points.length][3];
            Pn.dehomogenize(points3, points);
            points = points3;
        }
        double[][] normals = ifs.getVertexAttributes(Attribute.NORMALS) != null ? ifs.getVertexAttributes(Attribute.NORMALS).toDoubleArrayArray().toDoubleArrayArray(null) : (double[][])null;
        double[][] texture = ifs.getVertexAttributes(Attribute.TEXTURE_COORDINATES) != null ? ifs.getVertexAttributes(Attribute.TEXTURE_COORDINATES).toDoubleArrayArray().toDoubleArrayArray(null) : (double[][])null;
        WriterOBJ.write(out, points, "v");
        WriterOBJ.write(out, texture, "vt");
        WriterOBJ.write(out, normals, "vn");
        out.println();
        DataList indices = ifs.getFaceAttributes(Attribute.INDICES);
        for (int i = 0; i < ifs.getNumFaces(); ++i) {
            out.print("f  ");
            IntArray faceIndices = indices.item(i).toIntArray();
            WriterOBJ.writeFaceIndex(out, startVertex + faceIndices.getValueAt(0), texture != null, normals != null);
            for (int j = 1; j < faceIndices.size(); ++j) {
                out.print(" ");
                WriterOBJ.writeFaceIndex(out, startVertex + faceIndices.getValueAt(j), texture != null, normals != null);
            }
            out.println();
        }
        out.flush();
        return ifs.getNumPoints();
    }
}

