/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphVisitor;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathCollector
extends SceneGraphVisitor {
    SceneGraphComponent root;
    SceneGraphPath currentPath = new SceneGraphPath();
    LinkedList<SceneGraphPath> collectedPaths = new LinkedList();
    Matcher matcher;

    public PathCollector(Matcher matcher, SceneGraphComponent root) {
        this.matcher = matcher;
        this.root = root;
    }

    public List<SceneGraphPath> visit() {
        this.visit(this.root);
        return this.collectedPaths;
    }

    @Override
    public void visit(SceneGraphNode m) {
        this.currentPath.push(m);
        if (this.currentPath.getLength() > 0 && this.matcher.matches(this.currentPath)) {
            this.collectedPaths.add((SceneGraphPath)this.currentPath.clone());
        }
        this.currentPath.pop();
    }

    @Override
    public void visit(SceneGraphComponent c) {
        super.visit(c);
        this.currentPath.push(c);
        c.childrenAccept(this);
        this.currentPath.pop();
    }

    public static interface Matcher {
        public boolean matches(SceneGraphPath var1);
    }
}

