/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import de.jreality.scene.Viewer;
import de.jreality.shader.ImageData;
import de.jreality.util.LoggingSystem;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.beans.Statement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class ImageUtility {
    private ImageUtility() {
    }

    public static void writeBufferedImage(File file, BufferedImage img) {
        String suffix = ImageUtility.getFileSuffix(file);
        if ("tiff".equals(suffix) || "tif".equals(suffix)) {
            try {
                Class<?> encParamClass = Class.forName("com.sun.media.jai.codec.TIFFEncodeParam");
                Object encodeParam = encParamClass.newInstance();
                Object compField = encParamClass.getField("COMPRESSION_DEFLATE").get(null);
                new Statement(encodeParam, "setCompression", new Object[]{compField}).execute();
                new Statement(encodeParam, "setDeflateLevel", new Object[]{9}).execute();
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(img);
                pb.add(new FileOutputStream(file));
                pb.add("tiff");
                pb.add(encodeParam);
                new Statement(Class.forName("javax.media.jai.JAI"), "create", new Object[]{"encode", pb}).execute();
            }
            catch (Throwable e) {
                throw new RuntimeException("need JAI for tiff writing", e);
            }
        }
        try {
            if (suffix != "" && !ImageIO.write((RenderedImage)img, ImageUtility.getFileSuffix(file), file)) {
                LoggingSystem.getLogger(ImageUtility.class).log(Level.WARNING, "Error writing file using ImageIO (unsupported file format?)");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("image writing failed", e);
        }
    }

    public static BufferedImage resizeToPowerOfTwo(BufferedImage input) {
        int h2;
        int w2;
        int w = input.getWidth();
        int h = input.getHeight();
        for (w2 = 1; w2 < w; w2 *= 2) {
        }
        for (h2 = 1; h2 < h; h2 *= 2) {
        }
        System.err.println("input type is " + input.getType());
        BufferedImage output = new BufferedImage(w2, h2, 2);
        Graphics2D g = (Graphics2D)output.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        output.getGraphics().drawImage(input, 0, 0, w2, h2, null);
        return output;
    }

    private static String getFileSuffix(File file) {
        int lastDot = file.getName().lastIndexOf(46);
        if (lastDot == -1) {
            return "png";
        }
        return file.getName().substring(lastDot + 1);
    }

    public static BufferedImage rearrangeChannels(BufferedImage img) {
        if (!(img.getRaster().getDataBuffer() instanceof DataBufferByte)) {
            return img;
        }
        int imageHeight = img.getHeight();
        int imageWidth = img.getWidth();
        BufferedImage bi = new BufferedImage(imageWidth, imageHeight, 2);
        WritableRaster raster = bi.getRaster();
        byte[] byteArray = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        int[] dst = new int[4];
        int ptr = 0;
        for (int y = 0; y < imageHeight; ++y) {
            int x = 0;
            while (x < imageWidth) {
                dst[3] = byteArray[ptr + 3];
                if (dst[3] < 0) {
                    dst[3] = dst[3] + 256;
                }
                double d = (double)dst[3] / 255.0;
                for (int j = 0; j < 3; ++j) {
                    dst[j] = byteArray[ptr + j];
                    if (dst[j] >= 0) continue;
                    int n = j;
                    dst[n] = dst[n] + 256;
                }
                raster.setPixel(x, y, dst);
                ++x;
                ptr += 4;
            }
        }
        return bi;
    }

    public static BufferedImage getValidBufferedImage(ImageData data) {
        byte[] byteArray = data.getByteArray();
        int dataHeight = data.getHeight();
        int dataWidth = data.getWidth();
        BufferedImage img = new BufferedImage(dataWidth, dataHeight, 2);
        WritableRaster raster = img.getRaster();
        int[] pix = new int[4];
        int ptr = 0;
        for (int y = 0; y < dataHeight; ++y) {
            int x = 0;
            while (x < dataWidth) {
                pix[0] = byteArray[ptr];
                pix[1] = byteArray[ptr + 1];
                pix[2] = byteArray[ptr + 2];
                pix[3] = byteArray[ptr + 3];
                raster.setPixel(x, y, pix);
                ++x;
                ptr += 4;
            }
        }
        return img;
    }

    public static BufferedImage captureScreenshot(Viewer v) {
        if (v.getViewingComponent() instanceof Component) {
            Component viewingComponent = (Component)v.getViewingComponent();
            if (!viewingComponent.isShowing()) {
                return null;
            }
            Point loc = viewingComponent.getLocationOnScreen();
            try {
                Robot r = new Robot();
                return r.createScreenCapture(new Rectangle(loc, viewingComponent.getSize()));
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

