/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.util;

import de.jreality.reader.ReaderBSH;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Viewer;
import de.jreality.util.ConfigurationAttributes;
import de.jreality.util.Input;
import de.jreality.util.LoggingSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import javax.swing.JMenuBar;

public class BSHServer {
    private ReaderBSH readerBSH;
    private int port;
    private volatile boolean running;
    private final Object finishMutex = new Object();
    private Runnable server = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ServerSocket s = null;
            try {
                s = new ServerSocket(BSHServer.this.port);
                s.setSoTimeout(20);
            }
            catch (IOException ioe) {
                LoggingSystem.getLogger(BSHServer.this).log(Level.SEVERE, "socket create error", ioe);
                return;
            }
            Socket sock = null;
            while (BSHServer.this.running) {
                try {
                    try {
                        sock = s.accept();
                    }
                    catch (SocketTimeoutException st) {
                        continue;
                    }
                    InputStream is = sock.getInputStream();
                    PrintStream ps = new PrintStream(sock.getOutputStream());
                    ReaderBSH readerBSH = BSHServer.this.readerBSH;
                    synchronized (readerBSH) {
                        try {
                            BSHServer.this.readerBSH.appendInput(Input.getInput("socket input stream", is));
                        }
                        catch (Exception e) {
                            e.printStackTrace(ps);
                        }
                        finally {
                            ps.close();
                            sock.close();
                        }
                    }
                }
                catch (IOException ioe) {
                    LoggingSystem.getLogger(BSHServer.this).log(Level.SEVERE, "socket IO error", ioe);
                }
            }
            try {
                if (sock != null) {
                    sock.close();
                }
                if (s != null) {
                    s.close();
                }
            }
            catch (IOException e) {
                LoggingSystem.getLogger(BSHServer.this).log(Level.INFO, "diconnect failed", e);
            }
            Object object = BSHServer.this.finishMutex;
            synchronized (object) {
                BSHServer.this.finishMutex.notifyAll();
            }
        }
    };

    public BSHServer(int port) throws Exception {
        this.readerBSH = new ReaderBSH();
        this.port = port;
        this.start();
    }

    private void start() {
        if (this.running) {
            throw new IllegalStateException("already started");
        }
        this.running = true;
        new Thread(this.server).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Object object = this.finishMutex;
        synchronized (object) {
            this.running = false;
            try {
                this.finishMutex.wait();
            }
            catch (InterruptedException e) {
                throw new Error();
            }
        }
    }

    public void setConfiguration(ConfigurationAttributes config) {
    }

    public SceneGraphComponent makeWorld() {
        return this.readerBSH.getComponent();
    }

    public int getMetric() {
        return 0;
    }

    public void customize(JMenuBar menuBar, Viewer viewer) {
    }
}

