/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.view;

import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Viewer;
import de.jreality.shader.ShaderUtility;
import de.jreality.ui.viewerapp.ViewerApp;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import java.awt.Color;
import java.awt.event.ActionEvent;

public class SwitchBackgroundColor
extends AbstractJrAction {
    public static Color[] defaultColor = ViewerApp.defaultBackgroundColor;
    private Color[] colors;
    private SceneGraphComponent sceneRoot;

    public SwitchBackgroundColor(String name, SceneGraphComponent sceneRoot, Color ... colors) {
        super(name);
        if (colors == null || colors.length != 1 && colors.length != 4) {
            throw new IllegalArgumentException("illegal length of colors[]");
        }
        if (sceneRoot == null) {
            throw new IllegalArgumentException("no scene root");
        }
        this.colors = colors;
        this.sceneRoot = sceneRoot;
        this.setShortDescription("Set the viewer's background color");
    }

    public SwitchBackgroundColor(String name, ViewerApp viewerApp, Color ... colors) {
        this(name, viewerApp.getViewerSwitch().getSceneRoot(), colors);
    }

    public SwitchBackgroundColor(String name, Viewer viewer, Color ... colors) {
        this(name, viewer.getSceneRoot(), colors);
    }

    public void actionPerformed(ActionEvent e) {
        Appearance app = this.sceneRoot.getAppearance();
        if (app == null) {
            app = new Appearance("root appearance");
            ShaderUtility.createRootAppearance(app);
            this.sceneRoot.setAppearance(app);
        }
        if (this.colors.length == 4) {
            boolean equal = true;
            for (int i = 1; i < this.colors.length; ++i) {
                if (this.colors[i] == this.colors[0]) continue;
                equal = false;
            }
            if (equal) {
                this.colors = new Color[]{this.colors[0]};
            }
        }
        app.setAttribute("backgroundColor", this.colors.length == 1 ? this.colors[0] : Appearance.INHERITED);
        app.setAttribute("backgroundColors", this.colors.length == 4 ? this.colors : Appearance.INHERITED);
    }
}

