/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.view;

import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.shader.ImageData;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.TextureUtility;
import de.jreality.ui.viewerapp.FileFilter;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import de.jreality.util.Input;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;

public class LoadSkyBox
extends AbstractJrAction {
    private SceneGraphComponent sceneRoot;

    public LoadSkyBox(String name, SceneGraphComponent sceneRoot, Component frame) {
        super(name, frame);
        this.sceneRoot = sceneRoot;
        this.setShortDescription("Load skybox");
    }

    public void actionPerformed(ActionEvent e) {
        ImageData[] imgs;
        File file = FileLoaderDialog.loadFile(this.parentComp, false, new FileFilter("ZIP archives", "zip"));
        if (file == null) {
            return;
        }
        try {
            imgs = TextureUtility.createCubeMapData(Input.getInput(file));
        }
        catch (Exception ex) {
            System.err.println("Couldn't create cube map data from zip-file");
            ex.printStackTrace();
            return;
        }
        Appearance app = this.sceneRoot.getAppearance();
        if (app == null) {
            app = new Appearance("root appearance");
            ShaderUtility.createRootAppearance(app);
            this.sceneRoot.setAppearance(app);
        }
        TextureUtility.createSkyBox(app, imgs);
    }
}

