/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.file;

import de.jreality.io.JrScene;
import de.jreality.reader.ReaderJRS;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.ViewerApp;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import de.jreality.util.Input;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;

public class LoadScene
extends AbstractJrAction {
    private ViewerApp viewerApp;

    public LoadScene(String name, ViewerApp v) {
        super(name);
        this.parentComp = v.getFrame();
        this.viewerApp = v;
        this.setShortDescription("Open saved scene");
        this.setShortCut(79, 0, true);
    }

    public void actionPerformed(ActionEvent e) {
        File f = FileLoaderDialog.loadFile(this.parentComp, "jrs", "jReality scene files");
        if (f == null) {
            return;
        }
        JrScene scene = null;
        try {
            ReaderJRS r = new ReaderJRS();
            r.setInput(new Input(f));
            scene = r.getScene();
            if (scene == null) {
                throw new NullPointerException("couldn't read scene");
            }
            ViewerApp v = new ViewerApp(scene);
            v.setAttachNavigator(this.viewerApp.isAttachNavigator());
            v.setExternalNavigator(this.viewerApp.isExternalNavigator());
            v.setAttachBeanShell(this.viewerApp.isAttachBeanShell());
            v.setExternalBeanShell(this.viewerApp.isExternalBeanShell());
            this.viewerApp.dispose();
            v.update();
            v.display();
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this.parentComp, "Load failed: " + exc.getMessage());
        }
    }
}

