/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.file;

import de.jreality.geometry.GeometryMergeFactory;
import de.jreality.geometry.RemoveDuplicateInfo;
import de.jreality.reader.Readers;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Viewer;
import de.jreality.scene.data.Attribute;
import de.jreality.toolsystem.ToolSystem;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import de.jreality.util.CameraUtility;
import de.jreality.util.PickUtility;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LoadFile
extends AbstractJrAction {
    private SceneGraphComponent parentNode;
    private Viewer viewer;
    private JComponent options;
    private JCheckBox mergeFaceSets;
    private JCheckBox simplifyTree;
    private JCheckBox mergeFaceSetsWithNormals;
    private JCheckBox removeDuplicateVertices;
    private JCheckBox removeDuplicateVerticesWithNormals;
    private JCheckBox removeDuplicateVerticesWithColors;
    private JLabel remarkNormals;
    private JCheckBox callEncompass;

    public LoadFile(String name, SceneGraphComponent parentNode, Viewer viewer, Component parentComp) {
        super(name, parentComp);
        this.parentNode = parentNode;
        this.viewer = viewer;
        this.setShortDescription("Load one or more files");
        this.setShortCut(79, 1, true);
    }

    public LoadFile(String name, SceneGraphComponent parentNode, Viewer viewer) {
        this(name, parentNode, viewer, null);
    }

    public LoadFile(String name, SceneGraphComponent parentNode, Component parentComp) {
        this(name, parentNode, null, parentComp);
    }

    public LoadFile(String name, SceneGraphComponent parentNode) {
        this(name, parentNode, null, null);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.options == null) {
            this.options = this.createAccessory();
        }
        this.mergeFaceSets.setSelected(false);
        this.simplifyTree.setSelected(false);
        this.mergeFaceSetsWithNormals.setSelected(false);
        this.mergeFaceSetsWithNormals.setEnabled(false);
        this.remarkNormals.setEnabled(false);
        this.removeDuplicateVertices.setSelected(false);
        this.removeDuplicateVertices.setEnabled(false);
        this.removeDuplicateVerticesWithNormals.setSelected(false);
        this.removeDuplicateVerticesWithNormals.setEnabled(false);
        this.removeDuplicateVerticesWithColors.setSelected(false);
        this.removeDuplicateVerticesWithColors.setEnabled(false);
        File[] files = FileLoaderDialog.loadFiles(this.parentComp, this.options);
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            try {
                ToolSystem ts;
                SceneGraphComponent sgc = Readers.read(files[i]);
                if (sgc == null) {
                    throw new IOException("Could not read " + files[i].getPath());
                }
                GeometryMergeFactory mFac = new GeometryMergeFactory();
                SceneGraphComponent comp = new SceneGraphComponent();
                if (this.simplifyTree.isSelected()) {
                    RemoveDuplicateInfo.simplifySceneTree(sgc);
                }
                if (this.mergeFaceSets.isSelected()) {
                    if (!this.mergeFaceSetsWithNormals.isSelected()) {
                        mFac.setGenerateVertexNormals(false);
                    }
                    IndexedFaceSet geo = mFac.mergeIndexedFaceSets(sgc);
                    if (this.removeDuplicateVertices.isSelected()) {
                        geo = this.removeDuplicateVerticesWithNormals.isSelected() && this.removeDuplicateVerticesWithColors.isSelected() ? (IndexedFaceSet)RemoveDuplicateInfo.removeDuplicateVertices((PointSet)geo, Attribute.NORMALS, Attribute.COLORS) : (this.removeDuplicateVerticesWithNormals.isSelected() ? (IndexedFaceSet)RemoveDuplicateInfo.removeDuplicateVertices((PointSet)geo, Attribute.NORMALS) : (this.removeDuplicateVerticesWithColors.isSelected() ? (IndexedFaceSet)RemoveDuplicateInfo.removeDuplicateVertices((PointSet)geo, Attribute.COLORS) : (IndexedFaceSet)RemoveDuplicateInfo.removeDuplicateVertices((PointSet)geo, new Attribute[0])));
                    }
                    comp.setGeometry(geo);
                    sgc = comp;
                }
                System.out.println("READ finished.");
                this.parentNode.addChild(sgc);
                PickUtility.assignFaceAABBTrees(sgc);
                if (!this.callEncompass.isSelected() || this.viewer == null || (ts = ToolSystem.getToolSystemForViewer(this.viewer)) == null) continue;
                CameraUtility.encompass(ts.getAvatarPath(), ts.getEmptyPickPath(), this.viewer.getCameraPath(), 1.75, 0);
                continue;
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.parentComp, "Failed to load file: " + ioe.getMessage(), "Error", 0);
            }
        }
    }

    private JComponent createAccessory() {
        Box box = Box.createVerticalBox();
        TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Options");
        box.setBorder(title);
        this.mergeFaceSets = new JCheckBox("merge geometries");
        this.simplifyTree = new JCheckBox("simplify tree");
        this.mergeFaceSetsWithNormals = new JCheckBox("garantee vertex normals");
        this.remarkNormals = new JLabel("(created before points remove!)");
        this.removeDuplicateVertices = new JCheckBox("remove duplicate vertices");
        this.removeDuplicateVerticesWithNormals = new JCheckBox("respect vertex normals");
        this.removeDuplicateVerticesWithColors = new JCheckBox("respect vertex colors");
        this.simplifyTree.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                if (LoadFile.this.simplifyTree.isSelected()) {
                    LoadFile.this.mergeFaceSets.setSelected(false);
                }
            }
        });
        this.mergeFaceSets.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                if (LoadFile.this.mergeFaceSets.isSelected()) {
                    LoadFile.this.simplifyTree.setSelected(false);
                }
                boolean editable = LoadFile.this.mergeFaceSets.isSelected();
                LoadFile.this.mergeFaceSetsWithNormals.setEnabled(editable);
                LoadFile.this.remarkNormals.setEnabled(editable);
                LoadFile.this.removeDuplicateVertices.setEnabled(editable);
                LoadFile.this.removeDuplicateVerticesWithNormals.setEnabled(editable && LoadFile.this.removeDuplicateVertices.isSelected());
                LoadFile.this.removeDuplicateVerticesWithColors.setEnabled(editable && LoadFile.this.removeDuplicateVertices.isSelected());
            }
        });
        this.removeDuplicateVertices.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                LoadFile.this.removeDuplicateVerticesWithNormals.setEnabled(LoadFile.this.removeDuplicateVertices.isSelected());
                LoadFile.this.removeDuplicateVerticesWithColors.setEnabled(LoadFile.this.removeDuplicateVertices.isSelected());
            }
        });
        this.callEncompass = new JCheckBox("encompass scene");
        this.callEncompass.setSelected(true);
        box.add(this.simplifyTree);
        box.add(this.mergeFaceSets);
        Box tmp = Box.createHorizontalBox();
        tmp.setAlignmentX(0.0f);
        tmp.add(new JLabel("  "));
        tmp.add(this.mergeFaceSetsWithNormals);
        box.add(tmp);
        tmp = Box.createHorizontalBox();
        tmp.setAlignmentX(0.0f);
        tmp.add(new JLabel("  "));
        tmp.add(this.remarkNormals);
        box.add(tmp);
        tmp = Box.createHorizontalBox();
        tmp.setAlignmentX(0.0f);
        tmp.add(new JLabel("  "));
        tmp.add(this.removeDuplicateVertices);
        box.add(tmp);
        tmp = Box.createHorizontalBox();
        tmp.setAlignmentX(0.0f);
        tmp.add(new JLabel("    "));
        tmp.add(this.removeDuplicateVerticesWithNormals);
        box.add(tmp);
        tmp = Box.createHorizontalBox();
        tmp.setAlignmentX(0.0f);
        tmp.add(new JLabel("    "));
        tmp.add(this.removeDuplicateVerticesWithColors);
        box.add(tmp);
        box.add(Box.createVerticalStrut(10));
        box.add(this.callEncompass);
        box.validate();
        return box;
    }
}

