/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.file;

import de.jreality.scene.Viewer;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.actions.AbstractJrAction;
import de.jreality.writer.WriterVRML;
import de.jreality.writer.WriterVRML2;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class ExportVRML
extends AbstractJrAction {
    private Viewer viewer;
    private boolean writeTextureFiles = false;
    private boolean writeVrml2 = false;
    private boolean useDefs = true;
    private boolean evalTexMatrix = true;
    private boolean writeTexIndis = true;
    private boolean flipTexture = true;
    private boolean drawTubes = true;
    private boolean drawSpheres = true;
    private boolean moveLightsToSceneRoot = true;
    private JComponent options;
    JCheckBox textureCB;
    JCheckBox useDefsCB;
    JCheckBox vrml2CB;
    JCheckBox tubesCB;
    JCheckBox spheresCB;
    JCheckBox lightCB;
    JCheckBox evalTexMatrixCB;
    JCheckBox writeTexIndisCB;
    JCheckBox flipTextureCB;

    public ExportVRML(String name, Viewer viewer, Component parentComp) {
        super(name, parentComp);
        if (viewer == null) {
            throw new IllegalArgumentException("Viewer is null!");
        }
        this.viewer = viewer;
        this.setShortDescription("Export the current scene as VRML file");
    }

    public void actionPerformed(ActionEvent e) {
        File file;
        if (this.options == null) {
            this.options = this.createAccessory();
        }
        if ((file = FileLoaderDialog.selectTargetFile(this.parentComp, this.options, "wrl", "VRML Files")) == null) {
            return;
        }
        if (this.options == null) {
            this.options = this.createAccessory();
        }
        try {
            if (this.writeVrml2) {
                WriterVRML2 writer = new WriterVRML2(new FileOutputStream(file));
                writer.setWritePath(file.getParent() + "/");
                writer.setWriteTextureFiles(this.writeTextureFiles);
                writer.setDrawSpheres(this.drawSpheres);
                writer.setDrawTubes(this.drawTubes);
                writer.setEvaluateTextureMatrix(this.evalTexMatrix);
                writer.setFlipTextureUpsideDown(this.flipTexture);
                writer.setWriteTextureCoordIndices(this.writeTexIndis);
                writer.setMoveLightsToSceneRoot(this.moveLightsToSceneRoot);
                writer.setUseDefs(this.useDefs);
                writer.write(this.viewer.getSceneRoot());
            } else {
                WriterVRML writer = new WriterVRML(new FileOutputStream(file));
                writer.setWritePath(file.getParent() + "/");
                writer.setWriteTextureFiles(this.writeTextureFiles);
                writer.setDrawSpheres(this.drawSpheres);
                writer.setDrawTubes(this.drawTubes);
                writer.setMoveLightsToSceneRoot(this.moveLightsToSceneRoot);
                writer.setUseDefs(this.useDefs);
                writer.write(this.viewer.getSceneRoot());
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private JComponent createAccessory() {
        Box accessory = Box.createVerticalBox();
        accessory.add(Box.createVerticalGlue());
        this.textureCB = new JCheckBox(new AbstractAction("write texture files"){

            public void actionPerformed(ActionEvent e) {
                ExportVRML.this.writeTextureFiles = ExportVRML.this.textureCB.isSelected();
            }
        });
        this.useDefsCB = new JCheckBox(new AbstractAction("useDefs"){

            public void actionPerformed(ActionEvent e) {
                ExportVRML.this.useDefs = ExportVRML.this.useDefsCB.isSelected();
            }
        });
        this.evalTexMatrixCB = new JCheckBox(new AbstractAction("evaluate texture matrices -> only texturecoords. (problems with 'useDefs' ?)[vrml2]"){

            public void actionPerformed(ActionEvent e) {
                ExportVRML.this.evalTexMatrix = ExportVRML.this.evalTexMatrixCB.isSelected();
            }
        });
        this.writeTexIndisCB = new JCheckBox(new AbstractAction("write texture indices (only for compatibility)[vrml2]"){

            public void actionPerformed(ActionEvent e) {
                ExportVRML.this.writeTexIndis = ExportVRML.this.writeTexIndisCB.isSelected();
            }
        });
        this.flipTextureCB = new JCheckBox(new AbstractAction("texture upside down [vrml2]"){

            public void actionPerformed(ActionEvent e) {
                ExportVRML.this.flipTexture = ExportVRML.this.flipTextureCB.isSelected();
            }
        });
        this.vrml2CB = new JCheckBox(new AbstractAction("vrml2 instead of 1"){

            public void actionPerformed(ActionEvent e) {
                ExportVRML.this.writeVrml2 = ExportVRML.this.vrml2CB.isSelected();
            }
        });
        this.tubesCB = new JCheckBox(new AbstractAction("draw tube-lines as cylinder [vrml2]"){

            public void actionPerformed(ActionEvent e) {
                ExportVRML.this.drawTubes = ExportVRML.this.tubesCB.isSelected();
            }
        });
        this.spheresCB = new JCheckBox(new AbstractAction("draw sphere-vertices as spheres [vrml2]"){

            public void actionPerformed(ActionEvent e) {
                ExportVRML.this.drawSpheres = ExportVRML.this.spheresCB.isSelected();
            }
        });
        this.lightCB = new JCheckBox(new AbstractAction("move lights to root (make global lights)"){

            public void actionPerformed(ActionEvent e) {
                ExportVRML.this.moveLightsToSceneRoot = ExportVRML.this.lightCB.isSelected();
            }
        });
        accessory.add(this.vrml2CB);
        accessory.add(this.textureCB);
        accessory.add(this.useDefsCB);
        accessory.add(this.evalTexMatrixCB);
        accessory.add(this.writeTexIndisCB);
        accessory.add(this.flipTextureCB);
        accessory.add(this.tubesCB);
        accessory.add(this.spheresCB);
        accessory.add(this.lightCB);
        this.vrml2CB.setSelected(this.writeVrml2);
        this.textureCB.setSelected(this.writeTextureFiles);
        this.useDefsCB.setSelected(this.useDefs);
        this.evalTexMatrixCB.setSelected(this.evalTexMatrix);
        this.writeTexIndisCB.setSelected(this.writeTexIndis);
        this.flipTextureCB.setSelected(this.flipTexture);
        this.tubesCB.setSelected(this.drawTubes);
        this.spheresCB.setSelected(this.drawSpheres);
        this.lightCB.setSelected(this.moveLightsToSceneRoot);
        return accessory;
    }
}

