/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp.actions.camera;

import de.jreality.scene.Camera;
import de.jreality.scene.Viewer;
import de.jreality.ui.viewerapp.actions.camera.AbstractCameraAction;
import de.jreality.util.CameraUtility;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class ShiftFocus
extends AbstractCameraAction {
    public ShiftFocus(String name, Viewer v, boolean decrease) {
        super(name, v);
        this.setStep(1.0);
        if (decrease) {
            this.setStep(-this.getStep());
            this.setShortDescription("Decrease the focus of the camera");
            this.setAcceleratorKey(KeyStroke.getKeyStroke(114, 1));
        } else {
            this.setShortDescription("Increase the focus of the camera");
            this.setAcceleratorKey(KeyStroke.getKeyStroke(115, 1));
        }
    }

    public void actionPerformed(ActionEvent e) {
        Camera camera = CameraUtility.getCamera(this.viewer);
        camera.setFocus(camera.getFocus() + this.getStep());
        this.viewer.render();
    }
}

