/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp;

import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import de.jreality.toolsystem.ToolSystem;
import de.jreality.util.LoggingSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.Statement;
import javax.swing.JPanel;

public class ViewerSwitch
implements Viewer {
    private Viewer[] viewers;
    private String[] viewerNames;
    private Viewer currentViewer;
    private EventDispatcher eventDispatcher = new EventDispatcher();
    private JPanel component = new JPanel(new BorderLayout());

    private static String[] createViewerNames(Viewer[] viewers) {
        String[] viewerNames = new String[viewers.length];
        for (int i = 0; i < viewerNames.length; ++i) {
            viewerNames[i] = "[" + i + "] " + viewers[i].getClass().getName();
        }
        return viewerNames;
    }

    public ViewerSwitch(Viewer[] viewers) {
        this(viewers, ViewerSwitch.createViewerNames(viewers));
    }

    public ViewerSwitch(Viewer[] viewers, String[] names) {
        this.viewers = viewers;
        this.viewerNames = names;
        this.currentViewer = viewers[0];
        if (this.currentViewer.hasViewingComponent() && this.currentViewer.getViewingComponent() instanceof Component) {
            this.registerComponent((Component)this.currentViewer.getViewingComponent());
        }
    }

    public Viewer getCurrentViewer() {
        return this.currentViewer;
    }

    private void registerComponent(Component c) {
        c.addKeyListener(this.eventDispatcher);
        c.addMouseListener(this.eventDispatcher);
        c.addMouseMotionListener(this.eventDispatcher);
        c.addMouseWheelListener(this.eventDispatcher);
        this.component.add("Center", c);
        this.component.revalidate();
    }

    private void unregisterComponent(Component c) {
        c.removeKeyListener(this.eventDispatcher);
        c.removeMouseListener(this.eventDispatcher);
        c.removeMouseMotionListener(this.eventDispatcher);
        c.removeMouseWheelListener(this.eventDispatcher);
        this.component.removeAll();
    }

    public void selectViewer(int i) {
        if (this.viewers[i] == this.currentViewer) {
            return;
        }
        Viewer newViewer = this.viewers[i];
        newViewer.setSceneRoot(this.currentViewer.getSceneRoot());
        newViewer.setCameraPath(this.currentViewer.getCameraPath());
        try {
            newViewer.setAuxiliaryRoot(this.currentViewer.getAuxiliaryRoot());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.currentViewer.hasViewingComponent() && this.currentViewer.getViewingComponent() instanceof Component) {
            this.unregisterComponent((Component)this.currentViewer.getViewingComponent());
        }
        if (newViewer.hasViewingComponent() && newViewer.getViewingComponent() instanceof Component) {
            if (this.currentViewer.hasViewingComponent() && this.currentViewer.getViewingComponent() instanceof Component) {
                ((Component)newViewer.getViewingComponent()).setSize(this.currentViewer.getViewingComponentSize());
            }
            this.registerComponent((Component)newViewer.getViewingComponent());
        }
        this.currentViewer = newViewer;
    }

    public int getNumViewers() {
        return this.viewers.length;
    }

    public Viewer[] getViewers() {
        return (Viewer[])this.viewers.clone();
    }

    public String[] getViewerNames() {
        return (String[])this.viewerNames.clone();
    }

    public void selectViewer(String viewerName) {
        for (int i = 0; i < this.viewerNames.length; ++i) {
            if (!this.viewerNames[i].equals(viewerName)) continue;
            this.selectViewer(i);
            return;
        }
        throw new IllegalArgumentException("no such viewer " + viewerName);
    }

    public SceneGraphComponent getSceneRoot() {
        return this.currentViewer.getSceneRoot();
    }

    public SceneGraphComponent getAuxiliaryRoot() {
        return this.currentViewer.getAuxiliaryRoot();
    }

    public SceneGraphPath getCameraPath() {
        return this.currentViewer.getCameraPath();
    }

    public Component getViewingComponent() {
        return this.component;
    }

    public boolean hasViewingComponent() {
        return true;
    }

    public void render() {
        this.currentViewer.render();
    }

    public void setAuxiliaryRoot(SceneGraphComponent ar) {
        this.currentViewer.setAuxiliaryRoot(ar);
    }

    public void setCameraPath(SceneGraphPath p) {
        this.currentViewer.setCameraPath(p);
    }

    public void setSceneRoot(SceneGraphComponent r) {
        this.currentViewer.setSceneRoot(r);
    }

    public boolean canRenderAsync() {
        return this.currentViewer.canRenderAsync();
    }

    public Dimension getViewingComponentSize() {
        return this.currentViewer.getViewingComponentSize();
    }

    public void renderAsync() throws UnsupportedOperationException {
        this.currentViewer.renderAsync();
    }

    public void dispose() {
        if (this.currentViewer.hasViewingComponent() && this.currentViewer.getViewingComponent() instanceof Component) {
            this.unregisterComponent((Component)this.currentViewer.getViewingComponent());
        }
        for (int i = 0; i < this.viewers.length; ++i) {
            Statement stm = new Statement(this.viewers[i], "dispose", null);
            try {
                stm.execute();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setToolSystem(ToolSystem toolSystem) {
        if (ToolSystem.getToolSystemForViewer(this) != toolSystem) {
            ToolSystem.setToolSystemForViewer(this, toolSystem);
        }
        for (Viewer v : this.viewers) {
            if (ToolSystem.getToolSystemForViewer(v) != toolSystem) {
                ToolSystem.setToolSystemForViewer(v, toolSystem);
            }
            LoggingSystem.getLogger(this).fine("Tool system for " + v + " is " + ToolSystem.getToolSystemForViewer(v));
        }
    }

    private class EventDispatcher
    implements KeyListener,
    MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private EventDispatcher() {
        }

        public void keyPressed(KeyEvent e) {
            ViewerSwitch.this.component.dispatchEvent(e);
        }

        public void keyReleased(KeyEvent e) {
            ViewerSwitch.this.component.dispatchEvent(e);
        }

        public void keyTyped(KeyEvent e) {
            ViewerSwitch.this.component.dispatchEvent(e);
        }

        public void mouseClicked(MouseEvent e) {
            ViewerSwitch.this.component.dispatchEvent(e);
        }

        public void mouseEntered(MouseEvent e) {
            ViewerSwitch.this.component.dispatchEvent(e);
        }

        public void mouseExited(MouseEvent e) {
            ViewerSwitch.this.component.dispatchEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            ViewerSwitch.this.component.dispatchEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            ViewerSwitch.this.component.dispatchEvent(e);
        }

        public void mouseDragged(MouseEvent e) {
            ViewerSwitch.this.component.dispatchEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
            ViewerSwitch.this.component.dispatchEvent(e);
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            ViewerSwitch.this.component.dispatchEvent(e);
        }
    }
}

