/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;

class UIFactory {
    private Component viewer = null;
    private Component beanShell = null;
    private Component navigator = null;
    private final Border emptyBorder = BorderFactory.createEmptyBorder();
    private boolean attachNavigator = false;
    private boolean attachBeanShell = false;
    private PropertyChangeListener sizeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (UIFactory.this.beanShell != null) {
                UIFactory.this.beanShell.setPreferredSize(new Dimension(0, ((UIFactory)UIFactory.this).beanShell.getSize().height));
            }
            if (UIFactory.this.beanShellJSP != null) {
                UIFactory.this.beanShellJSP.resetToPreferredSizes();
            }
            if (UIFactory.this.navigator != null) {
                UIFactory.this.navigator.setPreferredSize(new Dimension(((UIFactory)UIFactory.this).navigator.getSize().width, 0));
            }
            if (UIFactory.this.navigatorJSP != null) {
                UIFactory.this.navigatorJSP.resetToPreferredSizes();
            }
        }
    };
    private JSplitPane beanShellJSP;
    private JSplitPane navigatorJSP;

    protected UIFactory() {
    }

    protected Component getDefaultUI() throws UnsupportedOperationException {
        if (this.viewer == null) {
            throw new UnsupportedOperationException("No viewer instantiated");
        }
        this.viewer.removePropertyChangeListener("preferredSize", this.sizeListener);
        if (!this.attachNavigator && !this.attachBeanShell) {
            return this.viewer;
        }
        Component right = this.viewer;
        this.viewer.addPropertyChangeListener("preferredSize", this.sizeListener);
        if (this.attachBeanShell) {
            int dividerLocation = -1;
            if (this.beanShellJSP != null) {
                dividerLocation = this.beanShellJSP.getDividerLocation();
            }
            if (dividerLocation == 1) {
                dividerLocation = this.beanShellJSP.getLastDividerLocation();
            }
            this.beanShellJSP = new JSplitPane(0, this.viewer, this.beanShell);
            this.beanShellJSP.setContinuousLayout(true);
            this.beanShellJSP.setOneTouchExpandable(true);
            this.beanShellJSP.setResizeWeight(1.0);
            this.beanShellJSP.setDividerLocation(dividerLocation);
            right = this.beanShellJSP;
        }
        if (this.attachNavigator) {
            Component left = this.navigator;
            int dividerLocation = -1;
            if (this.navigatorJSP != null) {
                dividerLocation = this.navigatorJSP.getDividerLocation();
            }
            this.navigatorJSP = new JSplitPane(1, left, right);
            this.navigatorJSP.setContinuousLayout(true);
            this.navigatorJSP.setOneTouchExpandable(true);
            this.navigatorJSP.setResizeWeight(0.0);
            this.navigatorJSP.setDividerLocation(dividerLocation);
            return this.navigatorJSP;
        }
        return right;
    }

    protected Component scroll(Component comp) {
        JScrollPane scroll = new JScrollPane(comp);
        scroll.setBorder(this.emptyBorder);
        return scroll;
    }

    protected void setViewer(Component component) {
        this.viewer = component;
        if (new Dimension(0, 0).equals(this.viewer.getPreferredSize())) {
            this.viewer.setPreferredSize(new Dimension(800, 600));
        }
        this.viewer.setMinimumSize(new Dimension(10, 10));
    }

    protected void setBeanShell(Component component) {
        this.beanShell = component;
    }

    protected void setNavigator(Component component) {
        this.navigator = component;
    }

    protected void setAttachNavigator(boolean b) {
        this.attachNavigator = b;
    }

    protected void setAttachBeanShell(boolean b) {
        this.attachBeanShell = b;
    }
}

