/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp;

import de.jreality.scene.Viewer;
import de.jreality.ui.viewerapp.FileFilter;
import de.jreality.ui.viewerapp.FileLoaderDialog;
import de.jreality.ui.viewerapp.ViewerApp;
import de.jreality.util.Secure;
import de.jtem.beans.DimensionPanel;
import de.jtem.beans.InspectorPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.Statement;
import java.io.File;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class SunflowMenu
extends JMenu {
    private static final int CMD_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static javax.swing.filechooser.FileFilter[] fileFilters = new javax.swing.filechooser.FileFilter[3];
    private JFrame settingsFrame;
    private Object renderOptions;
    private Object previewOptions;
    private DimensionPanel dimPanel;
    private Viewer viewer;

    public SunflowMenu(ViewerApp vapp) {
        this(vapp.getViewerSwitch());
    }

    public SunflowMenu(Viewer viewer) {
        super("Sunflow");
        this.viewer = viewer;
        this.settingsFrame = new JFrame("Sunflow Settings");
        JTabbedPane tabs = new JTabbedPane();
        EmptyBorder border = new EmptyBorder(10, 10, 10, 10);
        this.previewOptions = this.createPreviewOptions();
        InspectorPanel previewSettings = new InspectorPanel(false);
        previewSettings.setBorder((Border)border);
        HashSet<String> previewExcludes = new HashSet<String>();
        previewExcludes.add("progressiveRender");
        previewExcludes.add("threadsLowPriority");
        previewExcludes.add("aaMax");
        previewExcludes.add("aaMin");
        previewExcludes.add("filter");
        previewExcludes.add("contrastThreshold");
        previewSettings.setObject(this.previewOptions, previewExcludes);
        tabs.add("preview", (Component)previewSettings);
        this.renderOptions = this.createRenderOptions();
        InspectorPanel renderSettings = new InspectorPanel(false);
        renderSettings.setBorder((Border)border);
        renderSettings.setObject(this.renderOptions, Collections.singleton("progressiveRender"));
        tabs.add("render", (Component)renderSettings);
        this.settingsFrame.add(tabs);
        this.settingsFrame.pack();
        AbstractAction previewAction = new AbstractAction("preview"){

            public void actionPerformed(ActionEvent arg0) {
                Secure.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        Viewer v = SunflowMenu.this.getViewer();
                        SunflowMenu.this.render(v, v.getViewingComponentSize(), SunflowMenu.this.getPreviewOptions());
                        return null;
                    }
                });
            }
        };
        previewAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, CMD_MASK));
        this.add(previewAction);
        this.add(new AbstractAction("render"){

            public void actionPerformed(ActionEvent arg0) {
                Secure.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        SunflowMenu.this.renderAndSave(SunflowMenu.this.getViewer(), SunflowMenu.this.getRenderOptions());
                        return null;
                    }
                });
            }
        });
        this.add(new AbstractAction("settings"){

            public void actionPerformed(ActionEvent arg0) {
                SunflowMenu.this.showSettingsInspector();
            }
        });
    }

    private Object createPreviewOptions() {
        try {
            Object renderOptions = Class.forName("de.jreality.sunflow.RenderOptions").newInstance();
            return renderOptions;
        }
        catch (Throwable e) {
            throw new RuntimeException("sunflow missing", e);
        }
    }

    private Object createRenderOptions() {
        try {
            Object renderOptions = Class.forName("de.jreality.sunflow.RenderOptions").newInstance();
            new Statement(renderOptions, "setAaMin", new Object[]{0}).execute();
            new Statement(renderOptions, "setAaMax", new Object[]{2}).execute();
            new Statement(renderOptions, "setProgressiveRender", new Object[]{false}).execute();
            new Statement(renderOptions, "setFilter", new Object[]{"gaussian"}).execute();
            return renderOptions;
        }
        catch (Throwable e) {
            throw new RuntimeException("sunflow missing", e);
        }
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    protected void renderAndSave(Viewer viewer, Object opts) {
        File file;
        if (this.dimPanel == null) {
            this.dimPanel = new DimensionPanel();
            this.dimPanel.setDimension(new Dimension(800, 600));
            TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Dimension");
            this.dimPanel.setBorder((Border)title);
        }
        if ((file = FileLoaderDialog.selectTargetFile(null, (JComponent)this.dimPanel, false, fileFilters)) == null) {
            return;
        }
        Dimension dim = this.dimPanel.getDimension();
        try {
            new Statement(Class.forName("de.jreality.sunflow.Sunflow"), "renderAndSave", new Object[]{viewer, opts, dim, file}).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void render(Viewer viewer, Dimension dim, Object opts) {
        try {
            new Statement(Class.forName("de.jreality.sunflow.Sunflow"), "render", new Object[]{viewer, dim, opts}).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showSettingsInspector() {
        this.settingsFrame.setVisible(true);
        this.settingsFrame.toFront();
    }

    public Object getRenderOptions() {
        return this.renderOptions;
    }

    public Object getPreviewOptions() {
        return this.previewOptions;
    }

    static {
        SunflowMenu.fileFilters[0] = new FileFilter("PNG Image", "png");
        SunflowMenu.fileFilters[1] = new FileFilter("TGA Image", "tga");
        SunflowMenu.fileFilters[2] = new FileFilter("HDR Image", "hdr");
    }
}

