/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp;

import de.jreality.geometry.BoundingBoxUtility;
import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.geometry.SphereUtility;
import de.jreality.scene.Appearance;
import de.jreality.scene.Cylinder;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphPathObserver;
import de.jreality.scene.Sphere;
import de.jreality.scene.Viewer;
import de.jreality.scene.event.TransformationEvent;
import de.jreality.scene.event.TransformationListener;
import de.jreality.ui.viewerapp.SelectionEvent;
import de.jreality.ui.viewerapp.SelectionListener;
import de.jreality.ui.viewerapp.SelectionManager;
import de.jreality.util.LoggingSystem;
import de.jreality.util.Rectangle3D;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;

public class SelectionRenderer
implements SelectionListener {
    SceneGraphComponent selectionKit;
    SceneGraphComponent boundKit;
    Appearance boundAppearance;
    SceneGraphPath selection;
    SceneGraphPathObserver observer;
    Viewer viewer;
    boolean visible = false;

    public SelectionRenderer(SelectionManager sm, Viewer v) {
        this.viewer = v;
        this.boundKit = SceneGraphUtility.createFullSceneGraphComponent("boundKit");
        this.boundAppearance = this.boundKit.getAppearance();
        this.boundAppearance.setAttribute("showLines", true);
        this.boundAppearance.setAttribute("showFaces", false);
        this.boundAppearance.setAttribute("showPoints", false);
        this.boundAppearance.setAttribute("lightingEnabled", false);
        this.boundAppearance.setAttribute("lineShader.lineStipple", true);
        this.boundAppearance.setAttribute("lineShader.lineFactor", 1.0);
        this.boundAppearance.setAttribute("lineShader.lineStipplePattern", 26214);
        this.boundAppearance.setAttribute("lineShader.lineWidth", 2.0);
        this.boundAppearance.setAttribute("lineShader.tubeDraw", false);
        this.boundAppearance.setAttribute("levelOfDetail", 0.0);
        this.boundAppearance.setAttribute("lineShader.diffuseColor", Color.WHITE);
        this.selectionKit = SceneGraphUtility.createFullSceneGraphComponent("selectionKit");
        sm.addSelectionListener(this);
        this.selectionKit.addChild(this.boundKit);
        this.observer = new SceneGraphPathObserver();
        this.observer.addTransformationListener(new TransformationListener(){

            public void transformationMatrixChanged(TransformationEvent ev) {
                if (SelectionRenderer.this.selection == null) {
                    return;
                }
                if (SelectionRenderer.this.boundKit.getTransformation() != null) {
                    SelectionRenderer.this.boundKit.getTransformation().setMatrix(SelectionRenderer.this.selection.getMatrix(null));
                }
            }
        });
    }

    public void setSelectionPath(SceneGraphPath s) {
        this.selection = new SceneGraphPath(s);
        this.boundKit.getTransformation().setMatrix(this.selection.getMatrix(null));
        boolean selectionEditable = this.selection.getLastElement() instanceof SceneGraphComponent && this.selection.getLastComponent().getTransformation() != null;
        this.boundAppearance = this.boundKit.getAppearance();
        this.boundAppearance.setAttribute("lineShader.lineStipple", !selectionEditable);
        SceneGraphNode sgn = this.selection.getLastElement();
        Rectangle3D bbox = null;
        if (sgn instanceof SceneGraphComponent) {
            bbox = BoundingBoxUtility.calculateChildrenBoundingBox((SceneGraphComponent)sgn);
        } else if (sgn instanceof PointSet) {
            bbox = BoundingBoxUtility.calculateBoundingBox((PointSet)sgn);
        } else if (sgn instanceof Sphere) {
            bbox = SphereUtility.getSphereBoundingBox();
        } else if (sgn instanceof Cylinder) {
            bbox = SphereUtility.getSphereBoundingBox();
        } else {
            LoggingSystem.getLogger(this).warning("Unknown selection class: " + sgn.getClass().toString());
            return;
        }
        LoggingSystem.getLogger(this).fine("BBox is " + bbox.toString());
        IndexedFaceSet boxRepresentation = IndexedFaceSetUtility.representAsSceneGraph(null, bbox);
        this.boundKit.setGeometry(boxRepresentation);
        this.observer.setPath(this.selection);
        SelectionRenderer.addAuxiliaryComponent(this.selectionKit, this.viewer);
        this.viewer.renderAsync();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.boundKit.setVisible(visible);
        this.viewer.renderAsync();
    }

    public void dispose() {
        this.observer.dispose();
        SelectionRenderer.removeAuxiliaryComponent(this.selectionKit, this.viewer);
    }

    public static void addAuxiliaryComponent(SceneGraphComponent aux, Viewer v) {
        if (v.getAuxiliaryRoot() == null) {
            v.setAuxiliaryRoot(SceneGraphUtility.createFullSceneGraphComponent("AuxiliaryRoot"));
        }
        if (!v.getAuxiliaryRoot().isDirectAncestor(aux)) {
            v.getAuxiliaryRoot().addChild(aux);
        }
    }

    public static void removeAuxiliaryComponent(SceneGraphComponent aux, Viewer v) {
        if (v.getAuxiliaryRoot() == null) {
            return;
        }
        if (!v.getAuxiliaryRoot().isDirectAncestor(aux)) {
            return;
        }
        v.getAuxiliaryRoot().removeChild(aux);
    }

    public void selectionChanged(SelectionEvent e) {
        this.setSelectionPath(e.getSelection().getSGPath());
    }
}

