/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.treeview;

import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.data.AttributeEntity;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.scene.event.SceneGraphComponentEvent;
import de.jreality.scene.event.SceneGraphComponentListener;
import de.jreality.scene.event.ToolEvent;
import de.jreality.scene.event.ToolListener;
import de.jreality.scene.proxy.tree.ProxyTreeFactory;
import de.jreality.scene.proxy.tree.SceneGraphNodeEntity;
import de.jreality.scene.proxy.tree.SceneTreeNode;
import de.jreality.scene.proxy.tree.UpToDateSceneProxyBuilder;
import de.jreality.scene.tool.Tool;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.RenderingHintsShader;
import de.jreality.shader.RootAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.ui.treeview.AbstractTreeModel;
import de.jreality.ui.viewerapp.Selection;
import java.awt.EventQueue;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.WeakHashMap;

public class SceneTreeModel
extends AbstractTreeModel {
    private UpToDateSceneProxyBuilder builder;
    WeakHashMap<Object, Object[]> entities = new WeakHashMap();
    WeakHashMap<Object, Object> parents = new WeakHashMap();

    public SceneTreeModel(SceneGraphComponent root) {
        super(null);
        this.setSceneRoot(root);
    }

    public void dispose() {
        this.builder.dispose();
        this.builder = null;
    }

    public UpToDateSceneProxyBuilder getBuilder() {
        return this.builder;
    }

    void setSceneRoot(SceneGraphComponent comp) {
        if (this.builder != null) {
            throw new IllegalStateException("twice called");
        }
        if (comp == null) {
            return;
        }
        this.builder = new UpToDateSceneProxyBuilder(comp);
        this.builder.setProxyTreeFactory(new ProxyTreeFactory(){

            public SceneTreeNode createProxyTreeNode(SceneGraphNode n) {
                return new SceneTreeNodeWithToolListener(n);
            }
        });
        this.root = this.builder.createProxyTree();
    }

    public Object getChild(Object parent, int index) {
        SceneTreeNode sn;
        if (parent instanceof SceneTreeNode && (sn = (SceneTreeNode)parent).getNode() instanceof SceneGraphComponent) {
            if (index < sn.getChildren().size()) {
                return sn.getChildren().get(index);
            }
            int newInd = index - sn.getChildren().size();
            SceneGraphComponent comp = (SceneGraphComponent)sn.getNode();
            Tool t = comp.getTools().get(newInd);
            return new TreeTool(sn, t);
        }
        Object[] childEntities = this.entities.get(parent);
        return childEntities[index];
    }

    public int getChildCount(Object parent) {
        if (parent instanceof TreeTool) {
            return 0;
        }
        if (parent instanceof SceneTreeNode) {
            SceneTreeNode sn = (SceneTreeNode)parent;
            if (sn.getNode() instanceof Appearance) {
                Object[] ents = this.entities.get(sn);
                if (ents == null) {
                    DefaultGeometryShader o1 = ShaderUtility.createDefaultGeometryShader((Appearance)sn.getNode(), false);
                    RenderingHintsShader o11 = ShaderUtility.createDefaultRenderingHintsShader((Appearance)sn.getNode(), false);
                    RootAppearance o2 = null;
                    if (AttributeEntityUtility.hasAttributeEntity(RootAppearance.class, "", (Appearance)sn.getNode())) {
                        o2 = ShaderUtility.createRootAppearance((Appearance)sn.getNode());
                    }
                    ents = new Object[o2 == null ? 2 : 3];
                    ents[0] = o1;
                    ents[1] = o11;
                    if (o2 != null) {
                        ents[2] = o2;
                    }
                    this.entities.put(sn, ents);
                    for (int i = 0; i < ents.length; ++i) {
                        this.parents.put(ents[i], sn);
                    }
                }
                return ents.length;
            }
            int ret = sn.getChildren().size();
            if (sn.getNode() instanceof SceneGraphComponent) {
                ret += ((SceneGraphComponent)sn.getNode()).getTools().size();
            }
            return ret;
        }
        Object[] ents = this.entities.get(parent);
        if (ents == null) {
            BeanInfo bi = null;
            try {
                bi = Introspector.getBeanInfo(parent.getClass());
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            PropertyDescriptor[] pd = bi.getPropertyDescriptors();
            LinkedList<AttributeEntity> childEntities = new LinkedList<AttributeEntity>();
            for (int i = 0; i < pd.length; ++i) {
                if (!AttributeEntity.class.isAssignableFrom(pd[i].getPropertyType())) continue;
                try {
                    AttributeEntity ae = (AttributeEntity)pd[i].getReadMethod().invoke(parent, (Object[])null);
                    if (ae == null) continue;
                    childEntities.add(ae);
                    this.parents.put(ae, parent);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ents = childEntities.toArray();
            this.entities.put(parent, ents);
        }
        return ents.length;
    }

    public Object getParent(Object o) {
        if (o instanceof SceneTreeNode) {
            return ((SceneTreeNode)o).getParent();
        }
        if (o instanceof TreeTool) {
            return ((TreeTool)o).getTreeNode();
        }
        return this.parents.get(o);
    }

    public SceneTreeNode[] convertSceneGraphPath(SceneGraphPath selection) {
        ArrayList<SceneTreeNode> al = new ArrayList<SceneTreeNode>(selection.getLength());
        SceneTreeNode parent = this.builder.getTreeRoot();
        al.add(parent);
        ListIterator<SceneGraphNode> it = selection.iterator(1);
        while (it.hasNext()) {
            SceneTreeNode child = parent.getTreeNodeForChild((SceneGraphNode)it.next());
            al.add(child);
            parent = child;
        }
        return al.toArray(new SceneTreeNode[0]);
    }

    public SceneTreeNode[] convertSelection(Selection selection) {
        return this.convertSceneGraphPath(selection.getSGPath());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SceneTreeNodeWithToolListener
    extends SceneTreeNode
    implements ToolListener,
    SceneGraphComponentListener {
        SceneGraphComponent cmp;
        List<Tool> tools;

        protected SceneTreeNodeWithToolListener(SceneGraphNode node) {
            super(node);
            this.tools = new LinkedList<Tool>();
            if (this.isComponent) {
                this.cmp = (SceneGraphComponent)node;
                this.cmp.addToolListener(this);
                this.cmp.addSceneGraphComponentListener(this);
                this.tools.addAll(this.cmp.getTools());
            }
        }

        @Override
        public int addChild(final SceneTreeNode child) {
            final int[] ret = new int[1];
            Runnable runner = new Runnable(){

                public void run() {
                    ret[0] = SceneTreeNodeWithToolListener.super.addChild(child);
                    SceneTreeModel.this.fireNodesAdded(SceneTreeNodeWithToolListener.this, new Object[]{child});
                }
            };
            if (EventQueue.isDispatchThread()) {
                runner.run();
            } else {
                try {
                    EventQueue.invokeAndWait(runner);
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
            return ret[0];
        }

        @Override
        protected int removeChild(final SceneTreeNode prevChild) {
            final int[] ret = new int[1];
            Runnable runner = new Runnable(){

                public void run() {
                    ret[0] = SceneTreeNodeWithToolListener.super.removeChild(prevChild);
                    SceneTreeModel.this.fireNodesRemoved(SceneTreeNodeWithToolListener.this, new int[]{ret[0]}, new Object[]{prevChild});
                }
            };
            if (EventQueue.isDispatchThread()) {
                runner.run();
            } else {
                try {
                    EventQueue.invokeAndWait(runner);
                }
                catch (InterruptedException e) {
                    throw new Error(e);
                }
                catch (InvocationTargetException e) {
                    throw new Error(e);
                }
            }
            return ret[0];
        }

        @Override
        public void toolAdded(final ToolEvent ev) {
            Runnable runner = new Runnable(){

                public void run() {
                    int idx = SceneTreeNodeWithToolListener.this.getChildren().size() + SceneTreeNodeWithToolListener.this.tools.size();
                    SceneTreeNodeWithToolListener.this.tools.add(ev.getTool());
                    SceneTreeModel.this.fireNodesAdded(SceneTreeNodeWithToolListener.this, new int[]{idx}, new Object[]{new TreeTool(SceneTreeNodeWithToolListener.this, ev.getTool())});
                }
            };
            if (EventQueue.isDispatchThread()) {
                runner.run();
            } else {
                try {
                    EventQueue.invokeAndWait(runner);
                }
                catch (Exception e) {
                    throw new Error(";-(");
                }
            }
        }

        @Override
        public void toolRemoved(final ToolEvent ev) {
            Runnable runner = new Runnable(){

                public void run() {
                    int idx = SceneTreeNodeWithToolListener.this.getChildren().size();
                    int tind = SceneTreeNodeWithToolListener.this.tools.indexOf(ev.getTool());
                    SceneTreeNodeWithToolListener.this.tools.remove(tind);
                    SceneTreeModel.this.fireNodesRemoved(SceneTreeNodeWithToolListener.this, new int[]{idx + tind}, new Object[]{new TreeTool(SceneTreeNodeWithToolListener.this, ev.getTool())});
                }
            };
            if (EventQueue.isDispatchThread()) {
                runner.run();
            } else {
                try {
                    EventQueue.invokeAndWait(runner);
                }
                catch (Exception e) {
                    throw new Error(";-(");
                }
            }
        }

        @Override
        protected void dispose(ArrayList<SceneGraphNodeEntity> disposedEntities) {
            super.dispose(disposedEntities);
            if (this.isComponent) {
                this.cmp.removeToolListener(this);
                this.cmp.removeSceneGraphComponentListener(this);
            }
        }

        @Override
        public void childAdded(SceneGraphComponentEvent ev) {
        }

        @Override
        public void childRemoved(SceneGraphComponentEvent ev) {
        }

        @Override
        public void childReplaced(SceneGraphComponentEvent ev) {
        }

        @Override
        public void visibilityChanged(SceneGraphComponentEvent ev) {
            Runnable runner = new Runnable(){

                public void run() {
                    SceneTreeModel.this.fireNodesChanged(SceneTreeNodeWithToolListener.this.getParent(), new Object[]{SceneTreeNodeWithToolListener.this});
                }
            };
            if (EventQueue.isDispatchThread()) {
                runner.run();
            } else {
                try {
                    EventQueue.invokeAndWait(runner);
                }
                catch (Exception e) {
                    throw new Error(";-(");
                }
            }
        }
    }

    public static class TreeTool {
        private final Tool tool;
        private SceneTreeNode node;

        private TreeTool(SceneTreeNode n, Tool t) {
            this.node = n;
            this.tool = t;
        }

        public Tool getTool() {
            return this.tool;
        }

        public SceneTreeNode getTreeNode() {
            return this.node;
        }

        public int hashCode() {
            return this.node.hashCode() ^ this.tool.hashCode() * 31;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TreeTool) {
                TreeTool tt = (TreeTool)obj;
                return this.node == tt.node && this.tool == tt.tool;
            }
            return false;
        }
    }
}

