/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import java.util.List;
import java.util.Map;

public class VirtualScaleAxis
implements VirtualDevice {
    InputSlot inSlot;
    InputSlot outSlot;
    AxisState state;
    double scalePos = 1.0;
    double scaleNeg = 1.0;
    double lastVal = Double.NaN;

    public ToolEvent process(VirtualDeviceContext context) throws MissingSlotException {
        double val = context.getAxisState(this.inSlot).doubleValue();
        double ret = val > 0.0 ? this.scalePos * val : this.scaleNeg * val;
        return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.outSlot, new AxisState(ret));
    }

    public void initialize(List inputSlots, InputSlot result, Map configuration) {
        this.inSlot = (InputSlot)inputSlots.get(0);
        this.outSlot = result;
        Double s = (Double)configuration.get("scale");
        Double sp = (Double)configuration.get("scalePos");
        Double sn = (Double)configuration.get("scaleNeg");
        if (s != null) {
            this.scalePos = this.scaleNeg = s.doubleValue();
        }
        if (sp != null) {
            this.scalePos = sp;
        }
        if (sn != null) {
            this.scaleNeg = sn;
        }
    }

    public void dispose() {
    }

    public String getName() {
        return "ScaleAxis";
    }
}

