/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.math.Rn;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import java.util.List;
import java.util.Map;

public class VirtualEvolutionOperator
implements VirtualDevice {
    private boolean isAxis = false;
    InputSlot inSlot;
    InputSlot outSlot;
    double oldAxis;
    boolean isFirst = true;
    double[] oldTrafo = null;
    double[] slotValue = new double[16];
    DoubleArray outTrafo = new DoubleArray(this.slotValue);

    public ToolEvent process(VirtualDeviceContext context) throws MissingSlotException {
        double newVal;
        if (!this.isAxis) {
            double[] newTrafo;
            try {
                newTrafo = context.getTransformationMatrix(this.inSlot).toDoubleArray(null);
            }
            catch (NullPointerException ne) {
                throw new MissingSlotException(this.inSlot);
            }
            if (this.oldTrafo == null) {
                this.oldTrafo = newTrafo;
                return null;
            }
            this.oldTrafo = Rn.inverse(this.oldTrafo, this.oldTrafo);
            this.slotValue = Rn.times(this.slotValue, newTrafo, this.oldTrafo);
            this.oldTrafo = newTrafo;
            return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.outSlot, this.outTrafo);
        }
        try {
            newVal = context.getAxisState(this.inSlot).doubleValue();
        }
        catch (NullPointerException ne) {
            throw new MissingSlotException(this.inSlot);
        }
        double dval = newVal - this.oldAxis;
        this.oldAxis = newVal;
        return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.outSlot, new AxisState(dval));
    }

    public void initialize(List inputSlots, InputSlot result, Map configuration) {
        this.inSlot = (InputSlot)inputSlots.get(0);
        this.outSlot = result;
        try {
            if (((String)configuration.get("slottype")).equalsIgnoreCase("axis")) {
                this.isAxis = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void dispose() {
    }

    public String getName() {
        return "DeltaTrafo";
    }
}

