/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.util;

import de.sciss.net.OSCClient;
import de.sciss.net.OSCListener;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCServer;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSCPool {
    private static final Map<InetSocketAddress, WeakReference<OSCClient>> udpClients = new HashMap<InetSocketAddress, WeakReference<OSCClient>>();
    private static final Map<InetSocketAddress, WeakReference<OSCClient>> tcpClients = new HashMap<InetSocketAddress, WeakReference<OSCClient>>();
    private static final Map<Integer, WeakReference<OSCServer>> udpServers = new HashMap<Integer, WeakReference<OSCServer>>();
    private static final Map<Integer, WeakReference<OSCServer>> tcpServers = new HashMap<Integer, WeakReference<OSCServer>>();

    public static OSCClient getUDPClient(InetSocketAddress addr) throws IOException {
        return OSCPool.getClient(addr, udpClients, "udp");
    }

    public static OSCClient getTCPClient(InetSocketAddress addr) throws IOException {
        return OSCPool.getClient(addr, tcpClients, "tcp");
    }

    public static OSCServer getUDPServer(int port) throws IOException {
        return OSCPool.getServer(port, udpServers, "udp");
    }

    public static OSCServer getTCPServer(int port) throws IOException {
        return OSCPool.getServer(port, tcpServers, "tcp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OSCClient getClient(InetSocketAddress addr, Map<InetSocketAddress, WeakReference<OSCClient>> clients, String protocol) throws IOException {
        Map<InetSocketAddress, WeakReference<OSCClient>> map = clients;
        synchronized (map) {
            OSCClient client;
            WeakReference<OSCClient> ref = clients.get(addr);
            OSCClient oSCClient = client = ref != null ? (OSCClient)ref.get() : null;
            if (client == null) {
                client = OSCClient.newUsing((String)protocol);
                client.setTarget((SocketAddress)addr);
                client.start();
                clients.put(addr, new WeakReference<OSCClient>(client));
            }
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OSCServer getServer(int port, Map<Integer, WeakReference<OSCServer>> servers, String protocol) throws IOException {
        Map<Integer, WeakReference<OSCServer>> map = servers;
        synchronized (map) {
            OSCServer server;
            WeakReference<OSCServer> ref = servers.get(port);
            OSCServer oSCServer = server = ref != null ? (OSCServer)ref.get() : null;
            if (server == null) {
                server = OSCServer.newUsing((String)protocol, (int)port);
                server.start();
                servers.put(port, new WeakReference<OSCServer>(server));
            }
            return server;
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        OSCServer osc = OSCPool.getUDPServer(5600);
        osc.addOSCListener(new OSCListener(){

            public void messageReceived(OSCMessage msg, SocketAddress sender, long time) {
                System.err.println(msg.getName() + " from " + sender);
                for (int i = 0; i < msg.getArgCount(); ++i) {
                    System.err.println("  * " + msg.getArg(i));
                }
            }
        });
        while (true) {
            Thread.sleep(1000L);
        }
    }
}

