/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.config;

import de.jreality.toolsystem.raw.RawDevice;
import de.jreality.util.LoggingSystem;
import java.beans.DefaultPersistenceDelegate;
import java.beans.PersistenceDelegate;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawDeviceConfig {
    public static final PersistenceDelegate DELEGATE = new DefaultPersistenceDelegate(new String[]{"rawDevice", "deviceID", "config"});
    private final String deviceID;
    private final String rawDevice;
    private final Map<String, Object> config;

    public RawDeviceConfig(String type, String deviceID, Map<String, Object> config) {
        this.deviceID = deviceID;
        this.rawDevice = type;
        this.config = config;
    }

    public String getRawDevice() {
        return this.rawDevice;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public Map<String, Object> getConfiguration() {
        return this.config;
    }

    public String toString() {
        return this.deviceID + "[" + this.rawDevice + "]";
    }

    public RawDevice createDevice() throws InstantiationException {
        try {
            RawDevice dev = (RawDevice)Class.forName(this.rawDevice).newInstance();
            return dev;
        }
        catch (Throwable t) {
            LoggingSystem.getLogger(this).log(Level.CONFIG, "cannot create raw device", t);
            throw new InstantiationException("cannot create raw device:" + this.rawDevice);
        }
    }
}

