/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem;

import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.Tool;
import de.jreality.toolsystem.config.ToolSystemConfiguration;
import de.jreality.toolsystem.config.VirtualMapping;
import de.jreality.util.LoggingSystem;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlotManager {
    private final HashMap<InputSlot, HashSet<Tool>> slot2activation = new HashMap();
    private final HashMap<InputSlot, HashSet<Tool>> slot2active = new HashMap();
    private final HashMap<Tool, HashSet<InputSlot>> tool2currentSlots = new HashMap();
    private final HashMap<InputSlot, HashSet<Tool>> slot2deactivation = new HashMap();
    private final HashMap<InputSlot, HashSet<InputSlot>> virtualMappings = new HashMap();
    private final HashMap<InputSlot, HashSet<InputSlot>> virtualMappingsInv = new HashMap();
    private final HashMap<Tool, HashMap<InputSlot, InputSlot>> slotsToMappingsForTool = new HashMap();
    private final HashMap<Tool, HashSet<InputSlot>> virtualSlotsForTool = new HashMap();

    SlotManager(ToolSystemConfiguration config) {
        List<VirtualMapping> virtualMappings = config.getVirtualMappings();
        for (VirtualMapping vm : virtualMappings) {
            this.getMappingsSourceToTargets(vm.getSourceSlot()).add(vm.getTargetSlot());
            this.getMappingsTargetToSources(vm.getTargetSlot()).add(vm.getSourceSlot());
        }
    }

    private Set<InputSlot> getMappingsSourceToTargets(InputSlot slot) {
        if (!this.virtualMappings.containsKey(slot)) {
            this.virtualMappings.put(slot, new HashSet());
        }
        return this.virtualMappings.get(slot);
    }

    private Set<InputSlot> getMappingsTargetToSources(InputSlot slot) {
        if (!this.virtualMappingsInv.containsKey(slot)) {
            this.virtualMappingsInv.put(slot, new HashSet());
        }
        return this.virtualMappingsInv.get(slot);
    }

    private Map<InputSlot, InputSlot> getMappingsForTool(Tool tool) {
        if (!this.slotsToMappingsForTool.containsKey(tool)) {
            this.slotsToMappingsForTool.put(tool, new HashMap());
        }
        return this.slotsToMappingsForTool.get(tool);
    }

    Set<Tool> getToolsActivatedBySlot(InputSlot slot) {
        return Collections.unmodifiableSet(this.getSlot2activation(slot));
    }

    private Set<Tool> getSlot2activation(InputSlot slot) {
        if (!this.slot2activation.containsKey(slot)) {
            this.slot2activation.put(slot, new HashSet());
        }
        return this.slot2activation.get(slot);
    }

    Set<Tool> getToolsDeactivatedBySlot(InputSlot slot) {
        return Collections.unmodifiableSet(this.getSlot2deactivation(slot));
    }

    private Set<Tool> getSlot2deactivation(InputSlot slot) {
        if (!this.slot2deactivation.containsKey(slot)) {
            this.slot2deactivation.put(slot, new HashSet());
        }
        return this.slot2deactivation.get(slot);
    }

    Set<Tool> getActiveToolsForSlot(InputSlot slot) {
        return Collections.unmodifiableSet(this.getSlot2active(slot));
    }

    private Set<Tool> getSlot2active(InputSlot slot) {
        if (!this.slot2active.containsKey(slot)) {
            this.slot2active.put(slot, new HashSet());
        }
        return this.slot2active.get(slot);
    }

    private Set<InputSlot> getTool2currentSlots(Tool tool) {
        if (!this.tool2currentSlots.containsKey(tool)) {
            this.tool2currentSlots.put(tool, new HashSet());
        }
        return this.tool2currentSlots.get(tool);
    }

    boolean isActiveSlot(InputSlot slot) {
        return this.slot2active.containsKey(slot);
    }

    boolean isActivationSlot(InputSlot slot) {
        return this.slot2activation.containsKey(slot);
    }

    private Set<InputSlot> getVirtualSlotsForTool(Tool tool) {
        if (!this.virtualSlotsForTool.containsKey(tool)) {
            this.virtualSlotsForTool.put(tool, new HashSet());
        }
        return this.virtualSlotsForTool.get(tool);
    }

    Set<InputSlot> resolveSlot(InputSlot slot) {
        HashSet<InputSlot> ret = new HashSet<InputSlot>();
        this.findTriggerSlots(ret, slot);
        return ret;
    }

    private void findTriggerSlots(Set<InputSlot> l, InputSlot slot) {
        Set<InputSlot> sources = this.getMappingsTargetToSources(slot);
        if (sources.isEmpty()) {
            l.add(slot);
            return;
        }
        for (InputSlot sl : sources) {
            this.findTriggerSlots(l, sl);
        }
    }

    private Set<InputSlot> resolveSlots(List<InputSlot> slotSet) {
        HashSet<InputSlot> ret = new HashSet<InputSlot>();
        for (InputSlot slot : slotSet) {
            this.findTriggerSlots(ret, slot);
        }
        return ret;
    }

    void updateMaps(Set<Tool> activeTools, Set<Tool> activatedTools, Set<Tool> deactivatedTools) {
        for (Tool tool : activatedTools) {
            for (InputSlot slot : tool.getCurrentSlots()) {
                for (InputSlot resolvedSlot : this.resolveSlot(slot)) {
                    this.getSlot2active(resolvedSlot).add(tool);
                    this.getMappingsForTool(tool).put(resolvedSlot, slot);
                }
            }
            Set<InputSlot> currentSlots = this.resolveSlots(tool.getCurrentSlots());
            this.getTool2currentSlots(tool).addAll(currentSlots);
            this.getVirtualSlotsForTool(tool).addAll(tool.getCurrentSlots());
            for (InputSlot slot : tool.getActivationSlots()) {
                for (InputSlot resolvedSlot : this.resolveSlot(slot)) {
                    this.getSlot2activation(resolvedSlot).remove(tool);
                    this.getSlot2deactivation(resolvedSlot).add(tool);
                }
            }
        }
        for (Tool tool : deactivatedTools) {
            for (InputSlot slot : tool.getCurrentSlots()) {
                for (InputSlot resolvedSlot : this.resolveSlot(slot)) {
                    this.getSlot2active(resolvedSlot).remove(tool);
                    this.getMappingsForTool(tool).remove(resolvedSlot);
                }
            }
            for (InputSlot slot : tool.getActivationSlots()) {
                for (InputSlot resolvedSlot : this.resolveSlot(slot)) {
                    this.getSlot2activation(resolvedSlot).add(tool);
                    this.getSlot2deactivation(resolvedSlot).remove(tool);
                }
            }
            this.getVirtualSlotsForTool(tool).clear();
            this.getVirtualSlotsForTool(tool).addAll(tool.getActivationSlots());
        }
        for (Tool tool : activeTools) {
            Set<InputSlot> newUsed = this.resolveSlots(tool.getCurrentSlots());
            Set<InputSlot> oldUsed = this.getTool2currentSlots(tool);
            HashSet<InputSlot> added = new HashSet<InputSlot>(newUsed);
            added.removeAll(oldUsed);
            HashSet<InputSlot> removed = new HashSet<InputSlot>(oldUsed);
            removed.removeAll(newUsed);
            for (InputSlot slot : added) {
                this.getSlot2active(slot).add(tool);
            }
            for (InputSlot slot : removed) {
                this.getSlot2active(slot).remove(tool);
            }
            this.getTool2currentSlots(tool).removeAll(removed);
            this.getTool2currentSlots(tool).addAll(added);
            HashSet<InputSlot> oldUsedVirtual = new HashSet<InputSlot>(this.getVirtualSlotsForTool(tool));
            HashSet<InputSlot> newUsedVirtual = new HashSet<InputSlot>();
            newUsedVirtual.addAll(tool.getActivationSlots());
            newUsedVirtual.addAll(tool.getCurrentSlots());
            oldUsedVirtual.removeAll(newUsedVirtual);
            newUsedVirtual.removeAll(this.getVirtualSlotsForTool(tool));
            this.getVirtualSlotsForTool(tool).removeAll(oldUsedVirtual);
            this.getVirtualSlotsForTool(tool).addAll(newUsedVirtual);
            this.getMappingsForTool(tool).keySet().removeAll(oldUsedVirtual);
            for (InputSlot newSlot : newUsedVirtual) {
                for (InputSlot virtualSlot : this.resolveSlot(newSlot)) {
                    this.getMappingsForTool(tool).put(virtualSlot, newSlot);
                }
            }
        }
    }

    void registerTool(Tool tool) {
        if (tool.getActivationSlots().isEmpty()) {
            this.getVirtualSlotsForTool(tool).addAll(tool.getCurrentSlots());
            for (InputSlot mappedSlot : tool.getCurrentSlots()) {
                this.getTool2currentSlots(tool).addAll(this.resolveSlot(mappedSlot));
                for (InputSlot resolvedSlot : this.resolveSlot(mappedSlot)) {
                    this.getMappingsForTool(tool).put(resolvedSlot, mappedSlot);
                    this.getSlot2active(resolvedSlot).add(tool);
                }
            }
        } else {
            this.getVirtualSlotsForTool(tool).addAll(tool.getActivationSlots());
            for (InputSlot mappedSlot : tool.getActivationSlots()) {
                Set<InputSlot> resolvedSlots = this.resolveSlot(mappedSlot);
                for (InputSlot resolvedSlot : resolvedSlots) {
                    this.getMappingsForTool(tool).put(resolvedSlot, mappedSlot);
                    this.getSlot2activation(resolvedSlot).add(tool);
                }
            }
        }
        LoggingSystem.getLogger(this).info("registered Tool " + tool.getClass().getName());
    }

    void unregisterTool(Tool tool) {
        if (tool.getActivationSlots().isEmpty()) {
            for (InputSlot mappedSlot : tool.getCurrentSlots()) {
                Set<InputSlot> resolvedSlots = this.resolveSlot(mappedSlot);
                for (InputSlot resolvedSlot : resolvedSlots) {
                    this.getSlot2active(resolvedSlot).remove(tool);
                }
            }
        } else {
            for (InputSlot mappedSlot : tool.getActivationSlots()) {
                Set<InputSlot> resolvedSlots = this.resolveSlot(mappedSlot);
                for (InputSlot resolvedSlot : resolvedSlots) {
                    this.getSlot2activation(resolvedSlot).remove(tool);
                }
            }
        }
        this.getMappingsForTool(tool).clear();
        this.getTool2currentSlots(tool).clear();
        this.getVirtualSlotsForTool(tool).clear();
        LoggingSystem.getLogger(this).info("unregistered Tool " + tool.getClass().getName());
    }

    InputSlot resolveSlotForTool(Tool tool, InputSlot sourceSlot) {
        InputSlot ret = this.getMappingsForTool(tool).get(sourceSlot);
        return ret == null ? sourceSlot : ret;
    }
}

