/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem;

import de.jreality.math.Matrix;
import de.jreality.math.Rn;
import de.jreality.scene.Camera;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.Poller;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.ToolEventQueue;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import de.jreality.toolsystem.config.RawDeviceConfig;
import de.jreality.toolsystem.config.RawMapping;
import de.jreality.toolsystem.config.ToolSystemConfiguration;
import de.jreality.toolsystem.config.VirtualConstant;
import de.jreality.toolsystem.config.VirtualDeviceConfig;
import de.jreality.toolsystem.config.VirtualMapping;
import de.jreality.toolsystem.raw.PollingDevice;
import de.jreality.toolsystem.raw.RawDevice;
import de.jreality.util.CameraUtility;
import de.jreality.util.ConfigurationAttributes;
import de.jreality.util.LoggingSystem;
import java.awt.Dimension;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceManager {
    private static final double MATRIX_EPS = 1.0E-12;
    Viewer viewer;
    private final HashMap<InputSlot, List<VirtualDevice>> slot2virtual = new HashMap();
    private final HashMap<InputSlot, AxisState> slot2axis = new HashMap();
    private final HashMap<InputSlot, DoubleArray> slot2transformation = new HashMap();
    private HashMap<InputSlot, LinkedList<InputSlot>> slots2virtualMappings = new HashMap();
    private VirtualDeviceContextImpl virtualDeviceContext = new VirtualDeviceContextImpl();
    ConfigurationAttributes toolConfig;
    private Map<String, RawDevice> rawDevices = new HashMap<String, RawDevice>();
    private final ToolEventQueue eventQueue;
    private InputSlot avatarSlot = InputSlot.getDevice("AvatarTransformation");
    private InputSlot worldToCamSlot = InputSlot.getDevice("WorldToCamera");
    private InputSlot camToNDCSlot = InputSlot.getDevice("CameraToNDC");
    private double[] avatarTrafo = new Matrix().getArray();
    private double[] worldToCamTrafo = new Matrix().getArray();
    private double[] camToNDCTrafo = new Matrix().getArray();
    HashSet<InputSlot> debugSlots = new HashSet();
    private SceneGraphPath avatarPath;
    private final HashMap<InputSlot, HashSet<InputSlot>> virtualMappingsInv = new HashMap();
    private long systemTime;

    public DeviceManager(ToolSystemConfiguration config, ToolEventQueue queue, Viewer viewer) {
        RawDevice rd;
        this.viewer = viewer;
        this.eventQueue = queue;
        for (RawDeviceConfig rawDeviceConfig : config.getRawConfigs()) {
            try {
                rd = rawDeviceConfig.createDevice();
                rd.initialize(viewer, rawDeviceConfig.getConfiguration());
                rd.setEventQueue(this.eventQueue);
                this.rawDevices.put(rawDeviceConfig.getDeviceID(), rd);
                if (rd instanceof PollingDevice) {
                    Poller.getSharedInstance().addPollingDevice((PollingDevice)((Object)rd));
                }
                LoggingSystem.getLogger(this).config("Started rawdevice " + rd);
            }
            catch (Exception e) {
                LoggingSystem.getLogger(this).info("Couldn't create RawDevice " + rawDeviceConfig);
            }
        }
        for (RawMapping rawMapping : config.getRawMappings()) {
            rd = this.rawDevices.get(rawMapping.getDeviceID());
            if (rd == null) {
                LoggingSystem.getLogger(this).info("Ignoring mapping " + rawMapping);
                continue;
            }
            try {
                ToolEvent initialValue = rd.mapRawDevice(rawMapping.getSourceSlot(), rawMapping.getTargetSlot());
                if (initialValue.getInputSlot() != rawMapping.getTargetSlot()) {
                    throw new IllegalStateException("different slot not allowed in init");
                }
                this.setTransformationMatrix(initialValue.getInputSlot(), initialValue.getTransformation());
                this.setAxisState(initialValue.getInputSlot(), initialValue.getAxisState());
                LoggingSystem.getLogger(this).config("Mapped " + rawMapping);
            }
            catch (Exception e) {
                LoggingSystem.getLogger(this).config("cannot map slot " + rawMapping);
            }
        }
        for (VirtualConstant virtualConstant : config.getVirtualConstants()) {
            this.setTransformationMatrix(virtualConstant.getSlot(), virtualConstant.getTransformationMatrix());
            this.setAxisState(virtualConstant.getSlot(), virtualConstant.getAxisState());
            LoggingSystem.getLogger(this).config("Created virtual constant: " + virtualConstant);
        }
        this.setTransformationMatrix(this.avatarSlot, new DoubleArray(this.avatarTrafo));
        this.setTransformationMatrix(this.worldToCamSlot, new DoubleArray(this.worldToCamTrafo));
        this.setTransformationMatrix(this.camToNDCSlot, new DoubleArray(this.camToNDCTrafo));
        for (VirtualDeviceConfig virtualDeviceConfig : config.getVirtualConfigs()) {
            try {
                VirtualDevice v = virtualDeviceConfig.createDevice();
                boolean firstSlot = true;
                for (InputSlot currentSlot : virtualDeviceConfig.getInSlots()) {
                    this.virtualDeviceContext.setEvent(new ToolEvent(this, this.getSystemTime(), currentSlot, this.getAxisState(currentSlot), this.getTransformationMatrix(currentSlot)));
                    ToolEvent initialValue = null;
                    try {
                        initialValue = v.process(this.virtualDeviceContext);
                        if (initialValue == null) {
                            initialValue = v.process(this.virtualDeviceContext);
                        }
                    }
                    catch (MissingSlotException me) {
                        initialValue = v.process(this.virtualDeviceContext);
                    }
                    if (initialValue != null) {
                        this.setTransformationMatrix(initialValue.getInputSlot(), initialValue.getTransformation());
                        this.setAxisState(initialValue.getInputSlot(), initialValue.getAxisState());
                        LoggingSystem.getLogger(this).fine(initialValue.toString());
                    } else if (firstSlot) {
                        throw new IllegalStateException(v + " returned null twice");
                    }
                    this.getDevicesForSlot(currentSlot).add(v);
                    firstSlot = false;
                }
            }
            catch (Exception e) {
                LoggingSystem.getLogger(this).info("Virtual device failed: " + virtualDeviceConfig);
                LoggingSystem.getLogger(this).log(Level.INFO, "error was:", e);
                continue;
            }
            LoggingSystem.getLogger(this).config("Created virtual device: " + virtualDeviceConfig);
        }
        List<VirtualMapping> mappings = config.getVirtualMappings();
        for (VirtualMapping vm : mappings) {
            this.getMappingsTargetToSources(vm.getTargetSlot()).add(vm.getSourceSlot());
        }
        for (VirtualMapping vm : mappings) {
            for (InputSlot rawSlot : this.resolveSlot(vm.getTargetSlot())) {
                this.getVirtualMappingsForSlot(rawSlot).add(vm.getTargetSlot());
                this.setTransformationMatrix(vm.getTargetSlot(), this.getTransformationMatrix(rawSlot));
                this.setAxisState(vm.getTargetSlot(), this.getAxisState(rawSlot));
                LoggingSystem.getLogger(this).fine("set value for mapped slot [" + vm.getTargetSlot() + "] from rawslot [" + rawSlot + "] to " + this.getAxisState(rawSlot) + " || " + this.getTransformationMatrix(rawSlot));
            }
        }
    }

    AxisState getAxisState(InputSlot slot) {
        return this.slot2axis.get(slot);
    }

    DoubleArray getTransformationMatrix(InputSlot slot) {
        return this.slot2transformation.get(slot);
    }

    void setAxisState(InputSlot slot, AxisState axisState) {
        this.slot2axis.put(slot, axisState);
        if (axisState != null && this.debugSlots.contains(slot)) {
            LoggingSystem.getLogger(this).fine(slot + ": " + axisState);
        }
    }

    void setTransformationMatrix(InputSlot slot, DoubleArray transformation) {
        this.slot2transformation.put(slot, transformation);
        if (transformation != null && this.debugSlots.contains(slot)) {
            LoggingSystem.getLogger(this).fine(slot + "\n" + Rn.matrixToString(transformation.toDoubleArray(null)));
        }
    }

    List<VirtualDevice> getDevicesForSlot(InputSlot slot) {
        if (!this.slot2virtual.containsKey(slot)) {
            this.slot2virtual.put(slot, new LinkedList());
        }
        return this.slot2virtual.get(slot);
    }

    List<InputSlot> getVirtualMappingsForSlot(InputSlot slot) {
        if (!this.slots2virtualMappings.containsKey(slot)) {
            this.slots2virtualMappings.put(slot, new LinkedList());
        }
        return this.slots2virtualMappings.get(slot);
    }

    void evaluateEvent(ToolEvent event, LinkedList<ToolEvent> compQueue) {
        if (event.getInputSlot() != InputSlot.getDevice("SystemTime")) {
            LoggingSystem.getLogger(this).finest("evaluating event: " + event);
        }
        InputSlot slot = event.getInputSlot();
        this.setAxisState(slot, event.getAxisState());
        this.setTransformationMatrix(slot, event.getTransformation());
        for (InputSlot mapSlot : this.getVirtualMappingsForSlot(slot)) {
            this.setAxisState(mapSlot, event.getAxisState());
            this.setTransformationMatrix(mapSlot, event.getTransformation());
        }
        this.virtualDeviceContext.setEvent(event);
        for (VirtualDevice device : this.getDevicesForSlot(slot)) {
            try {
                ToolEvent newEvent = device.process(this.virtualDeviceContext);
                if (newEvent == null) continue;
                compQueue.add(newEvent);
            }
            catch (MissingSlotException mse) {
                LoggingSystem.getLogger(this).log(Level.WARNING, "slot for virtual device missing", mse);
            }
        }
    }

    public List<ToolEvent> updateImplicitDevices() {
        boolean worldToCamChanged = false;
        boolean camToNDCChanged = false;
        boolean avatarChanged = false;
        double[] matrix = null;
        if (this.viewer.getCameraPath() != null) {
            Dimension viewingComponentSize;
            double asp;
            matrix = this.viewer.getCameraPath().getInverseMatrix(null);
            if (!Rn.equals(matrix, this.worldToCamTrafo, 1.0E-12)) {
                Rn.copy(this.worldToCamTrafo, matrix);
                worldToCamChanged = true;
            }
            matrix = this.viewer.hasViewingComponent() && this.viewer.getViewingComponentSize() != null ? (Double.isNaN(asp = (viewingComponentSize = this.viewer.getViewingComponentSize()).getWidth() / viewingComponentSize.getHeight()) ? Rn.identityMatrix(4) : CameraUtility.getCameraToNDC((Camera)this.viewer.getCameraPath().getLastElement(), asp)) : Rn.identityMatrix(4);
            if (!Rn.equals(matrix, this.camToNDCTrafo, 1.0E-12)) {
                Rn.copy(this.camToNDCTrafo, matrix);
                camToNDCChanged = true;
            }
        }
        if (this.avatarPath != null) {
            matrix = this.avatarPath.getMatrix(null);
        } else if (this.viewer.getCameraPath() != null) {
            matrix = this.viewer.getCameraPath().getMatrix(null);
        }
        if (matrix != null && !Rn.equals(matrix, this.avatarTrafo, 1.0E-12)) {
            Rn.copy(this.avatarTrafo, matrix);
            avatarChanged = true;
        }
        if (!(worldToCamChanged || camToNDCChanged || avatarChanged)) {
            return Collections.emptyList();
        }
        LinkedList<ToolEvent> ret = new LinkedList<ToolEvent>();
        if (worldToCamChanged) {
            ret.add(new ToolEvent((Object)this, this.getSystemTime(), this.worldToCamSlot, new DoubleArray(this.worldToCamTrafo)));
        }
        if (camToNDCChanged) {
            ret.add(new ToolEvent((Object)this, this.getSystemTime(), this.camToNDCSlot, new DoubleArray(this.camToNDCTrafo)));
        }
        if (avatarChanged) {
            ret.add(new ToolEvent((Object)this, this.getSystemTime(), this.avatarSlot, new DoubleArray(this.avatarTrafo)));
        }
        return ret;
    }

    void setAvatarPath(SceneGraphPath p) {
        this.avatarPath = p;
    }

    List<InputSlot> resolveSlot(InputSlot slot) {
        LinkedList<InputSlot> ret = new LinkedList<InputSlot>();
        this.findTriggerSlots(ret, slot);
        return ret;
    }

    private void findTriggerSlots(List<InputSlot> l, InputSlot slot) {
        Set<InputSlot> sources = this.getMappingsTargetToSources(slot);
        if (sources.isEmpty()) {
            l.add(slot);
            return;
        }
        for (InputSlot is : sources) {
            this.findTriggerSlots(l, is);
        }
    }

    private Set<InputSlot> getMappingsTargetToSources(InputSlot slot) {
        if (!this.virtualMappingsInv.containsKey(slot)) {
            this.virtualMappingsInv.put(slot, new HashSet());
        }
        return this.virtualMappingsInv.get(slot);
    }

    public void dispose() {
        for (Map.Entry<String, RawDevice> entry : this.rawDevices.entrySet()) {
            RawDevice rd = entry.getValue();
            LoggingSystem.getLogger(this).fine("disposing raw device [" + entry.getKey() + "]" + rd);
            if (rd instanceof PollingDevice) {
                Poller.getSharedInstance().removePollingDevice((PollingDevice)((Object)rd));
            }
            rd.dispose();
        }
        this.slot2axis.clear();
        this.slot2transformation.clear();
        this.slot2virtual.clear();
        this.slots2virtualMappings.clear();
        this.avatarPath = null;
        this.avatarTrafo = new Matrix().getArray();
        this.camToNDCTrafo = new Matrix().getArray();
        this.worldToCamTrafo = new Matrix().getArray();
    }

    public void setSystemTime(long timeStamp) {
        this.systemTime = timeStamp;
    }

    long getSystemTime() {
        return this.systemTime;
    }

    private class VirtualDeviceContextImpl
    implements VirtualDeviceContext {
        ToolEvent event;

        private VirtualDeviceContextImpl() {
        }

        public AxisState getAxisState(InputSlot slot) throws MissingSlotException {
            AxisState axisState = DeviceManager.this.getAxisState(slot);
            if (axisState == null) {
                throw new MissingSlotException(slot);
            }
            return axisState;
        }

        public DoubleArray getTransformationMatrix(InputSlot slot) throws MissingSlotException {
            DoubleArray transformationMatrix = DeviceManager.this.getTransformationMatrix(slot);
            if (transformationMatrix == null) {
                throw new MissingSlotException(slot);
            }
            return transformationMatrix;
        }

        public ToolEvent getEvent() {
            return this.event;
        }

        private void setEvent(ToolEvent event) {
            this.event = event;
        }
    }
}

