/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.geometry.Primitives;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Transformation;
import de.jreality.scene.pick.PickResult;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.tools.AnimatorTask;
import de.jreality.tools.AnimatorTool;

public class FlyToPickTool
extends AbstractTool {
    static InputSlot timerSlot = InputSlot.getDevice("SystemTime");
    static InputSlot zoomActivateSlot = InputSlot.getDevice("JumpActivation");
    static InputSlot mouseAimer = InputSlot.getDevice("PointerNDC");
    static InputSlot reverseSlot = InputSlot.getDevice("Secondary");
    private double flightTime = 1000.0;
    private double goFactor = 0.75;
    private double timeNow = 0.0;
    private SceneGraphComponent arrowNode;
    private boolean attached = false;
    private boolean reverse = false;
    private boolean fixYAxis = true;
    private double[] mousePosFirst;
    private double[] fromW4P;
    private double[] toW4P;
    private double[] axisW3V;
    private double angleW;
    double[] fromToW4V;
    double dist;
    private double[] startMatrixAvatar;
    private SceneGraphPath avaPath;
    private SceneGraphPath camPath;
    private SceneGraphComponent avaNode;
    double turnAngle;
    double[] turnAxis = new double[]{0.0, 1.0, 0.0};
    double hightAngle;
    double[] hightAxis;

    public FlyToPickTool() {
        super(zoomActivateSlot);
        this.addCurrentSlot(timerSlot);
        this.arrowNode = new SceneGraphComponent();
        this.arrowNode.setGeometry(Primitives.arrow(0.0, 0.0, 1.0, 0.0, 0.2));
        this.setDescription("type jump: fly to picked Point ");
        this.setDescription(timerSlot, "");
        this.setDescription(zoomActivateSlot, "type jump: fly to picked Point \n\rhold jump: move mouse to set destinated to fly to \n\r");
        this.setDescription(reverseSlot, "reverses the flight to zoom away");
    }

    public void activate(ToolContext tc) {
        this.avaPath = tc.getAvatarPath();
        this.avaNode = this.avaPath.getLastComponent();
        this.camPath = tc.getViewer().getCameraPath();
        AnimatorTool.getInstance(tc).deschedule(this.avaNode);
        PickResult currentPick = tc.getCurrentPick();
        if (currentPick != null) {
            this.fromW4P = Rn.matrixTimesVector(null, this.camPath.getMatrix(null), new double[]{0.0, 0.0, 0.0, 1.0});
            this.toW4P = currentPick.getWorldCoordinates();
            double[] temp = tc.getTransformationMatrix(mouseAimer).toDoubleArray(null);
            this.mousePosFirst = new double[]{temp[3], temp[7]};
            Transformation cmpTrafo = this.avaNode.getTransformation();
            if (cmpTrafo == null) {
                cmpTrafo = new Transformation();
            }
            this.startMatrixAvatar = cmpTrafo.getMatrix();
            this.arrowNode.setVisible(true);
        }
        this.assureAttached(tc);
    }

    public void deactivate(ToolContext tc) {
        this.reverse = tc.getAxisState(reverseSlot).isPressed();
        this.timeNow = 0.0;
        AnimatorTask task = new AnimatorTask(){

            public boolean run(double time, double dt) {
                FlyToPickTool.this.timeNow += dt;
                if (FlyToPickTool.this.timeNow > FlyToPickTool.this.flightTime) {
                    FlyToPickTool.this.avaNode.setTransformation(FlyToPickTool.this.getNextTrafoOfN(1.0));
                    return false;
                }
                FlyToPickTool.this.avaNode.setTransformation(FlyToPickTool.this.getNextTrafoOfN(FlyToPickTool.this.timeNow / FlyToPickTool.this.flightTime));
                return true;
            }
        };
        AnimatorTool.getInstance(tc).schedule(this.avaNode, task);
        this.arrowNode.setVisible(false);
    }

    private void assureAttached(ToolContext tc) {
        if (!this.attached) {
            tc.getViewer().getSceneRoot().addChild(this.arrowNode);
        }
        this.attached = true;
        this.arrowNode.setVisible(true);
        this.arrowNode.setAppearance(new Appearance());
        this.arrowNode.getAppearance().setAttribute("lineShader.tubeDraw", false);
    }

    private double[] toR3(double[] d) {
        return new double[]{d[0], d[1], d[2]};
    }

    public void perform(ToolContext tc) {
        double[] temp = tc.getTransformationMatrix(mouseAimer).toDoubleArray(null);
        double[] relMousePos = new double[]{this.mousePosFirst[0] - temp[3], this.mousePosFirst[1] - temp[7]};
        this.fromToW4V = Rn.subtract(null, this.fromW4P, this.toW4P);
        double[] a = this.toR3(this.toW4P);
        double[] b = this.toR3(this.fromW4P);
        this.dist = Rn.euclideanDistance(a, b) * (1.0 - this.goFactor);
        if (!this.fixYAxis) {
            this.axisW3V = new double[]{relMousePos[1], -relMousePos[0], 0.0, 0.0};
            this.axisW3V = Rn.matrixTimesVector(null, this.camPath.getMatrix(null), this.axisW3V);
            this.axisW3V = new double[]{this.axisW3V[0], this.axisW3V[1], this.axisW3V[2]};
            Rn.normalize(this.axisW3V, this.axisW3V);
            this.angleW = Rn.euclideanNorm(relMousePos) * 4.0;
            while (this.angleW > Math.PI) {
                this.angleW -= Math.PI * 2;
            }
            while (this.angleW < -Math.PI) {
                this.angleW += Math.PI * 2;
            }
            MatrixBuilder.euclidean().translate(this.toW4P).rotate(this.angleW, this.axisW3V).rotateFromTo(new double[]{1.0, 0.0, 0.0}, this.fromToW4V).scale(this.dist).assignTo(this.arrowNode);
        } else {
            this.turnAngle = -relMousePos[0] * 4.0;
            this.hightAngle = relMousePos[1] * 4.0;
            this.hightAxis = Rn.crossProduct(null, this.turnAxis, this.fromToW4V);
            Rn.normalize(this.hightAxis, this.hightAxis);
            MatrixBuilder.euclidean().translate(this.toW4P).rotate(this.turnAngle, this.turnAxis).rotate(this.hightAngle, this.hightAxis).rotateFromTo(new double[]{1.0, 0.0, 0.0}, this.fromToW4V).scale(this.dist).assignTo(this.arrowNode);
        }
    }

    private Transformation getNextTrafoOfN(double s) {
        double[] combinedMatrix;
        s = this.smothFlight(s);
        double[] toTargetMatrixW = MatrixBuilder.euclidean().translate(this.toW4P).getArray();
        double[] moveNearW4V = !this.reverse ? Rn.times(null, this.goFactor * s, Rn.subtract(null, this.toW4P, this.fromW4P)) : Rn.times(null, (1.0 - 1.0 / (1.0 - this.goFactor)) * s, Rn.subtract(null, this.toW4P, this.fromW4P));
        moveNearW4V[3] = 1.0;
        double[] translMatrixW = MatrixBuilder.euclidean().translate(moveNearW4V).getArray();
        if (!this.fixYAxis) {
            double[] rotateMatrixW = MatrixBuilder.euclidean().rotate(this.angleW * s, this.axisW3V).getArray();
            rotateMatrixW = Rn.conjugateByMatrix(null, rotateMatrixW, toTargetMatrixW);
            combinedMatrix = Rn.times(null, rotateMatrixW, translMatrixW);
            combinedMatrix = Rn.times(null, combinedMatrix, this.startMatrixAvatar);
        } else {
            double[] rotateMatrixW = MatrixBuilder.euclidean().rotate(this.turnAngle * s, this.turnAxis).getArray();
            rotateMatrixW = Rn.conjugateByMatrix(null, rotateMatrixW, toTargetMatrixW);
            double alpha = Math.acos(this.fromToW4V[1] / Rn.euclideanNorm(this.toR3(this.fromToW4V)));
            double y = this.dist * (Math.cos(this.hightAngle * s + alpha) - Math.cos(alpha));
            double z = this.dist * (Math.sin(this.hightAngle * s + alpha) - Math.sin(alpha));
            double[] moveAroundMatrixT = MatrixBuilder.euclidean().translate(0.0, y, z).getArray();
            combinedMatrix = MatrixBuilder.euclidean().getArray();
            combinedMatrix = Rn.times(null, combinedMatrix, rotateMatrixW);
            combinedMatrix = Rn.times(null, combinedMatrix, moveAroundMatrixT);
            combinedMatrix = Rn.times(null, combinedMatrix, translMatrixW);
            combinedMatrix = Rn.times(null, combinedMatrix, this.startMatrixAvatar);
        }
        return new Transformation(combinedMatrix);
    }

    private double smothFlight(double in) {
        return -Math.cos(in * Math.PI) / 2.0 + 0.5;
    }

    public String getDescription() {
        return "type jump: fly to picked Point ";
    }

    protected void setDescription(InputSlot slot, String description) {
    }

    public double getFlightTime() {
        return this.flightTime / 1000.0;
    }

    public void setFlightTime(double flightTime) {
        this.flightTime = flightTime * 1000.0;
    }

    public double getGoFactor() {
        return this.goFactor;
    }

    public void setGoFactor(double goFactor) {
        this.goFactor = goFactor;
    }

    public boolean isHoldYAxis() {
        return this.fixYAxis;
    }

    public void setHoldYAxis(boolean holdYAxis) {
        this.fixYAxis = holdYAxis;
    }
}

