/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.scene.Camera;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;

public class ClickWheelCameraZoomTool
extends AbstractTool {
    int wheel = 0;
    double speed = 1.05;

    public ClickWheelCameraZoomTool() {
        super(InputSlot.getDevice("PrimaryUp"), InputSlot.getDevice("PrimaryDown"));
    }

    public void activate(ToolContext tc) {
        if (tc.getSource() == InputSlot.getDevice("PrimaryUp")) {
            this.wheel = 1;
        } else if (tc.getSource() == InputSlot.getDevice("PrimaryDown")) {
            this.wheel = -1;
        }
        Camera cam = (Camera)tc.getViewer().getCameraPath().getLastElement();
        double fov = cam.getFieldOfView();
        cam.setFieldOfView(fov * (this.wheel > 0 ? this.speed : 1.0 / this.speed));
        tc.getViewer().renderAsync();
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }
}

