/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.shader.EffectiveAppearance;

public class AxisTranslationTool
extends AbstractTool {
    private boolean moveChildren;
    private boolean snapToGrid = true;
    private double snapToGridInterval = 1.0;
    transient boolean directionDetermined;
    transient int direction;
    transient EffectiveAppearance eap;
    private transient int metric;
    transient Matrix startMatrix = new Matrix();
    transient double dx;
    transient double dy;
    transient double dz;
    transient Matrix local2world = new Matrix();
    transient Matrix dragFrame;
    transient Matrix pointer = new Matrix();
    protected transient SceneGraphComponent comp;
    private transient boolean dragInViewDirection;
    static InputSlot activationSlot = InputSlot.getDevice("DragActivation");
    static InputSlot alongPointerSlot = InputSlot.getDevice("DragAlongViewDirection");
    static InputSlot evolutionSlot = InputSlot.getDevice("PointerEvolution");

    public AxisTranslationTool() {
        super(activationSlot);
        this.addCurrentSlot(evolutionSlot);
        this.addCurrentSlot(alongPointerSlot);
    }

    public void activate(ToolContext tc) {
        this.comp = (this.moveChildren ? tc.getRootToLocal() : tc.getRootToToolComponent()).getLastComponent();
        if (this.comp.getTransformation() == null) {
            this.comp.setTransformation(new Transformation());
        }
        try {
            this.dragInViewDirection = tc.getAxisState(alongPointerSlot).isPressed();
        }
        catch (Exception me) {
            this.dragInViewDirection = false;
        }
        if (this.eap == null || !EffectiveAppearance.matches(this.eap, tc.getRootToToolComponent())) {
            this.eap = EffectiveAppearance.create(tc.getRootToToolComponent());
        }
        this.metric = this.eap.getAttribute("metric", 0);
        this.comp.getTransformation().getMatrix(this.startMatrix.getArray());
        this.dx = 0.0;
        this.dy = 0.0;
        this.dz = 0.0;
        this.directionDetermined = false;
    }

    public void perform(ToolContext tc) {
        if (tc.getSource() == alongPointerSlot) {
            this.dragInViewDirection = tc.getAxisState(alongPointerSlot).isPressed();
            return;
        }
        Matrix evolution = new Matrix(tc.getTransformationMatrix(evolutionSlot));
        if (this.metric != 0) {
            MatrixBuilder.init(null, this.metric).translate(evolution.getColumn(3)).assignTo(evolution);
        }
        (this.moveChildren ? tc.getRootToLocal() : tc.getRootToToolComponent()).getMatrix(this.local2world.getArray());
        double[] t = evolution.getColumn(3);
        this.dx += t[0];
        this.dy += t[1];
        this.dz += t[2];
        double tx = this.dx;
        double ty = this.dy;
        double tz = this.dz;
        if (this.snapToGrid) {
            tx = this.snapToGridInterval * (double)Math.round(this.dx / this.snapToGridInterval);
            ty = this.snapToGridInterval * (double)Math.round(this.dy / this.snapToGridInterval);
            tz = this.snapToGridInterval * (double)Math.round(this.dz / this.snapToGridInterval);
        }
        double ax = Math.abs(tx);
        double ay = Math.abs(ty);
        double az = Math.abs(tz);
        if (ax > 0.0 || ay > 0.0 || az > 0.0) {
            if (!this.dragInViewDirection) {
                if (!this.directionDetermined) {
                    this.direction = 0;
                    if (ay > ax) {
                        this.direction = 1;
                    }
                    if (az > ay) {
                        this.direction = 2;
                    }
                    this.directionDetermined = true;
                }
                if (this.direction != 0) {
                    tx = 0.0;
                }
                if (this.direction != 1) {
                    ty = 0.0;
                }
                if (this.direction != 2) {
                    tz = 0.0;
                }
            }
            Matrix result = new Matrix(this.startMatrix);
            result.multiplyOnRight(this.local2world.getInverse());
            result.multiplyOnRight(MatrixBuilder.euclidean().translate(tx, ty, tz).getMatrix());
            result.multiplyOnRight(this.local2world);
            this.comp.getTransformation().setMatrix(result.getArray());
        }
    }

    public boolean getMoveChildren() {
        return this.moveChildren;
    }

    public void setMoveChildren(boolean moveChildren) {
        this.moveChildren = moveChildren;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean snapToGrid) {
        this.snapToGrid = snapToGrid;
    }

    public double getSnapToGridInterval() {
        return this.snapToGridInterval;
    }

    public void setSnapToGridInterval(double snapToGridInterval) {
        this.snapToGridInterval = snapToGridInterval;
    }
}

