/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.swing;

import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.swing.JFakeFrame;
import de.jreality.tools.ActionTool;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;

public class ScenePanel {
    private boolean inScene = true;
    private JFrame externalFrame = new JFrame();
    SceneGraphComponent rootNode = new SceneGraphComponent();
    SceneGraphComponent rackNode = new SceneGraphComponent();
    SceneGraphComponent panelNode = new SceneGraphComponent();
    Appearance app = new Appearance();
    JFakeFrame frame = new JFakeFrame();
    IndexedFaceSetFactory panel = new IndexedFaceSetFactory();
    IndexedLineSetFactory rack = new IndexedLineSetFactory();
    double[][] panelVerts = new double[][]{{-0.5, 0.0, 0.0}, {-0.5, 1.0, 0.0}, {0.5, 1.0, 0.0}, {0.5, 0.0, 0.0}};
    double[][] tcs = new double[][]{{1.0, 1.0}, {1.0, 0.0}, {0.0, 0.0}, {0.0, 1.0}};
    int[][] rackEdgeIndices = new int[][]{{4, 0}, {0, 1}, {1, 5}, {5, 4}, {0, 3}, {1, 2}, {4, 7}, {5, 6}};
    double aboveGround = 1.8;
    double belowGround = -0.2;
    double panelWidth = 1.0;
    double angle = 1.2566370614359172;
    double zOffset = -2.5;
    ActionTool myActionTool = new ActionTool("PanelActivation");
    boolean showFeet = true;

    public ScenePanel() {
        try {
            this.externalFrame.setAlwaysOnTop(true);
        }
        catch (SecurityException se) {
            // empty catch block
        }
        this.rootNode.setName("panel");
        this.panel.setVertexCount(4);
        this.panel.setFaceCount(1);
        this.panel.setVertexCoordinates(this.panelVerts);
        this.panel.setVertexTextureCoordinates(this.tcs);
        this.panel.setFaceIndices(new int[][]{{0, 1, 2, 3}});
        this.panel.setGenerateVertexNormals(true);
        this.panel.update();
        this.panelNode.setGeometry(this.panel.getIndexedFaceSet());
        Appearance panelApp = this.frame.getAppearance();
        this.panelNode.setAppearance(this.frame.getAppearance());
        this.panelNode.addTool(this.frame.getTool());
        panelApp.setAttribute("lineShader.tubeDraw", false);
        panelApp.setAttribute("lightingEnabled", false);
        panelApp.setAttribute("showPoints", false);
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ScenePanel.this.update();
            }

            public void componentShown(ComponentEvent e) {
                ScenePanel.this.update();
                ScenePanel.this.rootNode.setVisible(true);
            }

            public void componentHidden(ComponentEvent e) {
                ScenePanel.this.rootNode.setVisible(false);
            }
        });
        this.myActionTool.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScenePanel.this.toggle((ToolContext)e.getSource());
            }
        });
        this.rack.setVertexCount(8);
        this.rack.setEdgeCount(8);
        this.rack.setEdgeIndices(this.rackEdgeIndices);
        this.rackNode.setGeometry(this.rack.getIndexedLineSet());
        this.app.setAttribute("showLines", true);
        this.app.setAttribute("lineShader.tubeRadius", 0.008);
        this.app.setAttribute("pointShader.ambientCoefficient", 0.1);
        this.app.setAttribute("lineShader.ambientCoefficient", 0.1);
        this.app.setAttribute("lineShader.diffuseColor", Color.gray);
        this.app.setAttribute("pointShader.pointRadius", 0.016);
        this.app.setAttribute("pointShader.diffuseColor", Color.gray);
        this.app.setAttribute("showPoints", true);
        this.rackNode.setAppearance(this.app);
        this.rootNode.addChild(this.rackNode);
        this.rackNode.addChild(this.panelNode);
        MatrixBuilder.euclidean().rotateY(Math.PI).assignTo(this.rackNode);
        this.rootNode.setVisible(false);
    }

    public void setPanelWidth(double panelWidth) {
        this.panelWidth = panelWidth;
        this.update();
    }

    void update() {
        int width = this.frame.getWidth();
        int height = this.frame.getHeight();
        double panelHeight = this.panelWidth * (double)height / (double)width;
        this.rack.setVertexCoordinates(this.rackVerts(panelHeight));
        this.rack.update();
        MatrixBuilder.euclidean().translate(0.0, this.aboveGround - Math.sin(this.angle) * panelHeight, 0.0).rotateX(1.5707963267948966 - this.angle).scale(this.panelWidth, panelHeight, 1.0).assignTo(this.panelNode);
    }

    double[][] rackVerts(double panelHeight) {
        double cos = Math.cos(this.angle);
        double sin = Math.sin(this.angle);
        double[][] verts = new double[8][3];
        verts[0][0] = this.panelWidth / 2.0;
        verts[0][1] = this.aboveGround;
        verts[0][2] = cos * panelHeight;
        verts[1][0] = this.panelWidth / 2.0;
        verts[1][1] = this.aboveGround - sin * panelHeight;
        verts[1][2] = 0.0;
        verts[2][0] = this.panelWidth / 2.0;
        verts[2][1] = this.showFeet ? this.belowGround : this.aboveGround - sin * panelHeight;
        verts[2][2] = 0.0;
        verts[3][0] = this.panelWidth / 2.0;
        verts[3][1] = this.showFeet ? this.belowGround : this.aboveGround;
        verts[3][2] = cos * panelHeight;
        verts[4][0] = -this.panelWidth / 2.0;
        verts[4][1] = this.aboveGround;
        verts[4][2] = cos * panelHeight;
        verts[5][0] = -this.panelWidth / 2.0;
        verts[5][1] = this.aboveGround - sin * panelHeight;
        verts[5][2] = 0.0;
        verts[6][0] = -this.panelWidth / 2.0;
        verts[6][1] = this.showFeet ? this.belowGround : this.aboveGround - sin * panelHeight;
        verts[6][2] = 0.0;
        verts[7][0] = -this.panelWidth / 2.0;
        verts[7][1] = this.showFeet ? this.belowGround : this.aboveGround;
        verts[7][2] = cos * panelHeight;
        return verts;
    }

    public JFrame getFrame() {
        return this.inScene ? this.frame : this.externalFrame;
    }

    public JFrame getExternalFrame() {
        return this.externalFrame;
    }

    public SceneGraphComponent getComponent() {
        return this.rootNode;
    }

    public void show(ToolContext tc) {
        if (this.inScene) {
            Matrix avatar = new Matrix(tc.getTransformationMatrix(InputSlot.getDevice("AvatarTransformation")));
            this.show(tc.getViewer().getSceneRoot(), avatar);
        } else {
            this.externalFrame.setVisible(true);
        }
    }

    public void show(SceneGraphComponent component, Matrix avatar) {
        if (this.inScene) {
            this.setPosition(avatar);
            if (!component.isDirectAncestor(this.getComponent())) {
                component.addChild(this.getComponent());
            }
            this.frame.setVisible(true);
        } else {
            this.externalFrame.setVisible(true);
        }
    }

    public void setPosition(Matrix avatar) {
        MatrixBuilder.euclidean(avatar).translate(0.0, 0.0, this.getZOffset()).assignTo(this.rootNode);
    }

    public void hide(SceneGraphComponent cmp) {
        if (this.inScene) {
            if (cmp.isDirectAncestor(this.getComponent())) {
                cmp.removeChild(this.getComponent());
            }
            this.frame.setVisible(false);
        } else {
            this.externalFrame.setVisible(false);
        }
    }

    public void hide(ToolContext tc) {
        this.hide(tc.getViewer().getSceneRoot());
    }

    public void toggle(ToolContext tc) {
        this.toggle(tc.getViewer().getSceneRoot(), new Matrix(tc.getAvatarPath().getMatrix(null)));
    }

    public void toggle(SceneGraphComponent component, Matrix avatar) {
        if (this.inScene) {
            if (this.frame.isVisible()) {
                this.hide(component);
            } else {
                this.show(component, avatar);
            }
        } else {
            this.externalFrame.setVisible(!this.externalFrame.isVisible());
        }
    }

    public ActionTool getPanelTool() {
        return this.myActionTool;
    }

    public double getAboveGround() {
        return this.aboveGround;
    }

    public void setAboveGround(double aboveGround) {
        this.aboveGround = aboveGround;
        this.update();
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
        this.update();
    }

    public double getBelowGround() {
        return this.belowGround;
    }

    public void setBelowGround(double belowGround) {
        this.belowGround = belowGround;
        this.update();
    }

    public double getZOffset() {
        return this.zOffset;
    }

    public void setZOffset(double offset) {
        this.zOffset = offset;
    }

    public double getPanelWidth() {
        return this.panelWidth;
    }

    public boolean isShowFeet() {
        return this.showFeet;
    }

    public void setShowFeet(boolean showFeet) {
        this.showFeet = showFeet;
    }

    public void adjustHeight(double delta) {
        MatrixBuilder.euclidean(this.rootNode).translate(0.0, delta, 0.0).assignTo(this.rootNode);
    }

    public boolean isInScene() {
        return this.inScene;
    }

    public void setInScene(boolean b, SceneGraphComponent cmp, Matrix m) {
        if (this.inScene == b) {
            return;
        }
        if (b) {
            this.inScene = b;
            boolean visible = this.externalFrame.isVisible();
            this.externalFrame.setVisible(false);
            this.frame.setContentPane(this.externalFrame.getContentPane());
            this.externalFrame.remove(this.externalFrame.getContentPane());
            this.frame.pack();
            if (visible) {
                this.show(cmp, m);
            }
        } else {
            boolean visible = this.frame.isVisible();
            this.hide(cmp);
            this.inScene = b;
            this.externalFrame.setContentPane(this.frame.getContentPane());
            this.frame.remove(this.frame.getContentPane());
            this.externalFrame.pack();
            if (visible) {
                this.externalFrame.setVisible(true);
            }
        }
    }
}

