/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.swing;

import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.tool.InputSlot;
import de.jreality.swing.JFakeFrame;
import de.jreality.swing.PlanarMouseEventTool;
import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import javax.swing.JRootPane;
import javax.swing.plaf.RootPaneUI;
import javax.swing.plaf.metal.MetalRootPaneUI;

public class JFakeFrameWithGeometry
extends JFakeFrame {
    SceneGraphComponent windowComponent;
    IndexedFaceSetFactory quadFactory;
    Rectangle normalBounds;
    private static InputSlot drag0 = InputSlot.getDevice("PanelAction");
    private static InputSlot drag2 = InputSlot.getDevice("PanelSelection");
    private static InputSlot drag1 = InputSlot.getDevice("PanelMenu");
    private int desktopWidth = 800;
    private int desktopHeight = 600;
    private SceneGraphComponent windowRoot;
    private int layer;

    public JFakeFrameWithGeometry() {
    }

    public JFakeFrameWithGeometry(GraphicsConfiguration gc) {
        super(gc);
    }

    public JFakeFrameWithGeometry(String title, GraphicsConfiguration gc) {
        super(title, gc);
    }

    public JFakeFrameWithGeometry(String title) throws HeadlessException {
        super(title);
    }

    protected void init() {
        this.setRootPane(new MyRootPane());
        this.getRootPane().setWindowDecorationStyle(1);
        this.setUndecorated(true);
        this.normalBounds = new Rectangle();
        PlanarMouseEventTool leftMouseButtonTool = new PlanarMouseEventTool(drag0, 0, this);
        PlanarMouseEventTool centerMouseButtonTool = new PlanarMouseEventTool(drag1, 1, this);
        PlanarMouseEventTool rightMouseButtonTool = new PlanarMouseEventTool(drag2, 2, this);
        this.appearance = new Appearance();
        this.appearance.setAttribute("diffuseColor", Color.WHITE);
        this.appearance.setAttribute("showPoints", false);
        this.appearance.setAttribute("showLines", false);
        this.appearance.setAttribute("tubeDraw", false);
        this.appearance.setAttribute("lightingEnabled", false);
        this.appearance.setAttribute("polygonShader.reflectionMap:blendColor", new Color(255, 255, 255, 65));
        this.quadFactory = new IndexedFaceSetFactory();
        this.quadFactory.setVertexCount(4);
        this.quadFactory.setFaceCount(1);
        this.quadFactory.setGenerateFaceNormals(true);
        this.quadFactory.setFaceIndices(new int[][]{{0, 1, 2, 3}});
        this.quadFactory.setVertexTextureCoordinates(new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}});
        this.windowComponent = new SceneGraphComponent();
        this.windowComponent.setVisible(false);
        this.windowComponent.addTool(leftMouseButtonTool);
        this.windowComponent.addTool(centerMouseButtonTool);
        this.windowComponent.addTool(rightMouseButtonTool);
        this.windowComponent.setAppearance(this.getAppearance());
        this.windowComponent.setGeometry(this.quadFactory.getGeometry());
        this.setBounds(this.getBounds());
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (this.windowComponent != null) {
            if (this.getExtendedState() == 0) {
                this.normalBounds.setBounds(x, y, w, h);
            }
            MatrixBuilder.euclidean().translate(x, y, -this.layer).assignTo(this.windowComponent);
            double[][] loc = new double[][]{{0.0, 0.0, 0.0}, {w, 0.0, 0.0}, {w, h, 0.0}, {0.0, h, 0.0}};
            this.quadFactory.setVertexCoordinates(loc);
            this.quadFactory.update();
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (this.windowComponent != null) {
            this.windowComponent.setVisible(b);
        }
    }

    public SceneGraphComponent getSceneGraphComponent() {
        return this.windowComponent;
    }

    public synchronized void setExtendedState(int state) {
        if ((state & 1) != 0) {
            System.out.println("iconified not (yet) supported...");
            return;
        }
        super.setExtendedState(state);
        if ((state & 6) != 0) {
            this.setBounds(0, 0, this.desktopWidth, this.desktopHeight);
        } else {
            Rectangle obds;
            if ((state & 2) != 0) {
                obds = this.getBounds();
                this.setBounds(0, obds.y, 800, obds.width);
            }
            if ((state & 4) != 0) {
                obds = this.getBounds();
                this.setBounds(obds.x, 0, obds.height, 600);
            }
        }
        if (state == 0) {
            this.setBounds(this.normalBounds);
        }
        this.invalidate();
        this.validate();
    }

    public int getDesktopWidth() {
        return this.desktopWidth;
    }

    public void setDesktopWidth(int desktopWidth) {
        this.desktopWidth = desktopWidth;
    }

    public int getDesktopHeight() {
        return this.desktopHeight;
    }

    public void setDesktopHeight(int desktopHeight) {
        this.desktopHeight = desktopHeight;
    }

    public void setDesktopComponent(SceneGraphComponent windowRoot) {
        this.windowRoot = windowRoot;
        windowRoot.addChild(this.getSceneGraphComponent());
    }

    public void dispose() {
        this.windowRoot.removeChild(this.getSceneGraphComponent());
        super.dispose();
    }

    public void setLayer(int layer) {
        this.layer = layer;
        if (this.windowComponent != null) {
            Rectangle bds = this.getBounds();
            double x = bds.x;
            double y = bds.y;
            MatrixBuilder.euclidean().translate(x, y, -layer).assignTo(this.windowComponent);
        }
    }

    private class MyRootPane
    extends JRootPane {
        private static final long serialVersionUID = 1L;
        private RootPaneUI rootPaneUI = new MetalRootPaneUI();

        public MyRootPane() {
            this.setUI(this.rootPaneUI);
        }

        public RootPaneUI getUI() {
            return this.rootPaneUI;
        }
    }
}

