/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.swing;

import de.jreality.scene.Appearance;
import de.jreality.shader.ImageData;
import de.jreality.shader.Texture2D;
import de.jreality.shader.TextureUtility;
import de.jreality.swing.FakeFramePeer;
import de.jreality.swing.FakeToolKit;
import de.jreality.swing.MouseEventTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;

public class JFakeFrame
extends JFrame {
    private static final long serialVersionUID = 3258688793266958393L;
    MouseEventTool tool;
    BufferedImage bufferedImage;
    private Graphics2D graphics;
    Component current = null;
    Appearance appearance;
    private Texture2D tex;
    private String praefix = "polygonShader";
    private boolean mute = false;

    public JFakeFrame() throws HeadlessException {
        this.init();
    }

    public JFakeFrame(GraphicsConfiguration gc) {
        super(gc);
        this.init();
    }

    public JFakeFrame(String title) throws HeadlessException {
        super(title);
        this.init();
    }

    public JFakeFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.init();
    }

    protected void init() {
        this.tool = new MouseEventTool(this);
        this.appearance = new Appearance();
        this.appearance.setAttribute("diffuseColor", Color.WHITE);
        this.appearance.setAttribute("showPoints", false);
        this.appearance.setAttribute("showLines", false);
        this.appearance.setAttribute("tubeDraw", false);
    }

    public void addNotify() {
        super.addNotify();
        ((FakeFramePeer)((Object)this.getPeer())).setRepaintAction(new Runnable(){

            public void run() {
                JFakeFrame.this.fire();
            }
        });
    }

    private void fire() {
        if (this.isMute()) {
            return;
        }
        FakeFramePeer peer = (FakeFramePeer)((Object)this.getPeer());
        if (peer != null) {
            this.bufferedImage = peer.getRootImage();
            this.graphics = this.bufferedImage.createGraphics();
            if (this.tool != null) {
                this.tool.setSize(this.getWidth(), this.getHeight());
            }
            if (this.graphics != null) {
                this.graphics.setColor(this.getBackground());
                this.graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.paint(this.graphics);
                ImageData img = new ImageData(this.bufferedImage);
                if (this.appearance != null) {
                    if (this.tex == null) {
                        this.tex = TextureUtility.createTexture(this.appearance, this.praefix, img);
                        this.tex.setMipmapMode(false);
                        this.tex.setMinFilter(9728);
                        this.tex.setMagFilter(9728);
                    } else {
                        this.tex.setImage(img);
                    }
                }
            }
        }
    }

    public MouseEventTool getTool() {
        return this.tool;
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    public Toolkit getToolkit() {
        return FakeToolKit.getDefaultToolkit();
    }

    public boolean isMute() {
        return this.mute;
    }

    public void setMute(boolean mute) {
        this.mute = mute;
        this.fire();
    }

    protected synchronized void fireComponentResized() {
        ComponentEvent ce = new ComponentEvent(this, 0);
        for (ComponentListener l : this.getComponentListeners()) {
            l.componentResized(ce);
        }
    }
}

