/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.sunflow.core.camera;

import org.sunflow.SunflowAPI;
import org.sunflow.core.CameraLens;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;

public class OrthogonalLens
implements CameraLens {
    private float au;
    private float av;
    private float aspect = 1.0f;
    private float fov = 90.0f;
    private float focus = 3.0f;

    public OrthogonalLens() {
        this.update();
    }

    public boolean update(ParameterList pl, SunflowAPI api) {
        this.fov = pl.getFloat("fov", this.fov);
        this.aspect = pl.getFloat("aspect", this.aspect);
        this.focus = pl.getFloat("focus", this.focus);
        this.update();
        return true;
    }

    private void update() {
        this.au = (float)Math.tan(Math.toRadians(this.fov * 0.5f));
        this.av = this.au / this.aspect;
    }

    public Ray getRay(float x, float y, int imageWidth, int imageHeight, double lensX, double lensY, double time) {
        x = -this.au + 2.0f * this.au * x / ((float)imageWidth - 1.0f);
        y = -this.av + 2.0f * this.av * y / ((float)imageHeight - 1.0f);
        return new Ray(x * this.focus, y * this.focus, 0.0f, 0.0f, 0.0f, -1.0f);
    }
}

