/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.sunflow;

import java.awt.Color;
import org.sunflow.core.ParameterList;
import org.sunflow.image.ChromaticitySpectrum;
import org.sunflow.image.ConstantSpectralCurve;
import org.sunflow.image.IrregularSpectralCurve;
import org.sunflow.image.RGBSpace;
import org.sunflow.image.RegularSpectralCurve;
import org.sunflow.image.SpectralCurve;
import org.sunflow.image.XYZColor;
import org.sunflow.math.MathUtils;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Vector3;

public class SkyLight {
    private OrthoNormalBasis basis;
    private float scalingFactor = 2.5E-4f;
    private Vector3 sunDirWorld;
    private float turbidity = 6.0f;
    private Vector3 sunDir;
    private SpectralCurve sunSpectralRadiance;
    private org.sunflow.image.Color sunColor;
    private float sunTheta;
    private double zenithY;
    private double zenithx;
    private double zenithy;
    private final double[] perezY = new double[5];
    private final double[] perezx = new double[5];
    private final double[] perezy = new double[5];
    private int downColor = new Color(36, 36, 36).getRGB();
    private float threshold;
    private static final float[] solAmplitudes = new float[]{165.5f, 162.3f, 211.2f, 258.8f, 258.2f, 242.3f, 267.6f, 296.6f, 305.4f, 300.6f, 306.6f, 288.3f, 287.1f, 278.2f, 271.0f, 272.3f, 263.6f, 255.0f, 250.6f, 253.1f, 253.5f, 251.3f, 246.3f, 241.7f, 236.8f, 232.1f, 228.2f, 223.4f, 219.7f, 215.3f, 211.0f, 207.3f, 202.4f, 198.7f, 194.3f, 190.7f, 186.3f, 182.6f};
    private static final RegularSpectralCurve solCurve = new RegularSpectralCurve(solAmplitudes, 380.0f, 750.0f);
    private static final float[] k_oWavelengths = new float[]{300.0f, 305.0f, 310.0f, 315.0f, 320.0f, 325.0f, 330.0f, 335.0f, 340.0f, 345.0f, 350.0f, 355.0f, 445.0f, 450.0f, 455.0f, 460.0f, 465.0f, 470.0f, 475.0f, 480.0f, 485.0f, 490.0f, 495.0f, 500.0f, 505.0f, 510.0f, 515.0f, 520.0f, 525.0f, 530.0f, 535.0f, 540.0f, 545.0f, 550.0f, 555.0f, 560.0f, 565.0f, 570.0f, 575.0f, 580.0f, 585.0f, 590.0f, 595.0f, 600.0f, 605.0f, 610.0f, 620.0f, 630.0f, 640.0f, 650.0f, 660.0f, 670.0f, 680.0f, 690.0f, 700.0f, 710.0f, 720.0f, 730.0f, 740.0f, 750.0f, 760.0f, 770.0f, 780.0f, 790.0f};
    private static final float[] k_oAmplitudes = new float[]{10.0f, 4.8f, 2.7f, 1.35f, 0.8f, 0.38f, 0.16f, 0.075f, 0.04f, 0.019f, 0.007f, 0.0f, 0.003f, 0.003f, 0.004f, 0.006f, 0.008f, 0.009f, 0.012f, 0.014f, 0.017f, 0.021f, 0.025f, 0.03f, 0.035f, 0.04f, 0.045f, 0.048f, 0.057f, 0.063f, 0.07f, 0.075f, 0.08f, 0.085f, 0.095f, 0.103f, 0.11f, 0.12f, 0.122f, 0.12f, 0.118f, 0.115f, 0.12f, 0.125f, 0.13f, 0.12f, 0.105f, 0.09f, 0.079f, 0.067f, 0.057f, 0.048f, 0.036f, 0.028f, 0.023f, 0.018f, 0.014f, 0.011f, 0.01f, 0.009f, 0.007f, 0.004f, 0.0f, 0.0f};
    private static final float[] k_gWavelengths = new float[]{759.0f, 760.0f, 770.0f, 771.0f};
    private static final float[] k_gAmplitudes = new float[]{0.0f, 3.0f, 0.21f, 0.0f};
    private static final float[] k_waWavelengths = new float[]{689.0f, 690.0f, 700.0f, 710.0f, 720.0f, 730.0f, 740.0f, 750.0f, 760.0f, 770.0f, 780.0f, 790.0f, 800.0f};
    private static final float[] k_waAmplitudes = new float[]{0.0f, 0.016f, 0.024f, 0.0125f, 1.0f, 0.87f, 0.061f, 0.001f, 1.0E-5f, 1.0E-5f, 6.0E-4f, 0.0175f, 0.036f};
    private static final IrregularSpectralCurve k_oCurve = new IrregularSpectralCurve(k_oWavelengths, k_oAmplitudes);
    private static final IrregularSpectralCurve k_gCurve = new IrregularSpectralCurve(k_gWavelengths, k_gAmplitudes);
    private static final IrregularSpectralCurve k_waCurve = new IrregularSpectralCurve(k_waWavelengths, k_waAmplitudes);

    public SkyLight() {
        this.sunDirWorld = new Vector3(1.0f, 0.01f, 0.5f);
        this.basis = OrthoNormalBasis.makeFromWV((Vector3)new Vector3(0.0f, 1.0f, 0.0f), (Vector3)new Vector3(1.0f, 0.0f, 0.0f));
        this.initSunSky();
    }

    private SpectralCurve computeAttenuatedSunlight(float theta, float turbidity) {
        float[] data = new float[91];
        double alpha = 1.3;
        double lozone = 0.35;
        double w = 2.0;
        double beta = 0.0460836582205 * (double)turbidity - 0.04586025928522;
        double m = 1.0 / (Math.cos(theta) + 0.15 * Math.pow(93.885 - (double)theta / Math.PI * 180.0, -1.253));
        int i = 0;
        for (int lambda = 350; lambda <= 800; lambda += 5) {
            double tauR = Math.exp(-m * 0.008735 * Math.pow((double)lambda / 1000.0, -4.08));
            double tauA = Math.exp(-m * beta * Math.pow((double)lambda / 1000.0, -1.3));
            double tauO = Math.exp(-m * (double)k_oCurve.sample((float)lambda) * 0.35);
            double tauG = Math.exp(-1.41 * (double)k_gCurve.sample((float)lambda) * m / Math.pow(1.0 + 118.93 * (double)k_gCurve.sample((float)lambda) * m, 0.45));
            double tauWA = Math.exp(-0.2385 * (double)k_waCurve.sample((float)lambda) * 2.0 * m / Math.pow(1.0 + 20.07 * (double)k_waCurve.sample((float)lambda) * 2.0 * m, 0.45));
            double amp = 100.0 * (double)solCurve.sample((float)lambda) * tauR * tauA * tauO * tauG * tauWA;
            data[i] = (float)amp;
            ++i;
        }
        return new RegularSpectralCurve(data, 350.0f, 800.0f);
    }

    private double perezFunction(double[] lam, double theta, double gamma, double lvz) {
        double den = (1.0 + lam[0] * Math.exp(lam[1])) * (1.0 + lam[2] * Math.exp(lam[3] * (double)this.sunTheta) + lam[4] * Math.cos(this.sunTheta) * Math.cos(this.sunTheta));
        double num = (1.0 + lam[0] * Math.exp(lam[1] / Math.cos(theta))) * (1.0 + lam[2] * Math.exp(lam[3] * gamma) + lam[4] * Math.cos(gamma) * Math.cos(gamma));
        return lvz * num / den;
    }

    private void initSunSky() {
        this.sunDirWorld.normalize();
        this.sunDir = this.basis.untransform(this.sunDirWorld, new Vector3());
        this.sunDir.normalize();
        this.sunTheta = (float)Math.acos(MathUtils.clamp((float)this.sunDir.z, (float)-1.0f, (float)1.0f));
        if (this.sunDir.z > 0.0f) {
            this.sunSpectralRadiance = this.computeAttenuatedSunlight(this.sunTheta, this.turbidity);
            this.sunColor = RGBSpace.SRGB.convertXYZtoRGB(this.sunSpectralRadiance.toXYZ()).constrainRGB();
        } else {
            this.sunSpectralRadiance = new ConstantSpectralCurve(0.0f);
            this.sunColor = org.sunflow.image.Color.BLACK;
            System.out.println("Sun is below the horizon!");
        }
        float theta2 = this.sunTheta * this.sunTheta;
        float theta3 = this.sunTheta * theta2;
        float T = this.turbidity;
        float T2 = this.turbidity * this.turbidity;
        double chi = (0.4444444444444444 - (double)T / 120.0) * (Math.PI - 2.0 * (double)this.sunTheta);
        this.zenithY = (4.0453 * (double)T - 4.971) * Math.tan(chi) - 0.2155 * (double)T + 2.4192;
        this.zenithY *= 1000.0;
        this.zenithx = (0.00165 * (double)theta3 - 0.00374 * (double)theta2 + 0.00208 * (double)this.sunTheta + 0.0) * (double)T2 + (-0.02902 * (double)theta3 + 0.06377 * (double)theta2 - 0.03202 * (double)this.sunTheta + 0.00394) * (double)T + (0.11693 * (double)theta3 - 0.21196 * (double)theta2 + 0.06052 * (double)this.sunTheta + 0.25885);
        this.zenithy = (0.00275 * (double)theta3 - 0.0061 * (double)theta2 + 0.00316 * (double)this.sunTheta + 0.0) * (double)T2 + (-0.04212 * (double)theta3 + 0.0897 * (double)theta2 - 0.04153 * (double)this.sunTheta + 0.00515) * (double)T + (0.15346 * (double)theta3 - 0.26756 * (double)theta2 + 0.06669 * (double)this.sunTheta + 0.26688);
        this.perezY[0] = 0.17872 * (double)T - 1.46303;
        this.perezY[1] = -0.3554 * (double)T + 0.42749;
        this.perezY[2] = -0.02266 * (double)T + 5.32505;
        this.perezY[3] = 0.12064 * (double)T - 2.57705;
        this.perezY[4] = -0.06696 * (double)T + 0.37027;
        this.perezx[0] = -0.01925 * (double)T - 0.25922;
        this.perezx[1] = -0.06651 * (double)T + 8.1E-4;
        this.perezx[2] = -4.1E-4 * (double)T + 0.21247;
        this.perezx[3] = -0.06409 * (double)T - 0.89887;
        this.perezx[4] = -0.00325 * (double)T + 0.04517;
        this.perezy[0] = -0.01669 * (double)T - 0.26078;
        this.perezy[1] = -0.09495 * (double)T + 0.00921;
        this.perezy[2] = -0.00792 * (double)T + 0.21023;
        this.perezy[3] = -0.04405 * (double)T - 1.65369;
        this.perezy[4] = -0.01092 * (double)T + 0.05291;
    }

    public boolean update(ParameterList pl) {
        Vector3 up = pl.getVector("up", null);
        Vector3 east = pl.getVector("east", null);
        if (up != null && east != null) {
            this.basis = OrthoNormalBasis.makeFromWV((Vector3)up, (Vector3)east);
        } else if (up != null) {
            this.basis = OrthoNormalBasis.makeFromW((Vector3)up);
        }
        this.sunDirWorld = pl.getVector("sundir", this.sunDirWorld);
        this.turbidity = pl.getFloat("turbidity", this.turbidity);
        this.initSunSky();
        return true;
    }

    private org.sunflow.image.Color getSkyRGB(Vector3 dir) {
        dir = this.basis.untransform(dir, new Vector3());
        if (dir.z < -this.threshold) {
            return org.sunflow.image.Color.BLACK;
        }
        if (dir.z < 0.001f) {
            dir.z = 0.001f;
        }
        dir.normalize();
        double theta = Math.acos(MathUtils.clamp((float)dir.z, (float)-1.0f, (float)1.0f));
        double gamma = Math.acos(MathUtils.clamp((float)Vector3.dot((Vector3)dir, (Vector3)this.sunDir), (float)-1.0f, (float)1.0f));
        double x = this.perezFunction(this.perezx, theta, gamma, this.zenithx);
        double y = this.perezFunction(this.perezy, theta, gamma, this.zenithy);
        double Y = this.perezFunction(this.perezY, theta, gamma, this.zenithY);
        XYZColor c = new ChromaticitySpectrum((float)x, (float)y).toXYZ();
        float X = (float)((double)c.getX() * Y / (double)c.getY());
        float Z = (float)((double)c.getZ() * Y / (double)c.getY());
        return RGBSpace.SRGB.convertXYZtoRGB(X, (float)Y, Z);
    }

    public int getRadiance(double dirX, double dirY, double dirZ) {
        org.sunflow.image.Color c = this.getSkyRGB(new Vector3((float)dirX, (float)dirY, (float)dirZ));
        c.mul(this.scalingFactor / 4.0f);
        return c.constrainRGB().toNonLinear().toRGB();
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public int getDownColor() {
        return this.downColor;
    }

    public void setDownColor(int downColor) {
        this.downColor = downColor;
    }

    public org.sunflow.image.Color getSunColor() {
        return this.sunColor;
    }
}

