/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.sunflow;

import java.io.Serializable;
import java.util.prefs.Preferences;

public class RenderOptions
implements Serializable {
    private boolean progressiveRender = true;
    private boolean threadsLowPriority = false;
    private double ambientOcclusionBright = 0.2f;
    private int aaMin = -2;
    private int aaMax = 0;
    private double contrastThreshold = 0.1;
    private int ambientOcclusionSamples = 16;
    private int depthsDiffuse = 1;
    private int depthsReflection = 2;
    private int depthsRefraction = 2;
    private String giEngine = "ambocc";
    private String filter = "gaussian";
    private int causticsEmit = 0;
    private int causticsGather = 50;
    private double causticsRadius = 0.5;
    private double causticsFilter = 1.1;
    private String shaderOverride;

    public int getCausticsGather() {
        return this.causticsGather;
    }

    public void setCausticsGather(int causticGather) {
        this.causticsGather = causticGather;
    }

    public int getCausticsEmit() {
        return this.causticsEmit;
    }

    public void setCausticsEmit(int causticPhotons) {
        this.causticsEmit = causticPhotons;
    }

    public double getCausticsRadius() {
        return this.causticsRadius;
    }

    public void setCausticsRadius(double causticRadius) {
        this.causticsRadius = causticRadius;
    }

    public String getShaderOverride() {
        return this.shaderOverride;
    }

    public void setShaderOverride(String shaderOverride) {
        this.shaderOverride = shaderOverride;
    }

    public int getAaMax() {
        return this.aaMax;
    }

    public void setAaMax(int aaMax) {
        this.aaMax = aaMax;
    }

    public int getAaMin() {
        return this.aaMin;
    }

    public void setAaMin(int aaMin) {
        this.aaMin = aaMin;
    }

    public int getDepthsDiffuse() {
        return this.depthsDiffuse;
    }

    public void setDepthsDiffuse(int depthsDiffuse) {
        this.depthsDiffuse = depthsDiffuse;
    }

    public int getDepthsReflection() {
        return this.depthsReflection;
    }

    public void setDepthsReflection(int depthsReflection) {
        this.depthsReflection = depthsReflection;
    }

    public int getDepthsRefraction() {
        return this.depthsRefraction;
    }

    public void setDepthsRefraction(int depthsRefraction) {
        this.depthsRefraction = depthsRefraction;
    }

    public double getAmbientOcclusionBright() {
        return this.ambientOcclusionBright;
    }

    public void setAmbientOcclusionBright(double globalIllumination) {
        this.ambientOcclusionBright = globalIllumination;
    }

    public int getAmbientOcclusionSamples() {
        return this.ambientOcclusionSamples;
    }

    public void setAmbientOcclusionSamples(int aaSamples) {
        this.ambientOcclusionSamples = aaSamples;
    }

    public boolean isProgressiveRender() {
        return this.progressiveRender;
    }

    public void setProgressiveRender(boolean progressiveRender) {
        this.progressiveRender = progressiveRender;
    }

    public void savePreferences(Preferences prefs, String prefix) {
        prefs.put(prefix + "giEngine", this.giEngine);
        prefs.put(prefix + "filter", this.filter);
        prefs.putBoolean(prefix + "progressiveRender", this.progressiveRender);
        prefs.putInt(prefix + "aaMin", this.aaMin);
        prefs.putInt(prefix + "aaMax", this.aaMax);
        prefs.putInt(prefix + "depthsDiffuse", this.depthsDiffuse);
        prefs.putInt(prefix + "depthsReflection", this.depthsReflection);
        prefs.putInt(prefix + "depthsRefraction", this.depthsRefraction);
        prefs.putInt(prefix + "ambientOcclusionSamples", this.ambientOcclusionSamples);
        prefs.putDouble(prefix + "ambientOcclusionBright", this.ambientOcclusionBright);
        prefs.putInt(prefix + "causticsEmit", this.causticsEmit);
        prefs.putInt(prefix + "causticsGather", this.causticsGather);
        prefs.putDouble(prefix + "causticsRadius", this.causticsRadius);
        prefs.putDouble(prefix + "causticsFilter", this.causticsFilter);
    }

    public void restoreFromPreferences(Preferences prefs, String prefix, RenderOptions defaults) {
        this.setProgressiveRender(prefs.getBoolean(prefix + "progressiveRender", defaults.isProgressiveRender()));
        this.setAaMin(prefs.getInt(prefix + "aaMin", defaults.getAaMin()));
        this.setAaMax(prefs.getInt(prefix + "aaMax", defaults.getAaMax()));
        this.setDepthsDiffuse(prefs.getInt(prefix + "depthsDiffuse", defaults.getDepthsDiffuse()));
        this.setDepthsReflection(prefs.getInt(prefix + "depthsReflection", defaults.getDepthsReflection()));
        this.setDepthsRefraction(prefs.getInt(prefix + "depthsRefraction", defaults.getDepthsRefraction()));
        this.setAmbientOcclusionSamples(prefs.getInt(prefix + "ambientOcclusionSamples", defaults.getAmbientOcclusionSamples()));
        this.setAmbientOcclusionBright(prefs.getDouble(prefix + "ambientOcclusionBright", defaults.getAmbientOcclusionBright()));
        this.setGiEngine(prefs.get(prefix + "giEngine", defaults.getGiEngine()));
        this.setGiEngine(prefs.get(prefix + "filter", defaults.getFilter()));
        this.setCausticsEmit(prefs.getInt(prefix + "causticsEmit", defaults.getCausticsEmit()));
        this.setCausticsGather(prefs.getInt(prefix + "causticsGather", defaults.getCausticsGather()));
        this.setCausticsRadius(prefs.getDouble(prefix + "causticsRadius", defaults.getCausticsRadius()));
        this.setCausticsFilter(prefs.getDouble(prefix + "causticsFilter", defaults.getCausticsFilter()));
    }

    public boolean isThreadsLowPriority() {
        return this.threadsLowPriority;
    }

    public void setThreadsLowPriority(boolean threadsLowPriority) {
        this.threadsLowPriority = threadsLowPriority;
    }

    public String getGiEngine() {
        return this.giEngine;
    }

    public void setGiEngine(String giEngine) {
        this.giEngine = giEngine;
    }

    public double getCausticsFilter() {
        return this.causticsFilter;
    }

    public void setCausticsFilter(double causticFilter) {
        this.causticsFilter = causticFilter;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public double getContrastThreshold() {
        return this.contrastThreshold;
    }

    public void setContrastThreshold(double contrastThreshold) {
        this.contrastThreshold = contrastThreshold;
    }
}

