/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer;

public class VecMat {
    public static final void vecAssign(double[] to, double[] from) {
        to[0] = from[0];
        to[1] = from[1];
        to[2] = from[2];
    }

    public static final void vecAssignPlus(double[] to, double x, double y, double z) {
        to[0] = to[0] + x;
        to[1] = to[1] + y;
        to[2] = to[2] + z;
    }

    public static final void vecAssignPlus(double[] to, double[] a) {
        to[0] = to[0] + a[0];
        to[1] = to[1] + a[1];
        to[2] = to[2] + a[2];
    }

    public static final void vecAssignPlus(float[] to, float[] a) {
        to[0] = to[0] + a[0];
        to[1] = to[1] + a[1];
        to[2] = to[2] + a[2];
    }

    public static final void vecAssignMinus(double[] to, double[] a) {
        to[0] = to[0] - a[0];
        to[1] = to[1] - a[1];
        to[2] = to[2] - a[2];
    }

    public static final void vecAssignMinus(double[] to, double x, double y, double z) {
        to[0] = to[0] - x;
        to[1] = to[1] - y;
        to[2] = to[2] - z;
    }

    public static final void vecArrayToArray(double[][] v, double[] l) {
        int n = v[0].length;
        int k = v.length;
        for (int i = 0; i < k; ++i) {
            double[] d = v[i];
            int p = n * i;
            for (int j = 0; j < n; ++j) {
                l[p + j] = d[j];
            }
        }
    }

    public static final void arrayToVecArray(double[] l, double[][] v) {
        int n = v[0].length;
        int k = v.length;
        for (int i = 0; i < k; ++i) {
            double[] d = v[i];
            int p = i * n;
            for (int j = 0; j < n; ++j) {
                d[j] = l[p + j];
            }
        }
    }

    public static final void transform(double[] m, double x, double y, double z, double[] v) {
        for (int j = 0; j < 3; ++j) {
            v[j] = m[j * 4 + 0] * x + m[j * 4 + 1] * y + m[j * 4 + 2] * z + m[j * 4 + 3];
        }
    }

    public static final void transform(double[] m, double x, double y, double z, double[] v, int s) {
        for (int j = 0; j < 3; ++j) {
            v[j + s] = m[j * 4 + 0] * x + m[j * 4 + 1] * y + m[j * 4 + 2] * z + m[j * 4 + 3];
        }
    }

    public static final void transform(double[] m, double x, double y, double z, double w, double[] v) {
        for (int j = 0; j < 4; ++j) {
            v[j] = m[j * 4 + 0] * x + m[j * 4 + 1] * y + m[j * 4 + 2] * z + m[j * 4 + 3] * w;
        }
    }

    public static final void transform(double[] m, double x, double y, double z, double w, double[] v, int s) {
        for (int j = 0; j < 4; ++j) {
            v[j + s] = m[j * 4 + 0] * x + m[j * 4 + 1] * y + m[j * 4 + 2] * z + m[j * 4 + 3] * w;
        }
    }

    public static final void transformNormal(double[] m, double x, double y, double z, double[] v) {
        for (int j = 0; j < 3; ++j) {
            v[j] = m[j * 4 + 0] * x + m[j * 4 + 1] * y + m[j * 4 + 2] * z;
        }
        VecMat.normalize(v);
    }

    public static final void transformUnNormalized(double[] m, double x, double y, double z, double[] v) {
        for (int j = 0; j < 3; ++j) {
            v[j] = m[j * 4 + 0] * x + m[j * 4 + 1] * y + m[j * 4 + 2] * z;
        }
    }

    public static final void transformUnNormalized(double[] m, double x, double y, double z, double[] v, int s) {
        for (int j = 0; j < 3; ++j) {
            v[j + s] = m[j * 4 + 0] * x + m[j * 4 + 1] * y + m[j * 4 + 2] * z;
        }
    }

    public static final void transformNormal(double[] m, double x, double y, double z, double[] v, int s) {
        for (int j = 0; j < 3; ++j) {
            v[j + s] = m[j * 4 + 0] * x + m[j * 4 + 1] * y + m[j * 4 + 2] * z;
        }
        VecMat.normalize(v, s);
    }

    public static void assignIdentity(double[] m) {
        m[14] = 0.0;
        m[13] = 0.0;
        m[12] = 0.0;
        m[11] = 0.0;
        m[9] = 0.0;
        m[8] = 0.0;
        m[7] = 0.0;
        m[6] = 0.0;
        m[4] = 0.0;
        m[3] = 0.0;
        m[2] = 0.0;
        m[1] = 0.0;
        m[15] = 1.0;
        m[10] = 1.0;
        m[5] = 1.0;
        m[0] = 1.0;
    }

    public static final void cross(double[] a, double[] b, double[] axb) {
        axb[0] = a[1] * b[2] - a[2] * b[1];
        axb[1] = a[2] * b[0] - a[0] * b[2];
        axb[2] = a[0] * b[1] - a[1] * b[0];
    }

    public static final double dot(double[] a, double[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    public static final double dot(double[] a, int ai, double[] b, int bi) {
        return a[ai] * b[bi] + a[ai + 1] * b[bi + 1] + a[ai + 2] * b[bi + 2];
    }

    public static final void multiply(double[] a, double q) {
        a[0] = a[0] * q;
        a[1] = a[1] * q;
        a[2] = a[2] * q;
    }

    public static final double[] product(double[] a, double q) {
        return new double[]{q * a[0], q * a[1], q * a[2]};
    }

    public static final double[] sum(double[] a, double[] b) {
        return new double[]{a[0] + b[0], a[1] + b[1], a[2] + b[2]};
    }

    public static final double[] difference(double[] a, double[] b) {
        return new double[]{a[0] - b[0], a[1] - b[1], a[2] - b[2]};
    }

    public static final double[] difference(double[] a, int ia, double[] b, int ib) {
        return new double[]{a[ia] - b[ib], a[ia + 1] - b[ib + 1], a[ia + 2] - b[ib + 2]};
    }

    public static final double[] crossproduct(double[] a, double[] b) {
        double[] axb = new double[3];
        VecMat.cross(a, b, axb);
        return axb;
    }

    public static final float norm(float[] v) {
        return (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    }

    public static final double norm(double[] v) {
        return Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    }

    public static final void cross(double[] a, double[] b, float[] axb) {
        axb[0] = (float)(a[1] * b[2] - a[2] * b[1]);
        axb[1] = (float)(a[2] * b[0] - a[0] * b[2]);
        axb[2] = (float)(a[0] * b[1] - a[1] * b[0]);
    }

    public static final void normalize(double[] v) {
        double a = v[0];
        double b = v[1];
        double c = v[2];
        double n = Math.sqrt(a * a + b * b + c * c);
        if (n == 0.0) {
            return;
        }
        v[0] = a / n;
        v[1] = b / n;
        v[2] = c / n;
    }

    public static final void normalize(double[] v, int i) {
        double a = v[i];
        double b = v[i + 1];
        double c = v[i + 2];
        double n = Math.sqrt(a * a + b * b + c * c);
        if (n == 0.0) {
            return;
        }
        v[i] = a / n;
        v[i + 1] = b / n;
        v[i + 2] = c / n;
    }

    public static final void normalize(float[] v) {
        float n = (float)Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
        v[0] = v[0] / n;
        v[1] = v[1] / n;
        v[2] = v[2] / n;
    }

    public static final void multiply(double[] l, double[] r, double[] dst) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double sum = 0.0;
                for (int k = 0; k < 4; ++k) {
                    sum += l[i * 4 + k] * r[k * 4 + j];
                }
                dst[i * 4 + j] = sum;
            }
        }
    }

    public static final void copyMatrix(double[] a, double[] b) {
        for (int ix = 0; ix < 16; ++ix) {
            b[ix] = a[ix];
        }
    }

    public static final void multiplyFromRight(double[] m, double[] t) {
        double[] tmp = new double[16];
        VecMat.copyMatrix(m, tmp);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double sum = 0.0;
                for (int k = 0; k < 4; ++k) {
                    sum += tmp[i * 4 + k] * t[k * 4 + j];
                }
                m[i * 4 + j] = sum;
            }
        }
    }

    public static final void multiplyFromLeft(double[] m, double[] t) {
        double[] tmp = new double[16];
        VecMat.copyMatrix(m, tmp);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double sum = 0.0;
                for (int k = 0; k < 4; ++k) {
                    sum += t[i * 4 + k] * tmp[k * 4 + j];
                }
                m[i * 4 + j] = sum;
            }
        }
    }

    public static final void assignScale(double[] m, double s) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                m[i * 4 + j] = i == j ? s : 0.0;
            }
        }
        m[15] = 1.0;
    }

    public static final void assignScale(double[] m, double sx, double sy, double sz) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                m[i * 4 + j] = i == j ? (i == 0 ? sx : (i == 1 ? sy : (i == 2 ? sz : 1.0))) : 0.0;
            }
        }
        m[15] = 1.0;
    }

    public static final void assignRotationX(double[] m, double phi) {
        VecMat.assignIdentity(m);
        m[5] = m[10] = Math.cos(phi);
        m[6] = -Math.sin(phi);
        m[9] = -m[6];
    }

    public static final void assignRotationY(double[] m, double phi) {
        VecMat.assignIdentity(m);
        m[10] = m[0] = Math.cos(phi);
        m[8] = -Math.sin(phi);
        m[2] = -m[8];
    }

    public static final void assignRotationZ(double[] m, double phi) {
        VecMat.assignIdentity(m);
        m[0] = m[5] = Math.cos(phi);
        m[1] = -Math.sin(phi);
        m[4] = -m[1];
    }

    public static final void assignTranslation(double[] m, double[] v) {
        VecMat.assignIdentity(m);
        m[3] = v[0];
        m[7] = v[1];
        m[11] = v[2];
    }

    public static final void assignTranslation(double[] m, double v0, double v1, double v2) {
        VecMat.assignIdentity(m);
        m[3] = v0;
        m[7] = v1;
        m[11] = v2;
    }

    public static void invert(double[] src, double[] dst) {
        int i;
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 3; ++j) {
                int i0 = (i2 + 1) % 3;
                int i1 = (i2 + 2) % 3;
                int j0 = (j + 1) % 3;
                int j1 = (j + 2) % 3;
                dst[4 * j + i2] = src[4 * i0 + j0] * src[4 * i1 + j1] - src[4 * i0 + j1] * src[4 * i1 + j0];
            }
        }
        double determinant = src[0] * dst[0] + src[4] * dst[1] + src[8] * dst[2];
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n = 4 * i + j;
                dst[n] = dst[n] / determinant;
            }
        }
        for (i = 0; i < 3; ++i) {
            dst[4 * i + 3] = -dst[4 * i + 0] * src[3] - dst[4 * i + 1] * src[7] - dst[4 * i + 2] * src[11];
        }
        dst[15] = 1.0;
    }

    public static void normalToEuler(double[] r, int i) {
        double x = r[i + 0];
        double y = r[i + 1];
        double z = r[i + 2];
        double xrot = 0.0;
        double zrot = 0.0;
        double yrot = 0.0;
        if (z * z + x * x - 1.0E-6 > 0.0) {
            xrot = Math.acos(y);
            yrot = Math.atan2(x, z);
        } else {
            xrot = y > 0.0 ? 0.0 : Math.PI;
        }
        r[i + 0] = xrot;
        r[i + 1] = yrot;
        r[i + 2] = zrot;
    }
}

