/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer;

import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import de.jreality.softviewer.Renderer;
import de.jreality.util.LoggingSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Level;

public class SoftViewer
extends Component
implements Runnable,
Viewer {
    private static final long serialVersionUID = 1L;
    private static final boolean ENFORCE_PAINT_ON_MOUSEEVENTS = false;
    private final Object renderAsyncLock = new Object();
    private final Object renderImplLock = new Object();
    private SceneGraphPath cameraPath;
    private SceneGraphComponent root;
    private SceneGraphComponent auxiliaryRoot;
    private transient BufferedImage offscreen;
    private Renderer renderer;
    private boolean upToDate = false;
    private boolean backgroundExplicitlySet;
    private boolean imageValid;
    private Image bgImage;
    private final boolean lazy;
    private boolean disposed;
    private int metric;
    private boolean isRendering = false;

    public SoftViewer() {
        this(false);
    }

    public SoftViewer(boolean lazy) {
        this.lazy = lazy;
        this.setBackground(Color.white);
        Thread renderThread = new Thread((Runnable)this, "jReality render thread");
        renderThread.start();
    }

    public boolean isFocusable() {
        return true;
    }

    public Object getViewingComponent() {
        return this;
    }

    public void setSceneRoot(SceneGraphComponent c) {
        this.root = c;
        if (this.renderer != null) {
            this.renderer.setSceneRoot(c);
        }
    }

    public SceneGraphComponent getSceneRoot() {
        return this.root;
    }

    public void render() {
        if (EventQueue.isDispatchThread() || this.lazy && this.isRendering) {
            return;
        }
        this.renderImpl(this.getSize(), false);
        this.paintImmediately();
    }

    public void invalidate() {
        super.invalidate();
        this.imageValid = false;
        this.upToDate = false;
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (!this.isShowing()) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        if (clip != null && clip.isEmpty()) {
            return;
        }
        SoftViewer softViewer = this;
        synchronized (softViewer) {
            if (this.imageValid) {
                if (this.offscreen != null) {
                    if (this.bgImage != null) {
                        g.drawImage(this.bgImage, 0, 0, Color.GREEN, null);
                    }
                    g.drawImage(this.offscreen, 0, 0, null);
                    return;
                }
                System.err.println("paint: no offscreen in paint");
            } else if (!this.upToDate) {
                Object object = this.renderAsyncLock;
                synchronized (object) {
                    this.renderAsyncLock.notify();
                }
            }
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!EventQueue.isDispatchThread()) {
            while (true) {
                try {
                    while (true) {
                        if (this.upToDate) {
                            try {
                                Object object = this.renderAsyncLock;
                                synchronized (object) {
                                    this.renderAsyncLock.wait();
                                }
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            if (!this.disposed) continue;
                            return;
                        }
                        this.upToDate = true;
                        this.renderImpl(this.getSize(), false);
                        if (!this.imageValid) continue;
                        EventQueue.invokeLater(this);
                    }
                }
                catch (Exception ex) {
                    Thread t = Thread.currentThread();
                    t.getThreadGroup().uncaughtException(t, ex);
                    continue;
                }
                break;
            }
        }
        this.paintImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderImpl(Dimension d, boolean quality) {
        Object object = this.renderImplLock;
        synchronized (object) {
            this.isRendering = true;
            if (d.width > 0 && d.height > 0) {
                Color c;
                if (this.offscreen == null || this.offscreen.getWidth() != d.width || this.offscreen.getHeight() != d.height) {
                    this.imageValid = false;
                    this.offscreen = new BufferedImage(d.width, d.height, 2);
                    this.offscreen.setAccelerationPriority(1.0f);
                    this.renderer = new Renderer(this.offscreen);
                    this.renderer.setBestQuality(quality);
                    c = this.getBackground();
                    this.renderer.setBackgroundColor(c != null ? c.getRGB() : 0);
                    this.renderer.setCameraPath(this.cameraPath);
                    this.renderer.setSceneRoot(this.root);
                    this.renderer.setAuxiliaryRoot(this.auxiliaryRoot);
                } else if (!this.backgroundExplicitlySet) {
                    c = this.getBackground();
                    this.renderer.setBackgroundColor(c != null ? c.getRGB() : 0);
                }
                try {
                    this.renderer.render();
                }
                catch (Exception e) {
                    LoggingSystem.getLogger(this).log(Level.SEVERE, "renderer.render() failed! ", e);
                }
                SoftViewer softViewer = this;
                synchronized (softViewer) {
                    this.renderer.update();
                    this.imageValid = true;
                }
            }
            this.isRendering = false;
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
    }

    public void addNotify() {
        super.addNotify();
        this.requestFocus();
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        switch (e.getID()) {
            case 500: 
            case 501: 
            case 502: {
                this.requestFocus();
            }
        }
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        boolean bl = this.backgroundExplicitlySet = c != null;
        if (this.backgroundExplicitlySet && this.renderer != null) {
            this.renderer.setBackgroundColor(c.getRGB());
        }
    }

    private void paintImmediately() {
        if (!this.isShowing()) {
            return;
        }
        Component c = this;
        Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        Container parent = c.getParent();
        while (parent != null && c.isLightweight()) {
            bounds.x += c.getX();
            bounds.y += c.getY();
            c = parent;
            parent = c.getParent();
        }
        Graphics gfx = c.getGraphics();
        gfx.setClip(bounds);
        c.paint(gfx);
    }

    public SceneGraphPath getCameraPath() {
        return this.cameraPath;
    }

    public void setCameraPath(SceneGraphPath p) {
        this.cameraPath = p;
        if (this.renderer != null) {
            this.renderer.setCameraPath(p);
        }
    }

    public boolean hasViewingComponent() {
        return true;
    }

    public void initializeFrom(Viewer v) {
        this.setSceneRoot(v.getSceneRoot());
        this.setCameraPath(v.getCameraPath());
        this.setAuxiliaryRoot(v.getAuxiliaryRoot());
    }

    public int getMetric() {
        return this.metric;
    }

    public void setMetric(int sig) {
        this.metric = sig;
    }

    public void setAuxiliaryRoot(SceneGraphComponent ar) {
        this.auxiliaryRoot = ar;
        if (this.renderer != null) {
            this.renderer.setAuxiliaryRoot(ar);
        }
    }

    public SceneGraphComponent getAuxiliaryRoot() {
        return this.auxiliaryRoot;
    }

    public Image getBackgroundImage() {
        return this.bgImage;
    }

    public void setBackgroundImage(Image bgImage) {
        this.bgImage = bgImage;
    }

    public Dimension getViewingComponentSize() {
        return this.getSize();
    }

    public boolean canRenderAsync() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAsync() {
        Object object = this.renderAsyncLock;
        synchronized (object) {
            if (this.upToDate) {
                this.upToDate = false;
                this.renderAsyncLock.notify();
            }
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.renderAsyncLock;
        synchronized (object) {
            this.disposed = true;
            this.renderAsyncLock.notify();
        }
        this.renderer = null;
    }

    public BufferedImage renderOffscreen(int width, int height) {
        this.renderImpl(new Dimension(width, height), true);
        BufferedImage bi = this.offscreen;
        return bi;
    }
}

