/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer;

import de.jreality.backends.label.LabelUtility;
import de.jreality.backends.texture.SimpleTexture;
import de.jreality.scene.Appearance;
import de.jreality.scene.ClippingPlane;
import de.jreality.scene.Cylinder;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointLight;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Sphere;
import de.jreality.scene.SpotLight;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultTextShader;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ImageData;
import de.jreality.shader.RenderingHintsShader;
import de.jreality.shader.ShaderUtility;
import de.jreality.softviewer.ClippingPlaneSoft;
import de.jreality.softviewer.DirectionalLightSoft;
import de.jreality.softviewer.Environment;
import de.jreality.softviewer.PrimitiveCache;
import de.jreality.softviewer.SpotLightSoft;
import de.jreality.softviewer.TrianglePipeline;
import de.jreality.softviewer.VecMat;
import de.jreality.softviewer.shader.DefaultPolygonShader;
import de.jreality.softviewer.shader.LineShader;
import de.jreality.softviewer.shader.PointShader;
import de.jreality.softviewer.shader.PolygonShader;
import de.jreality.util.CameraUtility;
import java.awt.Color;
import java.awt.Font;

public class RenderingVisitor
extends SceneGraphVisitor {
    private static final boolean POINT_SPHERES = true;
    private static final boolean LINE_CYLINDERS = true;
    private static final Cylinder CYLINDER = new Cylinder();
    private boolean shaderUptodate;
    protected Environment environment = new Environment();
    protected EffectiveAppearance eAppearance;
    double[] initialTrafo;
    double[] currentTrafo;
    private Transformation initialTransformation;
    protected LineShader lineShader;
    protected TrianglePipeline pipeline;
    protected PointShader pointShader;
    protected PolygonShader polygonShader;
    protected RenderingVisitor reclaimableSubcontext;
    private double levelOfDetail;
    private boolean bestQuality = false;
    private boolean transparencyEnabled = false;
    private ClippingPlaneSoft cps;
    double[] cmat = new double[16];
    double[] cnormal = new double[3];
    double[] ctrans = new double[3];
    double[] pmat = new double[16];
    double[] tmpTrafo = new double[16];
    private Sphere SPHERE = new Sphere();
    Appearance pApp = new Appearance();
    double[] p1 = new double[8];
    double[] p2 = new double[8];
    private final SceneGraphComponent labelComp = new SceneGraphComponent();

    public boolean isBestQuality() {
        return this.bestQuality;
    }

    public void setBestQuality(boolean bestQuality) {
        this.bestQuality = bestQuality;
    }

    public RenderingVisitor() {
        this.eAppearance = EffectiveAppearance.create();
    }

    protected RenderingVisitor(RenderingVisitor parentContext) {
        this.eAppearance = parentContext.eAppearance;
        this.initializeFromParentContext(parentContext);
    }

    public TrianglePipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(TrianglePipeline pipeline) {
        if (this.pipeline != null) {
            this.pipeline.setEnvironment(null);
        }
        this.pipeline = pipeline;
        pipeline.setEnvironment(this.environment);
    }

    protected void initializeFromParentContext(RenderingVisitor parentContext) {
        RenderingVisitor p = parentContext;
        this.environment = p.environment;
        this.eAppearance = parentContext.eAppearance;
        this.pipeline = p.pipeline;
        this.polygonShader = p.polygonShader;
        this.pipeline.setFaceShader(this.polygonShader);
        this.lineShader = p.lineShader;
        this.pipeline.setLineShader(this.lineShader);
        this.pointShader = p.pointShader;
        this.pipeline.setPointShader(this.pointShader);
        this.shaderUptodate = p.shaderUptodate;
        this.levelOfDetail = p.levelOfDetail;
        this.bestQuality = p.bestQuality;
        this.transparencyEnabled = p.transparencyEnabled;
        this.cps = null;
        this.initialTrafo = parentContext.currentTrafo;
        this.currentTrafo = parentContext.currentTrafo;
        this.pipeline.setMatrix(this.currentTrafo);
    }

    public void setInitialTransformation(Transformation initialTransformation) {
        this.initialTransformation = initialTransformation;
        this.environment.setInitialTransformation(initialTransformation);
    }

    RenderingVisitor subContext() {
        if (this.reclaimableSubcontext != null) {
            this.reclaimableSubcontext.initializeFromParentContext(this);
            return this.reclaimableSubcontext;
        }
        this.reclaimableSubcontext = new RenderingVisitor(this);
        return this.reclaimableSubcontext;
    }

    public void traverse(SceneGraphComponent root) {
        this.environment.removeAll();
        if (this.initialTrafo == null) {
            this.initialTrafo = new double[16];
        }
        if (this.initialTransformation != null) {
            this.initialTransformation.getMatrix(this.initialTrafo);
        } else {
            VecMat.assignIdentity(this.initialTrafo);
        }
        this.currentTrafo = this.initialTrafo;
        this.levelOfDetail = this.bestQuality ? 10000.0 : 1.0;
        this.environment.traverse(root);
        root.accept(this);
        this.pipeline.setMatrix(this.initialTrafo);
    }

    public void visit(SceneGraphComponent c) {
        if (c.isVisible()) {
            c.childrenAccept(this.subContext());
        }
        if (this.cps != null) {
            this.environment.removeClippingPlane(this.cps);
            this.cps = null;
        }
    }

    public void visit(ClippingPlane cp) {
        if (!cp.isLocal()) {
            return;
        }
        double[] direction = new double[3];
        VecMat.transformNormal(this.currentTrafo, 0.0, 0.0, -1.0, direction);
        VecMat.normalize(direction);
        double[] src = new double[3];
        VecMat.transform(this.currentTrafo, 0.0, 0.0, 0.0, src);
        this.environment.addClippingPlane(new ClippingPlaneSoft(direction, src));
    }

    public void visit(Transformation t) {
        if (this.initialTrafo == this.currentTrafo) {
            this.currentTrafo = new double[16];
        }
        VecMat.copyMatrix(this.initialTrafo, this.currentTrafo);
        VecMat.multiplyFromRight(this.currentTrafo, t.getMatrix());
        this.pipeline.setMatrix(this.currentTrafo);
    }

    public void visit(Appearance app) {
        Object te;
        Object lod;
        this.eAppearance = this.eAppearance.create(app);
        this.shaderUptodate = false;
        if (!this.bestQuality && (lod = app.getAttribute("levelOfDetail", Double.class)) instanceof Double) {
            this.levelOfDetail = (Double)lod;
        }
        if ((te = app.getAttribute("transparencyEnabled", Boolean.class)) instanceof Boolean) {
            this.transparencyEnabled = (Boolean)te;
        }
    }

    private void setupShader() {
        this.pipeline.setTransparencyEnabled(this.transparencyEnabled);
        DefaultGeometryShader gs = ShaderUtility.createDefaultGeometryShader(this.eAppearance);
        RenderingHintsShader rhs = ShaderUtility.createRenderingHintsShader(this.eAppearance);
        if (gs.getShowFaces().booleanValue()) {
            de.jreality.shader.PolygonShader pgs = gs.getPolygonShader();
            this.polygonShader = PolygonShader.createFrom(pgs, rhs);
            this.pipeline.setFaceShader(this.polygonShader);
        }
        if (gs.getShowLines().booleanValue()) {
            de.jreality.shader.LineShader lis = gs.getLineShader();
            this.lineShader = LineShader.createFrom(lis, rhs);
            this.pipeline.setLineShader(this.lineShader);
        }
        if (gs.getShowPoints().booleanValue()) {
            de.jreality.shader.PointShader pts = gs.getPointShader();
            this.pointShader = PointShader.createFrom(pts, rhs);
            this.pipeline.setPointShader(this.pointShader);
        }
        this.shaderUptodate = true;
    }

    public void visit(IndexedLineSet g) {
        if (!this.shaderUptodate) {
            this.setupShader();
        }
        DataList dl = g.getEdgeAttributes(Attribute.INDICES);
        DoubleArrayArray.Array edgeColor = null;
        double[][] edgeColours = null;
        double[] values1 = new double[3];
        double[] values2 = new double[3];
        if (this.lineShader != null && dl != null) {
            IntArrayArray edgeIndices = dl.toIntArrayArray();
            DoubleArrayArray vertices = g.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
            DataList radii = g.getEdgeAttributes(Attribute.RELATIVE_RADII);
            DataList colors = g.getEdgeAttributes(Attribute.COLORS);
            DataList vColors = g.getVertexAttributes(Attribute.COLORS);
            DoubleArray radiiArray = null;
            if (radii != null) {
                radiiArray = radii.toDoubleArray();
            }
            this.pipeline.startGeometry(g);
            PolygonShader dps = this.lineShader.getPolygonShader();
            int n = edgeIndices.size();
            for (int i = 0; i < n; ++i) {
                IntArray edge = edgeIndices.item(i).toIntArray();
                double radius = this.lineShader.getTubeRadius();
                if (this.lineShader.isRadiiWorldCoordinates()) {
                    radius /= CameraUtility.getScalingFactor(this.currentTrafo, 0);
                }
                if (radiiArray != null) {
                    radius *= radiiArray.getValueAt(i);
                }
                for (int j = 0; j < edge.getLength() - 1; ++j) {
                    DoubleArray p1 = vertices.item(edge.getValueAt(j)).toDoubleArray();
                    DoubleArray p2 = vertices.item(edge.getValueAt(j + 1)).toDoubleArray();
                    DoubleArray c1 = null;
                    DoubleArray c2 = null;
                    if (vColors != null) {
                        c1 = vColors.item(edge.getValueAt(j)).toDoubleArray();
                        c2 = vColors.item(edge.getValueAt(j + 1)).toDoubleArray();
                        c1.toDoubleArray(values1);
                        c2.toDoubleArray(values2);
                        if (edgeColours == null) {
                            edgeColours = new double[2][values1.length];
                        }
                        System.arraycopy(values1, 0, edgeColours[0], 0, values1.length);
                        System.arraycopy(values2, 0, edgeColours[1], 0, values2.length);
                        edgeColor = new DoubleArrayArray.Array(edgeColours);
                    }
                    if (this.lineShader.isDrawTubes()) {
                        double red = dps.getRed();
                        double green = dps.getGreen();
                        double blue = dps.getBlue();
                        if (colors != null) {
                            DoubleArray cc = colors.item(i).toDoubleArray();
                            dps.setColor(cc.getValueAt(0), cc.getValueAt(1), cc.getValueAt(2));
                        }
                        this.pipeline.setFaceShader(dps);
                        this.cylinder2(p1, p2, radius);
                        dps.setColor(red, green, blue);
                        this.pipeline.setFaceShader(this.polygonShader);
                        continue;
                    }
                    if (colors != null) {
                        DoubleArray cc = colors.item(i).toDoubleArray();
                        dps.setColor(cc.getValueAt(0), cc.getValueAt(1), cc.getValueAt(2));
                    }
                    this.pipeline.processLine(p1, p2, edgeColor);
                }
            }
            if (g.getEdgeAttributes(Attribute.LABELS) != null) {
                Class shaderType = (Class)this.eAppearance.getAttribute(ShaderUtility.nameSpace("lineShader", "textShader"), DefaultTextShader.class);
                DefaultTextShader ts = (DefaultTextShader)AttributeEntityUtility.createAttributeEntity(shaderType, ShaderUtility.nameSpace("lineShader", "textShader"), this.eAppearance);
                Font font = ts.getFont();
                Color c = ts.getDiffuseColor();
                double scale = ts.getScale();
                double[] offset = ts.getOffset();
                int alignment = ts.getAlignment();
                int textdirection = ts.getTextdirection();
                this.renderLabels(scale, offset, alignment, textdirection, LabelUtility.createEdgeImages(g, font, c), g.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(), g.getEdgeAttributes(Attribute.INDICES).toIntArrayArray());
            }
        }
        this.visit((PointSet)g);
    }

    private void cylinder(DoubleArray p1, DoubleArray p2, double radius) {
        double w1 = p1.size() == 4 ? 1.0 / p1.getValueAt(3) : 1.0;
        double w2 = p2.size() == 4 ? 1.0 / p2.getValueAt(3) : 1.0;
        this.cnormal[0] = 0.5 * (p2.getValueAt(0) * w2 - p1.getValueAt(0) * w1);
        this.cnormal[1] = 0.5 * (p2.getValueAt(1) * w2 - p1.getValueAt(1) * w1);
        this.cnormal[2] = 0.5 * (p2.getValueAt(2) * w2 - p1.getValueAt(2) * w1);
        this.ctrans[0] = p1.getValueAt(0) * w1 + this.cnormal[0];
        this.ctrans[1] = p1.getValueAt(1) * w1 + this.cnormal[1];
        this.ctrans[2] = p1.getValueAt(2) * w1 + this.cnormal[2];
        double d = VecMat.norm(this.cnormal);
        if (d != 0.0) {
            VecMat.normalize(this.cnormal);
        }
        VecMat.normalToEuler(this.cnormal, 0);
        VecMat.copyMatrix(this.currentTrafo, this.tmpTrafo);
        VecMat.assignTranslation(this.cmat, this.ctrans);
        VecMat.multiplyFromRight(this.tmpTrafo, this.cmat);
        VecMat.assignRotationZ(this.cmat, this.cnormal[2]);
        VecMat.multiplyFromRight(this.tmpTrafo, this.cmat);
        VecMat.assignRotationY(this.cmat, this.cnormal[1]);
        VecMat.multiplyFromRight(this.tmpTrafo, this.cmat);
        VecMat.assignRotationX(this.cmat, this.cnormal[0] + 1.5707963267948966);
        VecMat.multiplyFromRight(this.tmpTrafo, this.cmat);
        VecMat.assignScale(this.cmat, radius, radius, d);
        VecMat.multiplyFromRight(this.tmpTrafo, this.cmat);
        this.pipeline.setMatrix(this.tmpTrafo);
        this.visit(CYLINDER);
        this.pipeline.setMatrix(this.currentTrafo);
    }

    private void cylinder2(DoubleArray p1, DoubleArray p2, double radius) {
        double w2;
        double w1 = p1.size() == 4 ? p1.getValueAt(3) : 1.0;
        double d = w2 = p2.size() == 4 ? p2.getValueAt(3) : 1.0;
        if (w1 != 0.0 && w2 != 0.0) {
            this.cylinder(p1, p2, radius);
            return;
        }
        if (w1 == 0.0) {
            if (w2 == 0.0) {
                return;
            }
            w1 = w2;
            w2 = 0.0;
            DoubleArray tmp = p1;
            p1 = p2;
            p2 = tmp;
        }
        this.cnormal[0] = -(p2.getValueAt(0) * w1 - p1.getValueAt(0) * w2);
        this.cnormal[1] = -(p2.getValueAt(1) * w1 - p1.getValueAt(1) * w2);
        this.cnormal[2] = -(p2.getValueAt(2) * w1 - p1.getValueAt(2) * w2);
        this.ctrans[0] = p1.getValueAt(0) / w1;
        this.ctrans[1] = p1.getValueAt(1) / w1;
        this.ctrans[2] = p1.getValueAt(2) / w1;
        double d2 = VecMat.norm(this.cnormal);
        if (d2 == 0.0) {
            return;
        }
        VecMat.normalize(this.cnormal);
        VecMat.normalToEuler(this.cnormal, 0);
        VecMat.copyMatrix(this.currentTrafo, this.tmpTrafo);
        VecMat.assignTranslation(this.cmat, this.ctrans);
        VecMat.multiplyFromRight(this.tmpTrafo, this.cmat);
        VecMat.assignRotationY(this.cmat, this.cnormal[1]);
        VecMat.multiplyFromRight(this.tmpTrafo, this.cmat);
        VecMat.assignRotationX(this.cmat, this.cnormal[0] + 1.5707963267948966);
        VecMat.multiplyFromRight(this.tmpTrafo, this.cmat);
        VecMat.assignScale(this.cmat, radius, radius, 1.0);
        VecMat.multiplyFromRight(this.tmpTrafo, this.cmat);
        this.pipeline.setMatrix(this.tmpTrafo);
        if (!this.shaderUptodate) {
            this.setupShader();
        }
        LineShader lso = this.lineShader;
        this.lineShader = null;
        PointShader pso = this.pointShader;
        this.pointShader = null;
        this.pipeline.startGeometry(CYLINDER);
        double l = this.lod(1.0);
        PrimitiveCache.renderCylinder2(this.pipeline, l * this.levelOfDetail);
        this.pointShader = pso;
        this.lineShader = lso;
        this.pipeline.setMatrix(this.currentTrafo);
    }

    public void visit(IndexedFaceSet ifs) {
        if (!this.shaderUptodate) {
            this.setupShader();
        }
        if (this.polygonShader != null) {
            DataList indices = ifs.getFaceAttributes(Attribute.INDICES);
            if (indices != null) {
                DoubleArrayArray points = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
                DoubleArrayArray normals = null;
                DataList vndl = ifs.getVertexAttributes(Attribute.NORMALS);
                if (vndl != null) {
                    normals = vndl.toDoubleArrayArray();
                }
                DataList texCoords = ifs.getVertexAttributes(Attribute.TEXTURE_COORDINATES);
                this.pipeline.startGeometry(ifs);
                DoubleArrayArray faceNormals = null;
                DataList fndl = ifs.getFaceAttributes(Attribute.NORMALS);
                if (fndl != null) {
                    faceNormals = fndl.toDoubleArrayArray();
                }
                DataList vertexColors = ifs.getVertexAttributes(Attribute.COLORS);
                DataList faceColors = ifs.getFaceAttributes(Attribute.COLORS);
                int im = ifs.getNumFaces();
                for (int i = 0; i < im; ++i) {
                    IntArray faceIndices = indices.item(i).toIntArray();
                    DoubleArray faceNormal = null;
                    if (fndl != null) {
                        faceNormal = faceNormals.item(i).toDoubleArray();
                    }
                    DoubleArray faceColor = null;
                    if (faceColors != null) {
                        faceColor = faceColors.item(i).toDoubleArray();
                    }
                    this.pipeline.processPolygon(points, faceIndices, normals, faceIndices, texCoords, vertexColors, faceNormal, faceColor);
                }
            }
            if (ifs.getFaceAttributes(Attribute.LABELS) != null) {
                Class shaderType = (Class)this.eAppearance.getAttribute(ShaderUtility.nameSpace("polygonShader", "textShader"), DefaultTextShader.class);
                DefaultTextShader ts = (DefaultTextShader)AttributeEntityUtility.createAttributeEntity(shaderType, ShaderUtility.nameSpace("polygonShader", "textShader"), this.eAppearance);
                Font font = ts.getFont();
                Color c = ts.getDiffuseColor();
                double scale = ts.getScale();
                double[] offset = ts.getOffset();
                int alignment = ts.getAlignment();
                int textdirection = ts.getTextdirection();
                this.renderLabels(scale, offset, alignment, textdirection, LabelUtility.createFaceImages(ifs, font, c), ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(), ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray());
            }
        }
        this.visit((IndexedLineSet)ifs);
    }

    public void visit(PointSet p) {
        if (!this.shaderUptodate) {
            this.setupShader();
        }
        DoubleArrayArray a = null;
        int n = p.getNumPoints();
        if (this.pointShader != null) {
            int i;
            a = p.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
            if (a == null) {
                return;
            }
            this.pipeline.startGeometry(p);
            DataList vertexColors = p.getVertexAttributes(Attribute.COLORS);
            DataList vertexRadii = p.getVertexAttributes(Attribute.RELATIVE_RADII);
            if (!this.pointShader.isSphereDraw()) {
                for (i = 0; i < n; ++i) {
                    this.pipeline.processPoint(a, i, vertexColors, vertexRadii);
                }
            } else {
                for (i = 0; i < n; ++i) {
                    double r = this.pointShader.getPointRadius();
                    if (this.pointShader.isRadiiWorldCoordinates()) {
                        r /= CameraUtility.getScalingFactor(this.currentTrafo, 0);
                    }
                    this.pmat[5] = this.pmat[10] = (r *= vertexRadii != null ? vertexRadii.toDoubleArray().getValueAt(i) : 1.0);
                    this.pmat[0] = this.pmat[10];
                    DoubleArray da = a.item(i).toDoubleArray();
                    this.pmat[3] = da.getValueAt(0);
                    this.pmat[7] = da.getValueAt(1);
                    this.pmat[11] = da.getValueAt(2);
                    double d = this.pmat[15] = da.size() == 4 ? da.getValueAt(3) : 1.0;
                    if (this.pmat[15] == 0.0) {
                        return;
                    }
                    VecMat.copyMatrix(this.currentTrafo, this.tmpTrafo);
                    VecMat.multiplyFromRight(this.tmpTrafo, this.pmat);
                    this.pipeline.setMatrix(this.tmpTrafo);
                    PolygonShader dps = this.pointShader.getCoreShader();
                    double red = dps.getRed();
                    double g = dps.getGreen();
                    double b = dps.getBlue();
                    if (vertexColors != null) {
                        DoubleArray cc = vertexColors.item(i).toDoubleArray();
                        dps.setColor(cc.getValueAt(0), cc.getValueAt(1), cc.getValueAt(2));
                    }
                    this.pipeline.setFaceShader(dps);
                    this.visit(this.SPHERE);
                    dps.setColor(red, g, b);
                    this.pipeline.setFaceShader(this.polygonShader);
                    this.pipeline.setMatrix(this.currentTrafo);
                }
            }
            if (p.getVertexAttributes(Attribute.LABELS) != null) {
                Class shaderType = (Class)this.eAppearance.getAttribute(ShaderUtility.nameSpace("pointShader", "textShader"), DefaultTextShader.class);
                DefaultTextShader ts = (DefaultTextShader)AttributeEntityUtility.createAttributeEntity(shaderType, ShaderUtility.nameSpace("pointShader", "textShader"), this.eAppearance);
                Font font = ts.getFont();
                Color c = ts.getDiffuseColor();
                double scale = ts.getScale();
                double[] offset = ts.getOffset();
                int alignment = ts.getAlignment();
                int textdirection = ts.getTextdirection();
                this.renderLabels(scale, offset, alignment, textdirection, LabelUtility.createPointImages(p, font, c), a, null);
            }
        }
    }

    private double lod(double r) {
        this.p2[2] = 0.0;
        this.p2[1] = 0.0;
        this.p1[2] = 0.0;
        this.p1[1] = 0.0;
        this.p1[0] = 0.0;
        this.p2[0] = r;
        this.p2[3] = 1.0;
        this.p1[3] = 1.0;
        this.pipeline.transformNDC(this.p1, this.p2);
        this.p1[0] = this.p1[4];
        this.p1[1] = this.p1[5];
        this.p1[2] = this.p1[6];
        VecMat.multiply(this.p1, 1.0 / this.p1[7]);
        this.p2[0] = this.p2[4];
        this.p2[1] = this.p2[5];
        this.p2[2] = this.p2[6];
        VecMat.multiply(this.p2, 1.0 / this.p2[7]);
        VecMat.vecAssignMinus(this.p2, this.p1);
        return VecMat.norm(this.p2);
    }

    private void renderLabels(double scale, double[] offset, int alignment, int textdirection, ImageData[] imgs, DoubleArrayArray vertices, IntArrayArray indices) {
        if (imgs == null) {
            return;
        }
        double[] storeMatrix = (double[])this.currentTrafo.clone();
        PolygonShader storePS = this.polygonShader;
        PointShader storePtS = this.pointShader;
        LineShader storeLS = this.lineShader;
        this.pointShader = null;
        this.pipeline.setPointShader(null);
        this.lineShader = null;
        this.pipeline.setLineShader(null);
        EffectiveAppearance storeEA = this.eAppearance;
        this.eAppearance = EffectiveAppearance.create();
        double[] m = new double[16];
        VecMat.invert(this.currentTrafo, m);
        int max = imgs.length;
        for (int i = 0; i < max; ++i) {
            ImageData img = imgs[i];
            SceneGraphComponent sgc = LabelUtility.sceneGraphForLabel(this.labelComp, (double)img.getWidth() * scale, (double)img.getHeight() * scale, offset, alignment, textdirection, m, LabelUtility.positionFor(i, vertices, indices));
            DefaultPolygonShader labelShader = new DefaultPolygonShader();
            labelShader.setTexture(new SimpleTexture(img));
            this.polygonShader = labelShader;
            this.pipeline.setFaceShader(this.polygonShader);
            this.pipeline.setTransparencyEnabled(true);
            sgc.accept(this);
        }
        this.polygonShader = storePS;
        this.pipeline.setFaceShader(this.polygonShader);
        this.pointShader = storePtS;
        this.pipeline.setPointShader(this.pointShader);
        this.lineShader = storeLS;
        this.pipeline.setLineShader(this.lineShader);
        this.eAppearance = storeEA;
        this.currentTrafo = storeMatrix;
        this.pipeline.setMatrix(storeMatrix);
    }

    public void visit(Sphere s) {
        if (!this.shaderUptodate) {
            this.setupShader();
        }
        LineShader lso = this.lineShader;
        this.lineShader = null;
        PointShader pso = this.pointShader;
        this.pointShader = null;
        this.pipeline.startGeometry(s);
        double l = this.lod(1.0);
        PrimitiveCache.renderSphere(this.pipeline, l * this.levelOfDetail);
        this.pointShader = pso;
        this.lineShader = lso;
    }

    public void visit(Cylinder c) {
        if (!this.shaderUptodate) {
            this.setupShader();
        }
        LineShader lso = this.lineShader;
        this.lineShader = null;
        PointShader pso = this.pointShader;
        this.pointShader = null;
        this.pipeline.startGeometry(c);
        double l = this.lod(1.0);
        PrimitiveCache.renderCylinder(this.pipeline, l * this.levelOfDetail);
        this.pointShader = pso;
        this.lineShader = lso;
    }

    public void visit(DirectionalLight l) {
        super.visit(l);
        if (l.isGlobal()) {
            return;
        }
        float[] color = l.getColor().getRGBColorComponents(null);
        double[] direction = new double[3];
        VecMat.transformNormal(this.currentTrafo, 0.0, 0.0, 1.0, direction);
        VecMat.normalize(direction);
        this.environment.addDirectionalLight(new DirectionalLightSoft(color[0], color[1], color[2], l.getIntensity(), direction));
    }

    public void visit(PointLight l) {
        super.visit(l);
        if (l.isGlobal()) {
            return;
        }
        float[] color = l.getColor().getRGBColorComponents(null);
        double[] direction = new double[3];
        VecMat.transformNormal(this.currentTrafo, 0.0, 0.0, -1.0, direction);
        VecMat.normalize(direction);
        double[] src = new double[3];
        VecMat.transform(this.currentTrafo, 0.0, 0.0, 0.0, src);
        this.environment.addSpotLight(new SpotLightSoft(color[0], color[1], color[2], l.getIntensity(), direction, src, Math.PI, 0.0, l.getFalloffA0(), l.getFalloffA1(), l.getFalloffA2()));
    }

    public void visit(SpotLight l) {
        if (l.isGlobal()) {
            return;
        }
        float[] color = l.getColor().getRGBColorComponents(null);
        double[] direction = new double[3];
        VecMat.transformNormal(this.currentTrafo, 0.0, 0.0, -1.0, direction);
        VecMat.normalize(direction);
        double[] src = new double[3];
        VecMat.transform(this.currentTrafo, 0.0, 0.0, 0.0, src);
        this.environment.addSpotLight(new SpotLightSoft(color[0], color[1], color[2], l.getIntensity(), direction, src, l.getConeAngle(), l.getConeDeltaAngle(), l.getFalloffA0(), l.getFalloffA1(), l.getFalloffA2()));
    }
}

