/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.softviewer;

import de.jreality.softviewer.Triangle;
import de.jreality.softviewer.TriangleRasterizer;
import java.awt.Color;
import java.io.PrintWriter;

public class PSRasterizer
extends TriangleRasterizer {
    public static final String NONE = "none";
    private int background;
    private int xmin;
    private int xmax;
    private int ymin;
    private int ymax;
    private double wh;
    private double hh;
    private double mh;
    private int pLength = 0;
    private double[][] triangle = new double[3][17];
    protected double transparency = 0.0;
    protected double oneMinusTransparency = 1.0;
    private PrintWriter writer;
    private int count;

    public PSRasterizer(PrintWriter w) {
        this.writer = w;
    }

    public void renderTriangle(Triangle t, boolean outline) {
        this.transparency = t.getTransparency();
        this.oneMinusTransparency = 1.0 - this.transparency;
        for (int i = 0; i < 3; ++i) {
            double[] pi = this.triangle[i];
            double[] vertexData = t.getPoint(i);
            double w = 1.0 / vertexData[7];
            double wxy = w * this.mh;
            pi[4] = this.wh + vertexData[4] * wxy;
            pi[5] = this.hh - vertexData[5] * wxy;
            pi[6] = vertexData[6] * w;
            pi[8] = vertexData[8] > 1.0 ? 255.0 : 255.0 * vertexData[8];
            pi[9] = vertexData[9] > 1.0 ? 255.0 : 255.0 * vertexData[9];
            pi[10] = vertexData[10] > 1.0 ? 255.0 : 255.0 * vertexData[10];
        }
        this.writePolygon(this.triangle);
        ++this.count;
    }

    private void writePolygon(double[][] polygon) {
        this.writer.print("[");
        for (int i = 0; i < 3; ++i) {
            this.writer.print(" 0");
            this.writer.print(" " + polygon[i][4]);
            this.writer.print(" " + ((double)(this.ymax - this.ymin) - polygon[i][5]));
            this.writer.print(" " + polygon[i][8] / 255.0);
            this.writer.print(" " + polygon[i][9] / 255.0);
            this.writer.println(" " + polygon[i][10] / 255.0);
        }
        this.writer.println(" f");
    }

    private void linePolygon(double[][] p) {
        this.writer.println("\n" + p[0][4] + " " + ((double)(this.ymax - this.ymin) - p[0][5]) + " moveto");
        for (int i = 1; i < this.pLength; ++i) {
            this.writer.println(p[i][4] + " " + ((double)(this.ymax - this.ymin) - p[i][5]) + " lineto");
        }
        this.writer.println("\n" + p[0][4] + " " + ((double)(this.ymax - this.ymin) - p[0][5]) + " lineto");
        this.writer.println("stroke");
    }

    public void setBackground(int argb) {
        this.background = argb;
    }

    public int getBackground() {
        return this.background;
    }

    public void clear(boolean clearBackground) {
    }

    public void start() {
        System.out.println("Writing ps file. This may take a while if there are a lot of intersecting triangles.");
        this.count = 0;
        this.writer.println("%!PS-Adobe-3.0 EPSF-3.0\n%%Creator: jReality");
        this.writer.println("%%LanguageLevel: 3");
        this.writer.println("%%BoundingBox: " + this.xmin + " " + this.ymin + " " + (this.xmax - this.xmin) + " " + (this.ymax - this.ymin) + "\n%%EndComments");
        this.writer.println("gsave\n");
        this.writer.println("2 dict begin\n/d <<\n/ColorSpace [/DeviceRGB]\n/ShadingType 4\n/DataSource []\n>> def\n");
        this.writer.println("/f { ]d exch /DataSource exch put d shfill } bind def");
    }

    public void stop() {
        this.writer.println("\nend\ngrestore");
    }

    public void setWindow(int xmin, int xmax, int ymin, int ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public void setSize(double width, double height) {
        this.wh = width / 2.0;
        this.hh = height / 2.0;
        this.mh = Math.min(this.wh, this.hh);
    }

    public void setBackgroundColors(Color[] c) {
    }

    public void setTransparencyEnabled(boolean transparencyEnabled) {
    }

    public double getMinDim() {
        return 2.0 * this.mh;
    }
}

